/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.sonatype.aether.impl.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.gradle.internal.impldep.org.codehaus.plexus.component.annotations.Component;
import org.gradle.internal.impldep.org.codehaus.plexus.component.annotations.Requirement;
import org.gradle.internal.impldep.org.sonatype.aether.RepositoryException;
import org.gradle.internal.impldep.org.sonatype.aether.RepositorySystemSession;
import org.gradle.internal.impldep.org.sonatype.aether.RequestTrace;
import org.gradle.internal.impldep.org.sonatype.aether.artifact.Artifact;
import org.gradle.internal.impldep.org.sonatype.aether.collection.CollectRequest;
import org.gradle.internal.impldep.org.sonatype.aether.collection.CollectResult;
import org.gradle.internal.impldep.org.sonatype.aether.collection.DependencyCollectionException;
import org.gradle.internal.impldep.org.sonatype.aether.collection.DependencyGraphTransformer;
import org.gradle.internal.impldep.org.sonatype.aether.collection.DependencyManagement;
import org.gradle.internal.impldep.org.sonatype.aether.collection.DependencyManager;
import org.gradle.internal.impldep.org.sonatype.aether.collection.DependencySelector;
import org.gradle.internal.impldep.org.sonatype.aether.collection.DependencyTraverser;
import org.gradle.internal.impldep.org.sonatype.aether.graph.Dependency;
import org.gradle.internal.impldep.org.sonatype.aether.impl.ArtifactDescriptorReader;
import org.gradle.internal.impldep.org.sonatype.aether.impl.DependencyCollector;
import org.gradle.internal.impldep.org.sonatype.aether.impl.RemoteRepositoryManager;
import org.gradle.internal.impldep.org.sonatype.aether.impl.VersionRangeResolver;
import org.gradle.internal.impldep.org.sonatype.aether.impl.internal.CachingArtifactTypeRegistry;
import org.gradle.internal.impldep.org.sonatype.aether.impl.internal.DataPool;
import org.gradle.internal.impldep.org.sonatype.aether.impl.internal.DefaultDependencyCollectionContext;
import org.gradle.internal.impldep.org.sonatype.aether.impl.internal.DefaultDependencyGraphTransformationContext;
import org.gradle.internal.impldep.org.sonatype.aether.impl.internal.EdgeStack;
import org.gradle.internal.impldep.org.sonatype.aether.impl.internal.GraphEdge;
import org.gradle.internal.impldep.org.sonatype.aether.impl.internal.GraphNode;
import org.gradle.internal.impldep.org.sonatype.aether.repository.ArtifactRepository;
import org.gradle.internal.impldep.org.sonatype.aether.repository.RemoteRepository;
import org.gradle.internal.impldep.org.sonatype.aether.resolution.ArtifactDescriptorException;
import org.gradle.internal.impldep.org.sonatype.aether.resolution.ArtifactDescriptorRequest;
import org.gradle.internal.impldep.org.sonatype.aether.resolution.ArtifactDescriptorResult;
import org.gradle.internal.impldep.org.sonatype.aether.resolution.VersionRangeRequest;
import org.gradle.internal.impldep.org.sonatype.aether.resolution.VersionRangeResolutionException;
import org.gradle.internal.impldep.org.sonatype.aether.resolution.VersionRangeResult;
import org.gradle.internal.impldep.org.sonatype.aether.spi.locator.Service;
import org.gradle.internal.impldep.org.sonatype.aether.spi.locator.ServiceLocator;
import org.gradle.internal.impldep.org.sonatype.aether.spi.log.Logger;
import org.gradle.internal.impldep.org.sonatype.aether.spi.log.NullLogger;
import org.gradle.internal.impldep.org.sonatype.aether.util.DefaultRepositorySystemSession;
import org.gradle.internal.impldep.org.sonatype.aether.util.DefaultRequestTrace;
import org.gradle.internal.impldep.org.sonatype.aether.version.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=DependencyCollector.class)
public class DefaultDependencyCollector
implements DependencyCollector,
Service {
    @Requirement
    private Logger logger = NullLogger.INSTANCE;
    @Requirement
    private RemoteRepositoryManager remoteRepositoryManager;
    @Requirement
    private ArtifactDescriptorReader descriptorReader;
    @Requirement
    private VersionRangeResolver versionRangeResolver;

    public DefaultDependencyCollector() {
    }

    public DefaultDependencyCollector(Logger logger, RemoteRepositoryManager remoteRepositoryManager, ArtifactDescriptorReader artifactDescriptorReader, VersionRangeResolver versionRangeResolver) {
        this.setLogger(logger);
        this.setRemoteRepositoryManager(remoteRepositoryManager);
        this.setArtifactDescriptorReader(artifactDescriptorReader);
        this.setVersionRangeResolver(versionRangeResolver);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setLogger(locator.getService(Logger.class));
        this.setRemoteRepositoryManager(locator.getService(RemoteRepositoryManager.class));
        this.setArtifactDescriptorReader(locator.getService(ArtifactDescriptorReader.class));
        this.setVersionRangeResolver(locator.getService(VersionRangeResolver.class));
    }

    public DefaultDependencyCollector setLogger(Logger logger) {
        this.logger = logger != null ? logger : NullLogger.INSTANCE;
        return this;
    }

    public DefaultDependencyCollector setRemoteRepositoryManager(RemoteRepositoryManager remoteRepositoryManager) {
        if (remoteRepositoryManager == null) {
            throw new IllegalArgumentException("remote repository manager has not been specified");
        }
        this.remoteRepositoryManager = remoteRepositoryManager;
        return this;
    }

    public DefaultDependencyCollector setArtifactDescriptorReader(ArtifactDescriptorReader artifactDescriptorReader) {
        if (artifactDescriptorReader == null) {
            throw new IllegalArgumentException("artifact descriptor reader has not been specified");
        }
        this.descriptorReader = artifactDescriptorReader;
        return this;
    }

    public DefaultDependencyCollector setVersionRangeResolver(VersionRangeResolver versionRangeResolver) {
        if (versionRangeResolver == null) {
            throw new IllegalArgumentException("version range resolver has not been specified");
        }
        this.versionRangeResolver = versionRangeResolver;
        return this;
    }

    @Override
    public CollectResult collectDependencies(RepositorySystemSession session, CollectRequest request) throws DependencyCollectionException {
        boolean traverse;
        session = this.optimizeSession(session);
        RequestTrace trace = DefaultRequestTrace.newChild(request.getTrace(), request);
        CollectResult result = new CollectResult(request);
        DependencySelector depSelector = session.getDependencySelector();
        DependencyManager depManager = session.getDependencyManager();
        DependencyTraverser depTraverser = session.getDependencyTraverser();
        Dependency root = request.getRoot();
        List<RemoteRepository> repositories = request.getRepositories();
        List<Dependency> dependencies = request.getDependencies();
        List<Dependency> managedDependencies = request.getManagedDependencies();
        GraphEdge edge = null;
        if (root != null) {
            ArtifactDescriptorResult descriptorResult;
            VersionRangeResult rangeResult;
            try {
                VersionRangeRequest rangeRequest = new VersionRangeRequest(root.getArtifact(), request.getRepositories(), request.getRequestContext());
                rangeRequest.setTrace(trace);
                rangeResult = this.versionRangeResolver.resolveVersionRange(session, rangeRequest);
                if (rangeResult.getVersions().isEmpty()) {
                    throw new VersionRangeResolutionException(rangeResult, "No versions available for " + root.getArtifact() + " within specified range");
                }
            }
            catch (VersionRangeResolutionException e) {
                result.addException(e);
                throw new DependencyCollectionException(result);
            }
            Version version = rangeResult.getVersions().get(rangeResult.getVersions().size() - 1);
            root = root.setArtifact(root.getArtifact().setVersion(((Object)version).toString()));
            try {
                ArtifactDescriptorRequest descriptorRequest = new ArtifactDescriptorRequest();
                descriptorRequest.setArtifact(root.getArtifact());
                descriptorRequest.setRepositories(request.getRepositories());
                descriptorRequest.setRequestContext(request.getRequestContext());
                descriptorRequest.setTrace(trace);
                descriptorResult = this.isLackingDescriptor(root.getArtifact()) ? new ArtifactDescriptorResult(descriptorRequest) : this.descriptorReader.readArtifactDescriptor(session, descriptorRequest);
            }
            catch (ArtifactDescriptorException e) {
                result.addException(e);
                throw new DependencyCollectionException(result);
            }
            root = root.setArtifact(descriptorResult.getArtifact());
            repositories = this.remoteRepositoryManager.aggregateRepositories(session, repositories, descriptorResult.getRepositories(), true);
            dependencies = this.mergeDeps(dependencies, descriptorResult.getDependencies());
            managedDependencies = this.mergeDeps(managedDependencies, descriptorResult.getManagedDependencies());
            GraphNode node = new GraphNode();
            node.setAliases(descriptorResult.getAliases());
            node.setRepositories(request.getRepositories());
            edge = new GraphEdge(node);
            edge.setDependency(root);
            edge.setRequestContext(request.getRequestContext());
            edge.setRelocations(descriptorResult.getRelocations());
            edge.setVersionConstraint(rangeResult.getVersionConstraint());
            edge.setVersion(version);
        } else {
            edge = new GraphEdge(new GraphNode());
        }
        result.setRoot(edge);
        boolean bl = traverse = root == null || depTraverser.traverseDependency(root);
        if (traverse && !dependencies.isEmpty()) {
            DataPool pool = new DataPool(session);
            EdgeStack edges = new EdgeStack();
            edges.push(edge);
            DefaultDependencyCollectionContext context = new DefaultDependencyCollectionContext(session, root, managedDependencies);
            Args args = new Args(result, session, trace, pool, edges, context);
            this.process(args, dependencies, repositories, depSelector.deriveChildSelector(context), depManager.deriveChildManager(context), depTraverser.deriveChildTraverser(context));
        }
        DependencyGraphTransformer transformer = session.getDependencyGraphTransformer();
        try {
            DefaultDependencyGraphTransformationContext context = new DefaultDependencyGraphTransformationContext(session);
            result.setRoot(transformer.transformGraph(edge, context));
        }
        catch (RepositoryException e) {
            result.addException(e);
        }
        if (!result.getExceptions().isEmpty()) {
            throw new DependencyCollectionException(result);
        }
        return result;
    }

    private RepositorySystemSession optimizeSession(RepositorySystemSession session) {
        DefaultRepositorySystemSession optimized = new DefaultRepositorySystemSession(session);
        optimized.setArtifactTypeRegistry(CachingArtifactTypeRegistry.newInstance(session));
        return optimized;
    }

    private List<Dependency> mergeDeps(List<Dependency> dominant, List<Dependency> recessive) {
        List<Dependency> result;
        if (dominant == null || dominant.isEmpty()) {
            result = recessive;
        } else if (recessive == null || recessive.isEmpty()) {
            result = dominant;
        } else {
            result = new ArrayList<Dependency>(dominant.size() + recessive.size());
            HashSet<String> ids = new HashSet<String>();
            for (Dependency dependency : dominant) {
                ids.add(this.getId(dependency.getArtifact()));
                result.add(dependency);
            }
            for (Dependency dependency : recessive) {
                if (ids.contains(this.getId(dependency.getArtifact()))) continue;
                result.add(dependency);
            }
        }
        return result;
    }

    private String getId(Artifact a) {
        return a.getGroupId() + ':' + a.getArtifactId() + ':' + a.getClassifier() + ':' + a.getExtension();
    }

    private void process(Args args, List<Dependency> dependencies, List<RemoteRepository> repositories, DependencySelector depSelector, DependencyManager depManager, DependencyTraverser depTraverser) throws DependencyCollectionException {
        block4: for (Dependency dependency : dependencies) {
            boolean disableVersionManagement = false;
            List<Artifact> relocations = Collections.emptyList();
            block5: while (depSelector.selectDependency(dependency)) {
                VersionRangeResult rangeResult;
                DependencyManagement depMngt = depManager.manageDependency(dependency);
                String premanagedVersion = null;
                String premanagedScope = null;
                if (depMngt != null) {
                    Artifact artifact;
                    if (depMngt.getVersion() != null && !disableVersionManagement) {
                        artifact = dependency.getArtifact();
                        premanagedVersion = artifact.getVersion();
                        dependency = dependency.setArtifact(artifact.setVersion(depMngt.getVersion()));
                    }
                    if (depMngt.getProperties() != null) {
                        artifact = dependency.getArtifact();
                        dependency = dependency.setArtifact(artifact.setProperties(depMngt.getProperties()));
                    }
                    if (depMngt.getScope() != null) {
                        premanagedScope = dependency.getScope();
                        dependency = dependency.setScope(depMngt.getScope());
                    }
                    if (depMngt.getExclusions() != null) {
                        dependency = dependency.setExclusions(depMngt.getExclusions());
                    }
                }
                disableVersionManagement = false;
                boolean noDescriptor = this.isLackingDescriptor(dependency.getArtifact());
                boolean traverse = !noDescriptor && depTraverser.traverseDependency(dependency);
                try {
                    VersionRangeRequest rangeRequest = new VersionRangeRequest();
                    rangeRequest.setArtifact(dependency.getArtifact());
                    rangeRequest.setRepositories(repositories);
                    rangeRequest.setRequestContext(args.result.getRequest().getRequestContext());
                    rangeRequest.setTrace(args.trace);
                    Object key = args.pool.toKey(rangeRequest);
                    rangeResult = args.pool.getConstraint(key, rangeRequest);
                    if (rangeResult == null) {
                        rangeResult = this.versionRangeResolver.resolveVersionRange(args.session, rangeRequest);
                        args.pool.putConstraint(key, rangeResult);
                    }
                    if (rangeResult.getVersions().isEmpty()) {
                        throw new VersionRangeResolutionException(rangeResult, "No versions available for " + dependency.getArtifact() + " within specified range");
                    }
                }
                catch (VersionRangeResolutionException e) {
                    this.addException(args.result, e);
                    continue block4;
                }
                List<Version> versions = rangeResult.getVersions();
                for (Version version : versions) {
                    boolean recurse;
                    ArtifactDescriptorResult descriptorResult;
                    Dependency d;
                    Artifact originalArtifact;
                    block24: {
                        originalArtifact = dependency.getArtifact().setVersion(((Object)version).toString());
                        d = dependency.setArtifact(originalArtifact);
                        ArtifactDescriptorRequest descriptorRequest = new ArtifactDescriptorRequest();
                        descriptorRequest.setArtifact(d.getArtifact());
                        descriptorRequest.setRepositories(repositories);
                        descriptorRequest.setRequestContext(args.result.getRequest().getRequestContext());
                        descriptorRequest.setTrace(args.trace);
                        if (noDescriptor) {
                            descriptorResult = new ArtifactDescriptorResult(descriptorRequest);
                        } else {
                            Object key = args.pool.toKey(descriptorRequest);
                            descriptorResult = args.pool.getDescriptor(key, descriptorRequest);
                            if (descriptorResult == null) {
                                try {
                                    descriptorResult = this.descriptorReader.readArtifactDescriptor(args.session, descriptorRequest);
                                    args.pool.putDescriptor(key, descriptorResult);
                                    break block24;
                                }
                                catch (ArtifactDescriptorException e) {
                                    this.addException(args.result, e);
                                    args.pool.putDescriptor(key, e);
                                    continue;
                                }
                            }
                            if (descriptorResult == DataPool.NO_DESCRIPTOR) continue;
                        }
                    }
                    d = d.setArtifact(descriptorResult.getArtifact());
                    GraphNode node = args.edges.top().getTarget();
                    GraphEdge cycleEdge = args.edges.find(d.getArtifact());
                    if (cycleEdge != null) {
                        GraphEdge edge = new GraphEdge(cycleEdge.getTarget());
                        edge.setDependency(d);
                        edge.setScope(d.getScope());
                        edge.setPremanagedScope(premanagedScope);
                        edge.setPremanagedVersion(premanagedVersion);
                        edge.setRelocations(relocations);
                        edge.setVersionConstraint(rangeResult.getVersionConstraint());
                        edge.setVersion(version);
                        edge.setRequestContext(args.result.getRequest().getRequestContext());
                        node.getOutgoingEdges().add(edge);
                        continue;
                    }
                    if (!descriptorResult.getRelocations().isEmpty()) {
                        relocations = descriptorResult.getRelocations();
                        disableVersionManagement = originalArtifact.getGroupId().equals(d.getArtifact().getGroupId()) && originalArtifact.getArtifactId().equals(d.getArtifact().getArtifactId());
                        dependency = d;
                        continue block5;
                    }
                    d = args.pool.intern(d.setArtifact(args.pool.intern(d.getArtifact())));
                    DependencySelector childSelector = null;
                    DependencyManager childManager = null;
                    DependencyTraverser childTraverser = null;
                    List<RemoteRepository> childRepos = null;
                    Object key = null;
                    boolean bl = recurse = traverse && !descriptorResult.getDependencies().isEmpty();
                    if (recurse) {
                        DefaultDependencyCollectionContext context = args.collectionContext;
                        context.set(d, descriptorResult.getManagedDependencies());
                        childSelector = depSelector.deriveChildSelector(context);
                        childManager = depManager.deriveChildManager(context);
                        childTraverser = depTraverser.deriveChildTraverser(context);
                        childRepos = this.remoteRepositoryManager.aggregateRepositories(args.session, repositories, descriptorResult.getRepositories(), true);
                        key = args.pool.toKey(d.getArtifact(), childRepos, childSelector, childManager, childTraverser);
                    } else {
                        key = args.pool.toKey(d.getArtifact(), repositories);
                    }
                    ArtifactRepository repo = rangeResult.getRepository(version);
                    List<RemoteRepository> repos = repo instanceof RemoteRepository ? Collections.singletonList((RemoteRepository)repo) : (repo == null ? repositories : Collections.emptyList());
                    GraphNode child = args.pool.getNode(key);
                    if (child == null) {
                        child = new GraphNode();
                        child.setAliases(descriptorResult.getAliases());
                        child.setRepositories(repos);
                        args.pool.putNode(key, child);
                    } else {
                        recurse = false;
                        if (repos.size() < child.getRepositories().size()) {
                            child.setRepositories(repos);
                        }
                    }
                    GraphEdge edge = new GraphEdge(child);
                    edge.setDependency(d);
                    edge.setScope(d.getScope());
                    edge.setPremanagedScope(premanagedScope);
                    edge.setPremanagedVersion(premanagedVersion);
                    edge.setRelocations(relocations);
                    edge.setVersionConstraint(rangeResult.getVersionConstraint());
                    edge.setVersion(version);
                    edge.setRequestContext(args.result.getRequest().getRequestContext());
                    node.getOutgoingEdges().add(edge);
                    if (!recurse) continue;
                    args.edges.push(edge);
                    this.process(args, descriptorResult.getDependencies(), childRepos, childSelector, childManager, childTraverser);
                    args.edges.pop();
                }
                continue block4;
            }
        }
    }

    private boolean isLackingDescriptor(Artifact artifact) {
        return artifact.getProperty("localPath", null) != null;
    }

    private void addException(CollectResult result, Exception e) {
        if (result.getExceptions().size() < 100) {
            result.addException(e);
        }
    }

    static class Args {
        final CollectResult result;
        final RepositorySystemSession session;
        final RequestTrace trace;
        final DataPool pool;
        final EdgeStack edges;
        final DefaultDependencyCollectionContext collectionContext;

        public Args(CollectResult result, RepositorySystemSession session, RequestTrace trace, DataPool pool, EdgeStack edges, DefaultDependencyCollectionContext collectionContext) {
            this.result = result;
            this.session = session;
            this.trace = trace;
            this.pool = pool;
            this.edges = edges;
            this.collectionContext = collectionContext;
        }
    }
}

