/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.junit.platform.engine;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.gradle.internal.impldep.org.apiguardian.api.API;
import org.gradle.internal.impldep.org.junit.platform.commons.PreconditionViolationException;
import org.gradle.internal.impldep.org.junit.platform.commons.util.Preconditions;
import org.gradle.internal.impldep.org.junit.platform.commons.util.StringUtils;

@API(status=API.Status.STABLE, since="1.0")
public final class TestTag
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    public static final Set<String> RESERVED_CHARACTERS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(",", "(", ")", "&", "|", "!")));

    public static boolean isValid(String name) {
        if (name == null) {
            return false;
        }
        return !(name = name.trim()).isEmpty() && StringUtils.doesNotContainWhitespace(name) && StringUtils.doesNotContainIsoControlCharacter(name) && TestTag.doesNotContainReservedCharacter(name);
    }

    private static boolean doesNotContainReservedCharacter(String str) {
        return RESERVED_CHARACTERS.stream().noneMatch(str::contains);
    }

    public static TestTag create(String name) throws PreconditionViolationException {
        return new TestTag(name);
    }

    private TestTag(String name) {
        Preconditions.condition(TestTag.isValid(name), () -> String.format("Tag name [%s] must be syntactically valid", name));
        this.name = name.trim();
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TestTag) {
            TestTag that = (TestTag)obj;
            return Objects.equals(this.name, that.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }
}

