/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.transport;

import java.security.AccessController;
import org.gradle.internal.impldep.org.eclipse.jgit.errors.TransportException;
import org.gradle.internal.impldep.org.eclipse.jgit.transport.CredentialsProvider;
import org.gradle.internal.impldep.org.eclipse.jgit.transport.DefaultSshSessionFactory;
import org.gradle.internal.impldep.org.eclipse.jgit.transport.RemoteSession;
import org.gradle.internal.impldep.org.eclipse.jgit.transport.URIish;
import org.gradle.internal.impldep.org.eclipse.jgit.util.FS;
import org.gradle.internal.impldep.org.eclipse.jgit.util.SystemReader;

public abstract class SshSessionFactory {
    private static SshSessionFactory INSTANCE = new DefaultSshSessionFactory();

    public static SshSessionFactory getInstance() {
        return INSTANCE;
    }

    public static void setInstance(SshSessionFactory newFactory) {
        INSTANCE = newFactory != null ? newFactory : new DefaultSshSessionFactory();
    }

    public static String getLocalUserName() {
        return AccessController.doPrivileged(() -> SystemReader.getInstance().getProperty("user.name"));
    }

    public abstract RemoteSession getSession(URIish var1, CredentialsProvider var2, FS var3, int var4) throws TransportException;

    public void releaseSession(RemoteSession session) {
        session.disconnect();
    }
}

