/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.bouncycastle.openpgp;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gradle.internal.impldep.org.bouncycastle.bcpg.PublicSubkeyPacket;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPException;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPKeyPair;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPPublicKey;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPSecretKey;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPSignature;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.PGPDigestCalculator;

public class PGPKeyRingGenerator {
    List keys = new ArrayList();
    private PBESecretKeyEncryptor keyEncryptor;
    private PGPDigestCalculator checksumCalculator;
    private PGPKeyPair masterKey;
    private PGPSignatureSubpacketVector hashedPcks;
    private PGPSignatureSubpacketVector unhashedPcks;
    private PGPContentSignerBuilder keySignerBuilder;

    public PGPKeyRingGenerator(int n, PGPKeyPair pGPKeyPair, String string, PGPDigestCalculator pGPDigestCalculator, PGPSignatureSubpacketVector pGPSignatureSubpacketVector, PGPSignatureSubpacketVector pGPSignatureSubpacketVector2, PGPContentSignerBuilder pGPContentSignerBuilder, PBESecretKeyEncryptor pBESecretKeyEncryptor) throws PGPException {
        this.masterKey = pGPKeyPair;
        this.keyEncryptor = pBESecretKeyEncryptor;
        this.checksumCalculator = pGPDigestCalculator;
        this.keySignerBuilder = pGPContentSignerBuilder;
        this.hashedPcks = pGPSignatureSubpacketVector;
        this.unhashedPcks = pGPSignatureSubpacketVector2;
        this.keys.add(new PGPSecretKey(n, pGPKeyPair, string, pGPDigestCalculator, pGPSignatureSubpacketVector, pGPSignatureSubpacketVector2, pGPContentSignerBuilder, pBESecretKeyEncryptor));
    }

    public void addSubKey(PGPKeyPair pGPKeyPair) throws PGPException {
        this.addSubKey(pGPKeyPair, this.hashedPcks, this.unhashedPcks);
    }

    public void addSubKey(PGPKeyPair pGPKeyPair, PGPSignatureSubpacketVector pGPSignatureSubpacketVector, PGPSignatureSubpacketVector pGPSignatureSubpacketVector2) throws PGPException {
        try {
            PGPSignatureGenerator pGPSignatureGenerator = new PGPSignatureGenerator(this.keySignerBuilder);
            pGPSignatureGenerator.init(24, this.masterKey.getPrivateKey());
            pGPSignatureGenerator.setHashedSubpackets(pGPSignatureSubpacketVector);
            pGPSignatureGenerator.setUnhashedSubpackets(pGPSignatureSubpacketVector2);
            ArrayList<PGPSignature> arrayList = new ArrayList<PGPSignature>();
            arrayList.add(pGPSignatureGenerator.generateCertification(this.masterKey.getPublicKey(), pGPKeyPair.getPublicKey()));
            PGPPublicKey pGPPublicKey = new PGPPublicKey(pGPKeyPair.getPublicKey(), null, arrayList);
            pGPPublicKey.publicPk = new PublicSubkeyPacket(pGPPublicKey.getAlgorithm(), pGPPublicKey.getCreationTime(), pGPPublicKey.publicPk.getKey());
            this.keys.add(new PGPSecretKey(pGPKeyPair.getPrivateKey(), pGPPublicKey, this.checksumCalculator, this.keyEncryptor));
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("exception adding subkey: ", exception);
        }
    }

    public PGPSecretKeyRing generateSecretKeyRing() {
        return new PGPSecretKeyRing(this.keys);
    }

    public PGPPublicKeyRing generatePublicKeyRing() {
        Iterator iterator = this.keys.iterator();
        ArrayList<PGPPublicKey> arrayList = new ArrayList<PGPPublicKey>();
        arrayList.add(((PGPSecretKey)iterator.next()).getPublicKey());
        while (iterator.hasNext()) {
            arrayList.add(((PGPSecretKey)iterator.next()).getPublicKey());
        }
        return new PGPPublicKeyRing(arrayList);
    }
}

