/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.bouncycastle.openpgp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gradle.internal.impldep.org.bouncycastle.bcpg.BCPGInputStream;
import org.gradle.internal.impldep.org.bouncycastle.bcpg.InputStreamPacket;
import org.gradle.internal.impldep.org.bouncycastle.bcpg.Packet;
import org.gradle.internal.impldep.org.bouncycastle.bcpg.PublicKeyEncSessionPacket;
import org.gradle.internal.impldep.org.bouncycastle.bcpg.SymmetricKeyEncSessionPacket;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPPBEEncryptedData;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.gradle.internal.impldep.org.bouncycastle.util.Iterable;

public class PGPEncryptedDataList
implements Iterable {
    List list = new ArrayList();
    InputStreamPacket data;

    public PGPEncryptedDataList(BCPGInputStream bCPGInputStream) throws IOException {
        while (bCPGInputStream.nextPacketTag() == 1 || bCPGInputStream.nextPacketTag() == 3) {
            this.list.add(bCPGInputStream.readPacket());
        }
        Packet packet = bCPGInputStream.readPacket();
        if (!(packet instanceof InputStreamPacket)) {
            throw new IOException("unexpected packet in stream: " + packet);
        }
        this.data = (InputStreamPacket)packet;
        for (int i = 0; i != this.list.size(); ++i) {
            if (this.list.get(i) instanceof SymmetricKeyEncSessionPacket) {
                this.list.set(i, new PGPPBEEncryptedData((SymmetricKeyEncSessionPacket)this.list.get(i), this.data));
                continue;
            }
            this.list.set(i, new PGPPublicKeyEncryptedData((PublicKeyEncSessionPacket)this.list.get(i), this.data));
        }
    }

    public Object get(int n) {
        return this.list.get(n);
    }

    public int size() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public Iterator getEncryptedDataObjects() {
        return this.list.iterator();
    }

    public Iterator iterator() {
        return this.getEncryptedDataObjects();
    }
}

