/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.xbean.recipe;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gradle.internal.impldep.org.apache.xbean.propertyeditor.PropertyEditors;
import org.gradle.internal.impldep.org.apache.xbean.recipe.ExecutionContext;
import org.gradle.internal.impldep.org.apache.xbean.recipe.Recipe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RecipeHelper {
    private RecipeHelper() {
    }

    public static Recipe getCaller() {
        LinkedList<Recipe> stack = ExecutionContext.getContext().getStack();
        if (stack.size() < 2) {
            return null;
        }
        return stack.get(stack.size() - 2);
    }

    public static Class loadClass(String name) throws ClassNotFoundException {
        ClassLoader classLoader = ExecutionContext.getContext().getClassLoader();
        Class<?> type = Class.forName(name, true, classLoader);
        return type;
    }

    public static boolean hasDefaultConstructor(Class type) {
        Constructor<?>[] constructors;
        if (!Modifier.isPublic(type.getModifiers())) {
            return false;
        }
        if (Modifier.isAbstract(type.getModifiers())) {
            return false;
        }
        for (Constructor<?> constructor : constructors = type.getConstructors()) {
            if (!Modifier.isPublic(constructor.getModifiers()) || constructor.getParameterTypes().length != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isSimpleType(Object o) {
        return o == null || o instanceof Boolean || o instanceof Character || o instanceof Byte || o instanceof Short || o instanceof Integer || o instanceof Long || o instanceof Float || o instanceof Double || o instanceof String || o instanceof Recipe;
    }

    public static <K, V> List<Map.Entry<K, V>> prioritizeProperties(Map<K, V> properties) {
        ArrayList<Map.Entry<K, V>> entries = new ArrayList<Map.Entry<K, V>>(properties.entrySet());
        Collections.sort(entries, new RecipeComparator());
        return entries;
    }

    public static boolean isInstance(Type t, Object instance) {
        Class type = RecipeHelper.toClass(t);
        if (type.isPrimitive()) {
            if (instance == null) {
                return false;
            }
            if (type.equals(Boolean.TYPE)) {
                return instance instanceof Boolean;
            }
            if (type.equals(Character.TYPE)) {
                return instance instanceof Character;
            }
            if (type.equals(Byte.TYPE)) {
                return instance instanceof Byte;
            }
            if (type.equals(Short.TYPE)) {
                return instance instanceof Short;
            }
            if (type.equals(Integer.TYPE)) {
                return instance instanceof Integer;
            }
            if (type.equals(Long.TYPE)) {
                return instance instanceof Long;
            }
            if (type.equals(Float.TYPE)) {
                return instance instanceof Float;
            }
            if (type.equals(Double.TYPE)) {
                return instance instanceof Double;
            }
            throw new AssertionError((Object)("Invalid primitve type: " + type));
        }
        return instance == null || type.isInstance(instance);
    }

    public static boolean isConvertable(Type type, Object propertyValue) {
        if (propertyValue instanceof Recipe) {
            Recipe recipe = (Recipe)propertyValue;
            return recipe.canCreate(type);
        }
        return propertyValue instanceof String && PropertyEditors.canConvert(RecipeHelper.toClass(type));
    }

    public static boolean isAssignableFrom(Class expected, Class actual) {
        if (expected == null) {
            return true;
        }
        if (expected.isPrimitive()) {
            if (expected.equals(Boolean.TYPE)) {
                return actual.equals(Boolean.class);
            }
            if (expected.equals(Character.TYPE)) {
                return actual.equals(Character.class);
            }
            if (expected.equals(Byte.TYPE)) {
                return actual.equals(Byte.class);
            }
            if (expected.equals(Short.TYPE)) {
                return actual.equals(Short.class);
            }
            if (expected.equals(Integer.TYPE)) {
                return actual.equals(Integer.class);
            }
            if (expected.equals(Long.TYPE)) {
                return actual.equals(Long.class);
            }
            if (expected.equals(Float.TYPE)) {
                return actual.equals(Float.class);
            }
            if (expected.equals(Double.TYPE)) {
                return actual.equals(Double.class);
            }
            throw new AssertionError((Object)("Invalid primitve type: " + expected));
        }
        return expected.isAssignableFrom(actual);
    }

    public static Object convert(Type expectedType, Object value, boolean lazyRefAllowed) {
        if (value instanceof Recipe) {
            Recipe recipe = (Recipe)value;
            value = recipe.create(expectedType, lazyRefAllowed);
        }
        if (value instanceof String && expectedType != Object.class) {
            String stringValue = (String)value;
            value = PropertyEditors.getValue(expectedType, stringValue);
        }
        return value;
    }

    public static boolean isAssignableFrom(List<? extends Class<?>> expectedTypes, List<? extends Class<?>> actualTypes) {
        if (expectedTypes.size() != actualTypes.size()) {
            return false;
        }
        for (int i = 0; i < expectedTypes.size(); ++i) {
            Class<?> actualType;
            Class<?> expectedType = expectedTypes.get(i);
            if (expectedType == (actualType = actualTypes.get(i)) || RecipeHelper.isAssignableFrom(expectedType, actualType)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAssignable(Type expectedType, Type actualType) {
        Class expectedClass = RecipeHelper.toClass(expectedType);
        Class actualClass = RecipeHelper.toClass(actualType);
        return expectedClass.isAssignableFrom(actualClass);
    }

    public static Class toClass(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return clazz;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            Class componentType = RecipeHelper.toClass(arrayType.getGenericComponentType());
            return Array.newInstance(componentType, 0).getClass();
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return RecipeHelper.toClass(parameterizedType.getRawType());
        }
        return Object.class;
    }

    public static Type[] getTypeParameters(Class desiredType, Type type) {
        if (type instanceof Class) {
            Class rawClass = (Class)type;
            if (desiredType.equals(type)) {
                return null;
            }
            for (Type intf : rawClass.getGenericInterfaces()) {
                Type[] collectionType = RecipeHelper.getTypeParameters(desiredType, intf);
                if (collectionType == null) continue;
                return collectionType;
            }
            Type[] collectionType = RecipeHelper.getTypeParameters(desiredType, rawClass.getGenericSuperclass());
            return collectionType;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            if (desiredType.equals(rawType)) {
                Type[] argument = parameterizedType.getActualTypeArguments();
                return argument;
            }
            Type[] collectionTypes = RecipeHelper.getTypeParameters(desiredType, rawType);
            if (collectionTypes != null) {
                for (int i = 0; i < collectionTypes.length; ++i) {
                    if (!(collectionTypes[i] instanceof TypeVariable)) continue;
                    TypeVariable typeVariable = (TypeVariable)collectionTypes[i];
                    TypeVariable<Class<T>>[] rawTypeParams = ((Class)rawType).getTypeParameters();
                    for (int j = 0; j < rawTypeParams.length; ++j) {
                        if (!typeVariable.getName().equals(rawTypeParams[j].getName())) continue;
                        collectionTypes[i] = parameterizedType.getActualTypeArguments()[j];
                    }
                }
            }
            return collectionTypes;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RecipeComparator
    implements Comparator<Object> {
        @Override
        public int compare(Object left, Object right) {
            float rightPriority;
            if (!(left instanceof Recipe) && !(right instanceof Recipe)) {
                return 0;
            }
            if (left instanceof Recipe && !(right instanceof Recipe)) {
                return 1;
            }
            if (!(left instanceof Recipe) && right instanceof Recipe) {
                return -1;
            }
            float leftPriority = ((Recipe)left).getPriority();
            if (leftPriority > (rightPriority = ((Recipe)right).getPriority())) {
                return 1;
            }
            if (leftPriority < rightPriority) {
                return -1;
            }
            return 0;
        }
    }
}

