/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.amazonaws.http;

import java.io.File;
import javax.net.ssl.KeyManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gradle.internal.impldep.com.amazonaws.http.AbstractFileTlsKeyManagersProvider;
import org.gradle.internal.impldep.com.amazonaws.util.ValidationUtils;

public final class FileStoreTlsKeyManagersProvider
extends AbstractFileTlsKeyManagersProvider {
    private static final Log log = LogFactory.getLog(FileStoreTlsKeyManagersProvider.class);
    private final File storePath;
    private final String storeType;
    private final char[] password;

    public FileStoreTlsKeyManagersProvider(File storePath, String storeType, String password) {
        this.storePath = ValidationUtils.assertNotNull(storePath, "storePath");
        this.storeType = ValidationUtils.assertStringNotEmpty(storeType, "storeType");
        this.password = password != null ? password.toCharArray() : null;
    }

    @Override
    public KeyManager[] getKeyManagers() {
        try {
            return this.createKeyManagers(this.storePath, this.storeType, this.password);
        }
        catch (Exception e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)String.format("Unable to create KeyManagers from file %s", this.storePath.getAbsolutePath()), (Throwable)e);
            }
            return null;
        }
    }
}

