/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.analytics;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.analytics.UsageTrackerWriter;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.play.playlog.proto.ClientAnalytics;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@VisibleForTesting
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001*B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001eH\u0002J\b\u0010 \u001a\u00020\u001eH\u0002J\b\u0010!\u001a\u00020\u001eH\u0016J\u0010\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u0015H\u0016J\b\u0010$\u001a\u00020\u001eH\u0002J\u0010\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020)H\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/android/tools/analytics/JournalingUsageTracker;", "Lcom/android/tools/analytics/UsageTrackerWriter;", "scheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "spoolLocation", "Ljava/nio/file/Path;", "(Ljava/util/concurrent/ScheduledExecutorService;Ljava/nio/file/Path;)V", "channel", "Ljava/nio/channels/FileChannel;", "currentLogCount", "", "gate", "", "journalTimeout", "Ljava/util/concurrent/ScheduledFuture;", "lock", "Ljava/nio/channels/FileLock;", "outputStream", "Ljava/io/OutputStream;", "pendingEvents", "Ljava/util/Queue;", "Lcom/google/wireless/android/play/playlog/proto/ClientAnalytics$LogEvent$Builder;", "quietFlushRunnable", "Ljava/lang/Runnable;", "scheduleVersion", "getScheduler", "()Ljava/util/concurrent/ScheduledExecutorService;", "state", "Lcom/android/tools/analytics/JournalingUsageTracker$State;", "close", "", "closeAsBroken", "closeTrackFile", "flush", "logDetails", "logEvent", "newTrackFile", "scheduleJournalTimeout", "maxJournalTime", "", "switchTrackFile", "", "State", "analytics-tracker"})
public final class JournalingUsageTracker
extends UsageTrackerWriter {
    private final Object gate;
    private FileLock lock;
    private FileChannel channel;
    private OutputStream outputStream;
    private int currentLogCount;
    private ScheduledFuture<?> journalTimeout;
    private int scheduleVersion;
    private volatile State state;
    private final Queue<ClientAnalytics.LogEvent.Builder> pendingEvents;
    private final Runnable quietFlushRunnable;
    @NotNull
    private final ScheduledExecutorService scheduler;
    private final Path spoolLocation;

    private final void newTrackFile() throws IOException {
        Path spoolFile = Paths.get(((Object)this.spoolLocation).toString(), UUID.randomUUID().toString() + ".trk");
        Files.createDirectories(spoolFile.getParent(), new FileAttribute[0]);
        FileChannel fileChannel = this.channel = FileChannel.open(spoolFile, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.DSYNC);
        if (fileChannel == null) {
            Intrinsics.throwNpe();
        }
        this.outputStream = Channels.newOutputStream(fileChannel);
        try {
            FileChannel fileChannel2 = this.channel;
            if (fileChannel2 == null) {
                Intrinsics.throwNpe();
            }
            this.lock = fileChannel2.tryLock();
        }
        catch (OverlappingFileLockException e) {
            this.closeTrackFile();
            throw (Throwable)new IOException("Unable to lock usage tracking spool file", e);
        }
        if (this.lock == null) {
            this.closeTrackFile();
            throw (Throwable)new IOException("Unable to lock usage tracking spool file, file already locked");
        }
        this.currentLogCount = 0;
    }

    private final void closeTrackFile() throws IOException {
        IOException ex = null;
        try {
            FileLock fileLock = this.lock;
            if (fileLock != null) {
                fileLock.release();
            }
        }
        catch (IOException e) {
            ex = e;
        }
        this.lock = null;
        try {
            FileChannel fileChannel = this.channel;
            if (fileChannel != null) {
                fileChannel.close();
            }
        }
        catch (IOException e) {
            if (ex == null) {
                ex = e;
            }
            ExceptionsKt.addSuppressed((Throwable)ex, (Throwable)e);
        }
        this.channel = null;
        try {
            OutputStream outputStream = this.outputStream;
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (IOException e) {
            if (ex == null) {
                ex = e;
            }
            ExceptionsKt.addSuppressed((Throwable)ex, (Throwable)e);
        }
        this.outputStream = null;
        if (ex != null) {
            throw (Throwable)ex;
        }
    }

    @Override
    public void logDetails(@NotNull ClientAnalytics.LogEvent.Builder logEvent) {
        if (this.state != State.Open) {
            return;
        }
        this.pendingEvents.add(logEvent);
        this.scheduler.submit(this.quietFlushRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        while (true) {
            Object object = this.gate;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (object) {
                boolean bl3 = false;
                if (this.pendingEvents.poll() == null) {
                    return;
                }
                if (this.state != State.Open) {
                    return;
                }
                try {
                    ClientAnalytics.LogEvent.Builder logEvent;
                    ClientAnalytics.LogEvent logEvent2 = logEvent.build();
                    OutputStream outputStream = this.outputStream;
                    if (outputStream == null) {
                        Intrinsics.throwNpe();
                    }
                    logEvent2.writeDelimitedTo(outputStream);
                }
                catch (IOException exception) {
                    this.closeAsBroken();
                    throw (Throwable)new IOException("Failed to write log event", exception);
                }
                int n = this.currentLogCount;
                int n2 = this.currentLogCount = n + 1;
                n = UsageTracker.getMaxJournalSize();
                if (1 <= n && n2 >= n) {
                    this.switchTrackFile();
                    if (this.journalTimeout != null) {
                        this.scheduleJournalTimeout(UsageTracker.getMaxJournalTime());
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    private final void closeAsBroken() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.state = State.Broken;
    }

    private final boolean switchTrackFile() {
        try {
            this.closeTrackFile();
            this.newTrackFile();
            return true;
        }
        catch (IOException e) {
            this.closeAsBroken();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        Object object = this.gate;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            this.state = State.Closed;
            ScheduledFuture<?> scheduledFuture = this.journalTimeout;
            if (scheduledFuture != null) {
                scheduledFuture.cancel(false);
            }
            this.closeTrackFile();
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public void scheduleJournalTimeout(long maxJournalTime) {
        JournalingUsageTracker journalingUsageTracker = this;
        ++journalingUsageTracker.scheduleVersion;
        int currentScheduleVersion = journalingUsageTracker.scheduleVersion;
        ScheduledFuture<?> scheduledFuture = this.journalTimeout;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
        this.journalTimeout = this.scheduler.schedule(new Runnable(this, currentScheduleVersion, maxJournalTime){
            final /* synthetic */ JournalingUsageTracker this$0;
            final /* synthetic */ int $currentScheduleVersion;
            final /* synthetic */ long $maxJournalTime;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void run() {
                Object object = JournalingUsageTracker.access$getGate$p(this.this$0);
                boolean bl = false;
                boolean bl2 = false;
                synchronized (object) {
                    boolean bl3 = false;
                    if (JournalingUsageTracker.access$getState$p(this.this$0) != State.Open) {
                        return;
                    }
                    if (JournalingUsageTracker.access$getCurrentLogCount$p(this.this$0) > 0) {
                        JournalingUsageTracker.access$switchTrackFile(this.this$0);
                    }
                    if (JournalingUsageTracker.access$getScheduleVersion$p(this.this$0) == this.$currentScheduleVersion) {
                        this.this$0.scheduleJournalTimeout(this.$maxJournalTime);
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
            {
                this.this$0 = journalingUsageTracker;
                this.$currentScheduleVersion = n;
                this.$maxJournalTime = l;
            }
        }, maxJournalTime, TimeUnit.NANOSECONDS);
    }

    @NotNull
    public final ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    public JournalingUsageTracker(@NotNull ScheduledExecutorService scheduler, @NotNull Path spoolLocation) {
        this.scheduler = scheduler;
        this.spoolLocation = spoolLocation;
        this.gate = new Object();
        this.state = State.Open;
        this.pendingEvents = new ConcurrentLinkedQueue();
        this.quietFlushRunnable = new Runnable(this){
            final /* synthetic */ JournalingUsageTracker this$0;

            public final void run() {
                try {
                    this.this$0.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            {
                this.this$0 = journalingUsageTracker;
            }
        };
        try {
            this.newTrackFile();
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException("Unable to initialize first usage tracking spool file", e);
        }
    }

    public static final /* synthetic */ Object access$getGate$p(JournalingUsageTracker $this) {
        return $this.gate;
    }

    public static final /* synthetic */ State access$getState$p(JournalingUsageTracker $this) {
        return $this.state;
    }

    public static final /* synthetic */ void access$setState$p(JournalingUsageTracker $this, State state) {
        $this.state = state;
    }

    public static final /* synthetic */ int access$getCurrentLogCount$p(JournalingUsageTracker $this) {
        return $this.currentLogCount;
    }

    public static final /* synthetic */ void access$setCurrentLogCount$p(JournalingUsageTracker $this, int n) {
        $this.currentLogCount = n;
    }

    public static final /* synthetic */ boolean access$switchTrackFile(JournalingUsageTracker $this) {
        return $this.switchTrackFile();
    }

    public static final /* synthetic */ int access$getScheduleVersion$p(JournalingUsageTracker $this) {
        return $this.scheduleVersion;
    }

    public static final /* synthetic */ void access$setScheduleVersion$p(JournalingUsageTracker $this, int n) {
        $this.scheduleVersion = n;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/analytics/JournalingUsageTracker$State;", "", "(Ljava/lang/String;I)V", "Open", "Closed", "Broken", "analytics-tracker"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State Open;
        public static final /* enum */ State Closed;
        public static final /* enum */ State Broken;
        private static final /* synthetic */ State[] $VALUES;

        static {
            State[] stateArray = new State[3];
            State[] stateArray2 = stateArray;
            stateArray[0] = Open = new State();
            stateArray[1] = Closed = new State();
            stateArray[2] = Broken = new State();
            $VALUES = stateArray;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }
    }
}

