/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.analytics;

import com.android.tools.analytics.AnalyticsPublisher;
import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.analytics.CommonMetricsData;
import com.android.tools.analytics.Environment;
import com.android.tools.analytics.WebServerDateProvider;
import com.android.utils.ILogger;
import com.android.utils.StdLogger;
import com.google.common.io.CountingOutputStream;
import com.google.wireless.android.play.playlog.proto.ClientAnalytics;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.MetaMetrics;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 52\u00020\u0001:\u00015B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u001b\u001a\u00020\f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020\u000eH\u0002J\b\u0010 \u001a\u00020!H\u0016J\n\u0010\"\u001a\u0004\u0018\u00010\u0011H\u0002J\u0010\u0010#\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000eH\u0002J\u0006\u0010$\u001a\u00020\u001aJ\b\u0010%\u001a\u00020!H\u0002J\u0010\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020\u000eH\u0002J\u0014\u0010(\u001a\u00020!2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u0018\u0010*\u001a\u00020!2\u0006\u0010+\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020-H\u0016J\u000e\u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\u001aJ\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u0005H\u0002J\u0010\u00103\u001a\u00020\n2\u0006\u00104\u001a\u00020\fH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/android/tools/analytics/GoogleAnalyticsPublisher;", "Lcom/android/tools/analytics/AnalyticsPublisher;", "scheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "spoolLocation", "Ljava/nio/file/Path;", "applicationBuild", "", "(Ljava/util/concurrent/ScheduledExecutorService;Ljava/nio/file/Path;Ljava/lang/String;)V", "backoffRatio", "", "baseLogRequest", "Lcom/google/wireless/android/play/playlog/proto/ClientAnalytics$LogRequest;", "bytesSentInLastPublish", "", "createConnection_", "Ljava/util/concurrent/Callable;", "Ljava/net/HttpURLConnection;", "failedConnections", "failedServerReplies", "logger", "Lcom/android/utils/ILogger;", "publishJob", "Ljava/util/concurrent/ScheduledFuture;", "scheduleVersion", "serverUrl_", "Ljava/net/URL;", "buildLogRequest", "entries", "", "Lcom/google/wireless/android/play/playlog/proto/ClientAnalytics$LogEvent;", "time", "close", "", "defaultCreateConnection", "getMetaMetric", "getServerUrl", "publishQueuedAnalytics", "schedulePublish", "publishIntervalNanoSeconds", "setCreateConnection", "createConnection", "setPublishInterval", "interval", "unit", "Ljava/util/concurrent/TimeUnit;", "setServerUrl", "serverUrl", "tryPublishAnalytics", "", "trackFile", "trySendToServer", "request", "Companion", "analytics-publisher"})
public final class GoogleAnalyticsPublisher
extends AnalyticsPublisher {
    private final ClientAnalytics.LogRequest baseLogRequest;
    private ScheduledFuture<?> publishJob;
    private int scheduleVersion;
    private URL serverUrl_;
    private long bytesSentInLastPublish;
    private int failedConnections;
    private int failedServerReplies;
    private int backoffRatio;
    private Callable<HttpURLConnection> createConnection_;
    private ILogger logger;
    private final ScheduledExecutorService scheduler;
    private final Path spoolLocation;
    private static final Object gate;
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        Object object = gate;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            int n = this.scheduleVersion;
            this.scheduleVersion = n + 1;
            ScheduledFuture<?> scheduledFuture = this.publishJob;
            if (scheduledFuture == null) {
                Intrinsics.throwNpe();
            }
            bl2 = scheduledFuture.cancel(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPublishInterval(long interval, @NotNull TimeUnit unit) {
        Object object = gate;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            super.setPublishInterval(interval, unit);
            this.schedulePublish(this.getPublishInterval());
            Unit unit2 = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void publishQueuedAnalytics() {
        try {
            Closeable closeable = Files.newDirectoryStream(this.spoolLocation, "*.trk");
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                DirectoryStream stream = (DirectoryStream)closeable;
                boolean bl3 = false;
                for (Path file : stream) {
                    if (this.tryPublishAnalytics(file)) continue;
                    return;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            this.logger.error((Throwable)e, "Failure reading analytics spool directory.", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean tryPublishAnalytics(Path trackFile) {
        File file = trackFile.toFile();
        boolean success = false;
        try {
            Closeable closeable = new RandomAccessFile(file, "rw").getChannel();
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                FileChannel channel = (FileChannel)closeable;
                boolean bl3 = false;
                AutoCloseable autoCloseable = channel.tryLock();
                boolean bl4 = false;
                boolean bl5 = false;
                Throwable throwable2 = null;
                try {
                    FileLock lock = (FileLock)autoCloseable;
                    boolean bl6 = false;
                    if (lock == null) {
                        boolean bl7 = true;
                        boolean bl8 = bl7;
                        return bl8;
                    }
                    ArrayList<ClientAnalytics.LogEvent> entries = new ArrayList<ClientAnalytics.LogEvent>();
                    InputStream inputStream = Channels.newInputStream(channel);
                    while (ClientAnalytics.LogEvent.parseDelimitedFrom((InputStream)inputStream) != null) {
                        ClientAnalytics.LogEvent event;
                        entries.add(event);
                    }
                    if (entries.isEmpty()) {
                        success = true;
                    } else {
                        long now = AnalyticsSettings.getDateProvider().now().getTime();
                        entries.add(0, this.getMetaMetric(now));
                        ClientAnalytics.LogRequest request = this.buildLogRequest((List<ClientAnalytics.LogEvent>)entries, now);
                        int responseCode = this.trySendToServer(request);
                        success = GoogleAnalyticsPublisher.Companion.isSuccess(responseCode);
                        if (success) {
                            this.backoffRatio = 1;
                            this.failedConnections = 0;
                            this.failedServerReplies = 0;
                        } else {
                            int n = this.failedServerReplies;
                            this.failedServerReplies = n + 1;
                            this.backoffRatio *= 2;
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            this.logger.error((Throwable)e, "Failure publishing analytics, unable to connect to server", new Object[0]);
            int n = this.failedConnections;
            this.failedConnections = n + 1;
            this.backoffRatio *= 2;
            return false;
        }
        catch (OverlappingFileLockException e) {
            return true;
        }
        if (success) {
            file.delete();
        }
        return success;
    }

    private final HttpURLConnection defaultCreateConnection() throws IOException {
        URLConnection connection = this.serverUrl_.openConnection();
        if (connection instanceof HttpURLConnection) {
            return (HttpURLConnection)connection;
        }
        this.logger.error(null, "Unexpected connection type %s", new Object[]{connection.getClass().getName()});
        return null;
    }

    public final void setCreateConnection(@NotNull Callable<HttpURLConnection> createConnection) {
        this.createConnection_ = createConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int trySendToServer(ClientAnalytics.LogRequest request) throws IOException {
        int responseCode;
        HttpURLConnection httpURLConnection;
        try {
            httpURLConnection = this.createConnection_.call();
        }
        catch (Exception e) {
            throw (Throwable)new RuntimeException(e);
        }
        HttpURLConnection httpURLConnection2 = httpURLConnection;
        if (httpURLConnection2 == null) {
            return 405;
        }
        HttpURLConnection connection = httpURLConnection2;
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-Encoding", "gzip");
        byte[] requestBytes = request.toByteArray();
        Closeable e = connection.getOutputStream();
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            OutputStream output = (OutputStream)e;
            boolean bl3 = false;
            Closeable closeable = new BufferedOutputStream(output);
            boolean bl4 = false;
            boolean bl5 = false;
            Throwable throwable2 = null;
            try {
                BufferedOutputStream buffered = (BufferedOutputStream)closeable;
                boolean bl6 = false;
                Closeable closeable2 = (Closeable)new CountingOutputStream((OutputStream)buffered);
                boolean bl7 = false;
                boolean bl8 = false;
                Throwable throwable3 = null;
                try {
                    CountingOutputStream counted = (CountingOutputStream)closeable2;
                    boolean bl9 = false;
                    Closeable closeable3 = new GZIPOutputStream((OutputStream)counted, true);
                    boolean bl10 = false;
                    boolean bl11 = false;
                    Throwable throwable4 = null;
                    try {
                        GZIPOutputStream zipped = (GZIPOutputStream)closeable3;
                        boolean bl12 = false;
                        zipped.write(requestBytes);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable5) {
                        throwable4 = throwable5;
                        throw throwable5;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable4);
                    }
                    this.bytesSentInLastPublish = counted.getCount();
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable6) {
                    throwable3 = throwable6;
                    throw throwable6;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable3);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable7) {
                throwable2 = throwable7;
                throw throwable7;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable8) {
            throwable = throwable8;
            throw throwable8;
        }
        finally {
            CloseableKt.closeFinally((Closeable)e, (Throwable)throwable);
        }
        connection.connect();
        if (AnalyticsSettings.getGooglePlayDateProvider() != null) {
            WebServerDateProvider webServerDateProvider = AnalyticsSettings.getGooglePlayDateProvider();
            if (webServerDateProvider == null) {
                Intrinsics.throwNpe();
            }
            webServerDateProvider.updateServerTimestampFromExistingConnection(connection);
        }
        if (!GoogleAnalyticsPublisher.Companion.isSuccess(responseCode = connection.getResponseCode())) {
            this.logger.error(null, "Failure publishing metrics. Server responded with status code '%d' and message '%s'", new Object[]{responseCode, connection.getResponseMessage()});
        }
        return responseCode;
    }

    private final ClientAnalytics.LogRequest buildLogRequest(List<ClientAnalytics.LogEvent> entries, long time2) {
        return ClientAnalytics.LogRequest.newBuilder((ClientAnalytics.LogRequest)this.baseLogRequest).setRequestTimeMs(time2).addAllLogEvent((Iterable)entries).build();
    }

    private final ClientAnalytics.LogEvent getMetaMetric(long time2) {
        return ClientAnalytics.LogEvent.newBuilder().setEventTimeMs(time2).setSourceExtension(AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.META).setKind(AndroidStudioEvent.EventKind.META_METRICS).setMetaMetrics(MetaMetrics.newBuilder().setBytesSentInLastUpload(this.bytesSentInLastPublish).setFailedConnections(this.failedConnections).setFailedServerReplies(this.failedServerReplies)).build().toByteString()).build();
    }

    private final void schedulePublish(long publishIntervalNanoSeconds) {
        GoogleAnalyticsPublisher googleAnalyticsPublisher = this;
        ++googleAnalyticsPublisher.scheduleVersion;
        int currentScheduleVersion = googleAnalyticsPublisher.scheduleVersion;
        ScheduledFuture<?> scheduledFuture = this.publishJob;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
        this.publishJob = this.scheduler.schedule(new Runnable(this, currentScheduleVersion, publishIntervalNanoSeconds){
            final /* synthetic */ GoogleAnalyticsPublisher this$0;
            final /* synthetic */ int $currentScheduleVersion;
            final /* synthetic */ long $publishIntervalNanoSeconds;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void run() {
                Object object = GoogleAnalyticsPublisher.access$getGate$cp();
                boolean bl = false;
                boolean bl2 = false;
                synchronized (object) {
                    boolean bl3 = false;
                    GoogleAnalyticsPublisher.access$publishQueuedAnalytics(this.this$0);
                    if (GoogleAnalyticsPublisher.access$getScheduleVersion$p(this.this$0) == this.$currentScheduleVersion) {
                        GoogleAnalyticsPublisher.access$schedulePublish(this.this$0, this.$publishIntervalNanoSeconds);
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
            {
                this.this$0 = googleAnalyticsPublisher;
                this.$currentScheduleVersion = n;
                this.$publishIntervalNanoSeconds = l;
            }
        }, Math.min(publishIntervalNanoSeconds * (long)this.backoffRatio, TimeUnit.DAYS.toNanos(1L)), TimeUnit.NANOSECONDS);
    }

    @NotNull
    public final URL getServerUrl() {
        return this.serverUrl_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final GoogleAnalyticsPublisher setServerUrl(@NotNull URL serverUrl) {
        Object object = gate;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            this.serverUrl_ = serverUrl;
            Unit unit = Unit.INSTANCE;
        }
        return this;
    }

    public GoogleAnalyticsPublisher(@NotNull ScheduledExecutorService scheduler, @NotNull Path spoolLocation, @NotNull String applicationBuild) {
        this.scheduler = scheduler;
        this.spoolLocation = spoolLocation;
        ClientAnalytics.LogRequest.Builder builder = ClientAnalytics.LogRequest.newBuilder();
        ClientAnalytics.ClientInfo.Builder builder2 = ClientAnalytics.ClientInfo.newBuilder().setClientType(ClientAnalytics.ClientInfo.ClientType.DESKTOP);
        ClientAnalytics.DesktopClientInfo.Builder builder3 = ClientAnalytics.DesktopClientInfo.newBuilder().setLoggingId(AnalyticsSettings.getUserId()).setApplicationBuild(applicationBuild).setOs(CommonMetricsData.getOsName());
        String string = CommonMetricsData.getMajorOsVersion();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        this.baseLogRequest = builder.setClientInfo(builder2.setDesktopClientInfo(builder3.setOsMajorVersion(string).setOsFullVersion(Environment.Companion.getInstance().getSystemProperty(Environment.SystemProperty.OS_VERSION)))).setLogSource(ClientAnalytics.LogRequest.LogSource.ANDROID_STUDIO).build();
        this.serverUrl_ = GoogleAnalyticsPublisher.Companion.getDefaultServerUrl();
        this.backoffRatio = 1;
        this.createConnection_ = new Callable<HttpURLConnection>(this){
            final /* synthetic */ GoogleAnalyticsPublisher this$0;

            public final HttpURLConnection call() {
                return GoogleAnalyticsPublisher.access$defaultCreateConnection(this.this$0);
            }
            {
                this.this$0 = googleAnalyticsPublisher;
            }
        };
        this.logger = (ILogger)new StdLogger(StdLogger.Level.WARNING);
        this.schedulePublish(this.getPublishInterval());
    }

    static {
        Companion = new Companion(null);
        gate = new Object();
    }

    public static final /* synthetic */ Object access$getGate$cp() {
        return gate;
    }

    public static final /* synthetic */ void access$publishQueuedAnalytics(GoogleAnalyticsPublisher $this) {
        $this.publishQueuedAnalytics();
    }

    public static final /* synthetic */ int access$getScheduleVersion$p(GoogleAnalyticsPublisher $this) {
        return $this.scheduleVersion;
    }

    public static final /* synthetic */ void access$setScheduleVersion$p(GoogleAnalyticsPublisher $this, int n) {
        $this.scheduleVersion = n;
    }

    public static final /* synthetic */ void access$schedulePublish(GoogleAnalyticsPublisher $this, long publishIntervalNanoSeconds) {
        $this.schedulePublish(publishIntervalNanoSeconds);
    }

    public static final /* synthetic */ HttpURLConnection access$defaultCreateConnection(GoogleAnalyticsPublisher $this) {
        return $this.defaultCreateConnection();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/tools/analytics/GoogleAnalyticsPublisher$Companion;", "", "()V", "defaultServerUrl", "Ljava/net/URL;", "getDefaultServerUrl", "()Ljava/net/URL;", "gate", "isSuccess", "", "statusCode", "", "analytics-publisher"})
    public static final class Companion {
        private final URL getDefaultServerUrl() {
            try {
                return new URL("https://play.google.com/log?format=raw");
            }
            catch (MalformedURLException e) {
                throw (Throwable)new RuntimeException(e);
            }
        }

        private final boolean isSuccess(int statusCode) {
            int n = statusCode;
            return 200 <= n && 299 >= n;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

