/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.analytics;

import com.android.tools.analytics.CountersKt;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongUnaryOperator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0018\u001a\u00020\u0019J\"\u0010\u001a\u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001dH\u0082\b\u00a2\u0006\u0002\u0010\u001eJ\u001f\u0010\u001f\u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001b0 \u00a2\u0006\u0002\u0010!J\u000e\u0010\"\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020#J\b\u0010$\u001a\u00020\u0003H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\r\u00a8\u0006%"}, d2={"Lcom/android/tools/analytics/Counter;", "", "name", "", "(Ljava/lang/String;)V", "count", "Ljava/util/concurrent/atomic/AtomicInteger;", "maxCpu", "Ljava/util/concurrent/atomic/AtomicLong;", "maxWall", "maxWallNanos", "", "getMaxWallNanos", "()J", "getName", "()Ljava/lang/String;", "totalCount", "", "getTotalCount", "()I", "totalCpu", "totalWall", "totalWallNanos", "getTotalWallNanos", "reset", "", "time", "R", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "timeCallable", "Ljava/util/concurrent/Callable;", "(Ljava/util/concurrent/Callable;)Ljava/lang/Object;", "timeRunnable", "Ljava/lang/Runnable;", "toString", "analytics-tracker"})
public final class Counter {
    private final AtomicLong totalCpu;
    private final AtomicLong totalWall;
    private final AtomicLong maxCpu;
    private final AtomicLong maxWall;
    private final AtomicInteger count;
    @NotNull
    private final String name;

    public final long getTotalWallNanos() {
        return this.totalWall.get();
    }

    public final long getMaxWallNanos() {
        return this.maxWall.get();
    }

    public final int getTotalCount() {
        return this.count.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R> R timeCallable(@NotNull Callable<R> block) {
        R r;
        Counter this_$iv = this;
        boolean $i$f$time = false;
        long startWall$iv = CountersKt.access$getCurrentTimeNano$p();
        try {
            boolean bl = false;
            r = block.call();
        }
        catch (Throwable throwable) {
            long deltaWall$iv = CountersKt.access$getCurrentTimeNano$p() - startWall$iv;
            this_$iv.totalWall.addAndGet(deltaWall$iv);
            this_$iv.maxWall.updateAndGet(new LongUnaryOperator(deltaWall$iv){
                final /* synthetic */ long $deltaWall;

                public final long applyAsLong(long it) {
                    long l = this.$deltaWall;
                    boolean bl = false;
                    return Math.max(it, l);
                }
                {
                    this.$deltaWall = l;
                }
            });
            this_$iv.count.incrementAndGet();
            throw throwable;
        }
        long deltaWall$iv = CountersKt.access$getCurrentTimeNano$p() - startWall$iv;
        this_$iv.totalWall.addAndGet(deltaWall$iv);
        this_$iv.maxWall.updateAndGet(new /* invalid duplicate definition of identical inner class */);
        this_$iv.count.incrementAndGet();
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void timeRunnable(@NotNull Runnable block) {
        Counter this_$iv = this;
        boolean $i$f$time = false;
        long startWall$iv = CountersKt.access$getCurrentTimeNano$p();
        try {
            boolean bl = false;
            block.run();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            long deltaWall$iv = CountersKt.access$getCurrentTimeNano$p() - startWall$iv;
            this_$iv.totalWall.addAndGet(deltaWall$iv);
            this_$iv.maxWall.updateAndGet(new /* invalid duplicate definition of identical inner class */);
            this_$iv.count.incrementAndGet();
            throw throwable;
        }
        long deltaWall$iv = CountersKt.access$getCurrentTimeNano$p() - startWall$iv;
        this_$iv.totalWall.addAndGet(deltaWall$iv);
        this_$iv.maxWall.updateAndGet(new /* invalid duplicate definition of identical inner class */);
        this_$iv.count.incrementAndGet();
    }

    public final void reset() {
        this.totalWall.set(0L);
        this.maxWall.set(0L);
        this.count.set(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <R> R time(Function0<? extends R> block) {
        Object object;
        int $i$f$time = 0;
        long startWall = CountersKt.access$getCurrentTimeNano$p();
        try {
            object = block.invoke();
        }
        catch (Throwable throwable) {
            InlineMarker.finallyStart((int)1);
            long deltaWall = CountersKt.access$getCurrentTimeNano$p() - startWall;
            this.totalWall.addAndGet(deltaWall);
            this.maxWall.updateAndGet(new /* invalid duplicate definition of identical inner class */);
            this.count.incrementAndGet();
            InlineMarker.finallyEnd((int)1);
            throw throwable;
        }
        InlineMarker.finallyStart((int)1);
        long deltaWall = CountersKt.access$getCurrentTimeNano$p() - startWall;
        this.totalWall.addAndGet(deltaWall);
        this.maxWall.updateAndGet(new /* invalid duplicate definition of identical inner class */);
        this.count.incrementAndGet();
        InlineMarker.finallyEnd((int)1);
        return (R)object;
    }

    @NotNull
    public String toString() {
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl5 = false;
        int totalCount = this.count.get();
        if (totalCount > 0) {
            double avgWallMicros = (double)(this.getTotalWallNanos() / (long)totalCount / (long)100) / 10.0;
            double maxWallMicros = (double)(this.getMaxWallNanos() / (long)100) / 10.0;
            double totalWallMillis = (double)(this.getTotalWallNanos() / (long)100000) / 10.0;
            StringsKt.append((StringBuilder)$this$buildString, (String[])new String[]{"Counter: ", this.name, " "});
            StringsKt.append((StringBuilder)$this$buildString, (Object[])new Object[]{"Count: ", totalCount, " "});
            StringsKt.append((StringBuilder)$this$buildString, (Object[])new Object[]{"AvgWall: ", avgWallMicros, "\u03bcs "});
            StringsKt.append((StringBuilder)$this$buildString, (Object[])new Object[]{"TotalWall: ", totalWallMillis, "ms "});
            StringsKt.append((StringBuilder)$this$buildString, (Object[])new Object[]{"MaxWall: ", maxWallMicros, "\u03bcs "});
            StringsKt.appendln((StringBuilder)$this$buildString);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public Counter(@NotNull String name) {
        this.name = name;
        this.totalCpu = new AtomicLong();
        this.totalWall = new AtomicLong();
        this.maxCpu = new AtomicLong();
        this.maxWall = new AtomicLong();
        this.count = new AtomicInteger();
    }
}

