/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor.inspections.incomplete;

import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.editor.ResourceBundleEditorBundle;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtilRt;
import java.util.Collection;
import java.util.Locale;
import java.util.SortedSet;
import javax.swing.AbstractListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class IncompletePropertyInspectionOptionsPanel {
    private final SortedSet<String> mySuffixes;
    private final JBList<String> myList;

    public IncompletePropertyInspectionOptionsPanel(SortedSet<String> suffixes) {
        this.mySuffixes = suffixes;
        this.myList = new JBList((ListModel)new MyListModel());
    }

    public JPanel buildPanel() {
        JPanel panel = ToolbarDecorator.createDecorator(this.myList).setPanelBorder((Border)IdeBorderFactory.createTitledBorder((String)"Ignored suffixes")).disableUpDownActions().setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                String result = Messages.showInputDialog((Project)((Project)CommonDataKeys.PROJECT.getData(button.getDataContext())), (String)ResourceBundleEditorBundle.message("incomplete.property.add.ignored.suffixes.dialog.message", new Object[0]), (String)ResourceBundleEditorBundle.message("incomplete.property.add.ignored.suffixes.dialog.title", new Object[0]), null);
                if (result != null) {
                    IncompletePropertyInspectionOptionsPanel.this.mySuffixes.addAll(StringUtil.split((String)result, (String)","));
                    IncompletePropertyInspectionOptionsPanel.this.changed();
                }
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                for (String s : IncompletePropertyInspectionOptionsPanel.this.myList.getSelectedValuesList()) {
                    IncompletePropertyInspectionOptionsPanel.this.mySuffixes.remove(s);
                }
                IncompletePropertyInspectionOptionsPanel.this.changed();
            }
        }).createPanel();
        this.myList.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer<String>(){

            protected void customizeCellRenderer(@NotNull JList list, String suffix, int index, boolean selected, boolean hasFocus) {
                this.append(suffix);
                Locale locale = PropertiesUtil.getLocale((String)("_" + suffix + ".properties"));
                if (locale != PropertiesUtil.DEFAULT_LOCALE) {
                    if (PropertiesUtil.hasDefaultLanguage((Locale)locale)) {
                        this.append(" ");
                        this.append(PropertiesUtil.getPresentableLocale((Locale)locale), SimpleTextAttributes.GRAY_ATTRIBUTES);
                    }
                } else {
                    this.append("Default locale");
                }
            }
        });
        return panel;
    }

    public boolean showDialogAndGet(Project project) {
        return new DialogWrapper(project){
            {
                this.init();
                this.setTitle(ResourceBundleEditorBundle.message("incomplete.property.locales.to.ignore.dialog.title", new Object[0]));
            }

            protected JComponent createCenterPanel() {
                return IncompletePropertyInspectionOptionsPanel.this.buildPanel();
            }
        }.showAndGet();
    }

    private void changed() {
        ((MyListModel)this.myList.getModel()).modified();
    }

    private class MyListModel
    extends AbstractListModel<String> {
        private MyListModel() {
        }

        @Override
        public int getSize() {
            return IncompletePropertyInspectionOptionsPanel.this.mySuffixes.size();
        }

        @Override
        public String getElementAt(int index) {
            return ArrayUtilRt.toStringArray((Collection)IncompletePropertyInspectionOptionsPanel.this.mySuffixes)[index];
        }

        public void modified() {
            this.fireContentsChanged(this, -1, -1);
        }
    }
}

