/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.ResourceBundleEditor;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GotoResourceBundleLocalizationsProvider
extends GotoRelatedProvider {
    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull DataContext context) {
        FileEditor editor = (FileEditor)PlatformDataKeys.FILE_EDITOR.getData(context);
        if (editor instanceof ResourceBundleEditor) {
            return Collections.emptyList();
        }
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
        if (!(psiFile instanceof PropertiesFile)) {
            return Collections.emptyList();
        }
        ResourceBundle resourceBundle = ((PropertiesFile)psiFile).getResourceBundle();
        List bundlePropertiesFiles = resourceBundle.getPropertiesFiles();
        assert (bundlePropertiesFiles.size() != 0);
        if (bundlePropertiesFiles.size() != 1) {
            ArrayList propertiesFilesWithoutCurrent = new ArrayList(bundlePropertiesFiles);
            propertiesFilesWithoutCurrent.remove(psiFile);
            return ContainerUtil.map(propertiesFilesWithoutCurrent, propertiesFile -> new GotoRelatedItem((PsiElement)propertiesFile, "Other Localizations"));
        }
        return Collections.emptyList();
    }
}

