/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unused;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.unused.UnusedPropertyInspection;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.inspections.ResourceBundleEditorProblemDescriptor;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class UnusedPropertyUtil {
    private static final Logger LOG = Logger.getInstance(UnusedPropertyUtil.class);

    @NotNull
    public static Function<IProperty[], ResourceBundleEditorProblemDescriptor[]> buildPropertyGroupVisitor(@NotNull ResourceBundle resourceBundle) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)resourceBundle.getDefaultPropertiesFile().getContainingFile());
        if (module == null) {
            return x -> null;
        }
        UnusedPropertyInspection.UnusedPropertiesSearchHelper helper = new UnusedPropertyInspection.UnusedPropertiesSearchHelper(module);
        return properties -> {
            ResourceBundleEditorProblemDescriptor[] resourceBundleEditorProblemDescriptorArray;
            if (!UnusedPropertyInspection.isPropertyUsed((Property)((Property)properties[0]), (UnusedPropertyInspection.UnusedPropertiesSearchHelper)helper, (boolean)true)) {
                ResourceBundleEditorProblemDescriptor[] resourceBundleEditorProblemDescriptorArray2 = new ResourceBundleEditorProblemDescriptor[1];
                resourceBundleEditorProblemDescriptorArray = resourceBundleEditorProblemDescriptorArray2;
                resourceBundleEditorProblemDescriptorArray2[0] = new ResourceBundleEditorProblemDescriptor(ProblemHighlightType.LIKE_UNUSED_SYMBOL, PropertiesBundle.message((String)"unused.property.problem.descriptor.name", (Object[])new Object[0]), new RemovePropertiesFromAllLocalesFix((Property)properties[0]));
            } else {
                resourceBundleEditorProblemDescriptorArray = null;
            }
            return resourceBundleEditorProblemDescriptorArray;
        };
    }

    private static class RemovePropertiesFromAllLocalesFix
    implements QuickFix<ResourceBundleEditorProblemDescriptor> {
        private final SmartPsiElementPointer<Property> myRepresentativePointer;

        private RemovePropertiesFromAllLocalesFix(Property property) {
            this.myRepresentativePointer = SmartPointerManager.getInstance((Project)property.getProject()).createSmartPsiElementPointer((PsiElement)property);
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return PropertiesBundle.message((String)"remove.property.intention.text", (Object[])new Object[0]);
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ResourceBundleEditorProblemDescriptor descriptor) {
            Property element = (Property)this.myRepresentativePointer.getElement();
            if (element == null) {
                return;
            }
            String key = element.getKey();
            if (key == null) {
                return;
            }
            PropertiesFile file = PropertiesImplUtil.getPropertiesFile((PsiFile)this.myRepresentativePointer.getContainingFile());
            LOG.assertTrue(file != null);
            List propertiesFiles = file.getResourceBundle().getPropertiesFiles();
            if (!FileModificationService.getInstance().preparePsiElementsForWrite((Collection)ContainerUtil.map2List((Collection)propertiesFiles, p -> p.getContainingFile()))) {
                return;
            }
            WriteAction.run(() -> propertiesFiles.stream().flatMap(f -> f.findPropertiesByKey(key).stream()).filter(Objects::nonNull).map(IProperty::getPsiElement).forEach(e -> e.delete()));
        }
    }
}

