/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.ui.actions;

import com.intellij.execution.CantRunException;
import com.intellij.execution.Executor;
import com.intellij.execution.Location;
import com.intellij.execution.actions.JavaRerunFailedTestsAction;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.junit2.PsiMemberParameterizedLocation;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.actions.AbstractRerunFailedTestsAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.theoryinpractice.testng.configuration.SearchingForTestsTask;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.configuration.TestNGConfigurationProducer;
import com.theoryinpractice.testng.configuration.TestNGRunnableState;
import com.theoryinpractice.testng.model.TestNGTestObject;
import com.theoryinpractice.testng.util.TestNGUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class RerunFailedTestsAction
extends JavaRerunFailedTestsAction {
    public RerunFailedTestsAction(@NotNull ComponentContainer componentContainer, @NotNull TestConsoleProperties consoleProperties) {
        super(componentContainer, consoleProperties);
    }

    protected AbstractRerunFailedTestsAction.MyRunProfile getRunProfile(@NotNull ExecutionEnvironment environment) {
        final TestNGConfiguration configuration = (TestNGConfiguration)this.myConsoleProperties.getConfiguration();
        final List failedTests = this.getFailedTests(configuration.getProject());
        return new AbstractRerunFailedTestsAction.MyRunProfile((RunConfigurationBase)configuration){

            public Module @NotNull [] getModules() {
                return configuration.getModules();
            }

            public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) {
                return new TestNGRunnableState(env, configuration){

                    @Override
                    public SearchingForTestsTask createSearchingForTestsTask() {
                        return new SearchingForTestsTask(this.myServerSocket, this.getConfiguration(), this.myTempFile){

                            @Override
                            protected void fillTestObjects(Map<PsiClass, Map<PsiMethod, List<String>>> classes) throws CantRunException {
                                HashMap<PsiClass, Map<PsiMethod, List<String>>> fullClassList = new HashMap<PsiClass, Map<PsiMethod, List<String>>>();
                                super.fillTestObjects(fullClassList);
                                for (PsiClass aClass : fullClassList.keySet()) {
                                    if (((Boolean)ReadAction.compute(() -> TestNGUtil.hasTest((PsiModifierListOwner)aClass))).booleanValue()) continue;
                                    classes.put(aClass, fullClassList.get(aClass));
                                }
                                GlobalSearchScope scope = ((JavaRunConfigurationModule)this.getConfiguration().getConfigurationModule()).getSearchScope();
                                Project project = this.getConfiguration().getProject();
                                for (AbstractTestProxy proxy : failedTests) {
                                    ApplicationManager.getApplication().runReadAction(() -> RerunFailedTestsAction.includeFailedTestWithDependencies(classes, scope, project, proxy));
                                }
                            }
                        };
                    }
                };
            }
        };
    }

    public static void includeFailedTestWithDependencies(Map<PsiClass, Map<PsiMethod, List<String>>> classes, GlobalSearchScope scope, Project project, AbstractTestProxy proxy) {
        PsiElement element;
        Location location = proxy.getLocation(project, scope);
        if (location != null && (element = location.getPsiElement()) instanceof PsiMethod && element.isValid()) {
            List<String> strings;
            PsiMethod psiMethod = (PsiMethod)element;
            PsiClass psiClass = psiMethod.getContainingClass();
            if (psiClass != null && psiClass.hasModifierProperty("abstract")) {
                PsiElement elt;
                AbstractTestProxy parent = proxy.getParent();
                PsiElement psiElement = elt = parent != null ? parent.getLocation(project, scope).getPsiElement() : null;
                if (elt instanceof PsiClass) {
                    psiClass = (PsiClass)elt;
                }
            }
            TestNGTestObject.collectTestMethods(classes, psiClass, psiMethod.getName(), scope);
            Map<PsiMethod, List<String>> psiMethods = classes.get(psiClass);
            if (psiMethods == null) {
                psiMethods = new LinkedHashMap<PsiMethod, List<String>>();
                classes.put(psiClass, psiMethods);
            }
            if ((strings = psiMethods.get(psiMethod)) == null || strings.isEmpty()) {
                strings = new ArrayList<String>();
            }
            RerunFailedTestsAction.setupParameterName(location, strings);
            psiMethods.put(psiMethod, strings);
        }
    }

    private static void setupParameterName(Location location, List<String> strings) {
        String paramSetName;
        if (location instanceof PsiMemberParameterizedLocation && (paramSetName = ((PsiMemberParameterizedLocation)location).getParamSetName()) != null) {
            strings.add(TestNGConfigurationProducer.getInvocationNumber(paramSetName));
        }
    }
}

