/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.inspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodReturnTypeFix;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Version;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.util.containers.ContainerUtil;
import com.theoryinpractice.testng.TestngBundle;
import com.theoryinpractice.testng.util.TestNGUtil;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.testng.annotations.DataProvider;

public class DataProviderReturnTypeInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(DataProviderReturnTypeInspection.class);
    private static final String[] KNOWN_RETURN_TYPES = new String[]{"java.util.Iterator<java.lang.Object[]>", "java.lang.Object[][]"};
    private static final String[] KNOWN_WITH_ONE_DIMENSIONAL_RETURN_TYPES = new String[]{"java.util.Iterator<java.lang.Object[]>", "java.lang.Object[][]", "java.util.Iterator<java.lang.Object>", "java.lang.Object[]"};

    public ProblemDescriptor @Nullable [] checkMethod(@NotNull PsiMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiType returnType;
        String dataProviderFqn = DataProvider.class.getName();
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (String[])new String[]{dataProviderFqn});
        if (annotation != null && (returnType = method.getReturnType()) != null && !DataProviderReturnTypeInspection.isSuitableReturnType(method, returnType)) {
            PsiTypeElement returnTypeElement = method.getReturnTypeElement();
            LOG.assertTrue(returnTypeElement != null);
            boolean supportOneDimensional = DataProviderReturnTypeInspection.supportOneDimensional(method);
            String message = TestngBundle.message("inspection.data.provider.return.type.check", supportOneDimensional ? "Object[][]/Object[] or Iterator<Object[]>/Iterator<Object>" : "Object[][] or Iterator<Object[]>");
            return new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)returnTypeElement, message, isOnTheFly, DataProviderReturnTypeInspection.createFixes(supportOneDimensional, method), ProblemHighlightType.ERROR)};
        }
        return null;
    }

    private static LocalQuickFix[] createFixes(boolean supportOneDimensional, @NotNull PsiMethod method) {
        String[] applicableReturnTypes;
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)method.getProject());
        ArrayList<MethodReturnTypeFix> fixes = new ArrayList<MethodReturnTypeFix>();
        for (String typeText : applicableReturnTypes = supportOneDimensional ? KNOWN_WITH_ONE_DIMENSIONAL_RETURN_TYPES : KNOWN_RETURN_TYPES) {
            fixes.add(new MethodReturnTypeFix(method, elementFactory.createTypeFromText(typeText, (PsiElement)method), false));
        }
        return fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
    }

    private static boolean isSuitableReturnType(PsiMethod method, @NotNull PsiType type) {
        if (type instanceof PsiArrayType) {
            return DataProviderReturnTypeInspection.isObjectArray(method, ((PsiArrayType)type).getComponentType());
        }
        if (type instanceof PsiClassType) {
            PsiClassType.ClassResolveResult resolveResult = ((PsiClassType)type).resolveGenerics();
            PsiClass resolvedClass = resolveResult.getElement();
            if (resolvedClass == null || !"java.util.Iterator".equals(resolvedClass.getQualifiedName())) {
                return false;
            }
            Map substitutionMap = resolveResult.getSubstitutor().getSubstitutionMap();
            if (substitutionMap.size() != 1) {
                return false;
            }
            PsiType genericType = (PsiType)ContainerUtil.getFirstItem(substitutionMap.values());
            if (genericType == null) {
                return false;
            }
            return DataProviderReturnTypeInspection.isObjectArray(method, genericType);
        }
        return false;
    }

    private static boolean supportOneDimensional(PsiMethod method) {
        Version version = TestNGUtil.detectVersion(method.getProject(), ModuleUtilCore.findModuleForPsiElement((PsiElement)method));
        return version != null && version.isOrGreaterThan(Integer.valueOf(6), Integer.valueOf(11));
    }

    private static boolean isObjectArray(PsiMethod method, @NotNull PsiType type) {
        if (!(type instanceof PsiArrayType)) {
            return DataProviderReturnTypeInspection.supportOneDimensional(method) && type.equalsToText("java.lang.Object");
        }
        PsiType componentType = ((PsiArrayType)type).getComponentType();
        if (!(componentType instanceof PsiClassType)) {
            return false;
        }
        PsiClass resolvedClass = ((PsiClassType)componentType).resolve();
        if (resolvedClass == null) {
            return false;
        }
        return "java.lang.Object".equals(resolvedClass.getQualifiedName());
    }
}

