/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.fixtures;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageStandard;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceImpl;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceListener;
import com.jetbrains.cidr.lang.workspace.compiler.ClangFeatures;
import com.jetbrains.cidr.lang.workspace.compiler.GCCCompiler;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import com.jetbrains.cidr.project.workspace.CidrWorkspace;
import com.jetbrains.cidr.project.workspace.OCRootsSynchronizer;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCMockWorkspace
extends CidrWorkspace {
    @NotNull
    private final OCWorkspaceImpl myDelegate;
    @NotNull
    private final String myClientKey;
    @NotNull
    private final Set<VirtualFile> myAdditionalSourceFiles = new THashSet();
    @NotNull
    private final Set<VirtualFile> myGeneratedSourceFiles = new THashSet();
    private boolean myContentRootAsSourceFolder = true;

    public OCMockWorkspace(@NotNull OCWorkspaceImpl delegate, @NotNull String clientKey, @Nullable VirtualFile contentRoot) {
        super(delegate.getProject());
        this.myDelegate = delegate;
        this.myClientKey = clientKey;
        this.myContentRoot = contentRoot != null ? VfsUtilCore.virtualToIoFile((VirtualFile)contentRoot) : null;
        this.myProject.getMessageBus().connect((Disposable)this.myProject).subscribe(OCWorkspaceListener.TOPIC, (Object)new OCWorkspaceListener(){

            public void workspaceChanged(@NotNull OCWorkspaceListener.OCWorkspaceEvent event) {
                OCMockWorkspace.this.updateRoots();
            }
        });
        Disposer.register((Disposable)this.myProject, (Disposable)new Disposable(){

            public void dispose() {
                if (!ApplicationManager.getApplication().isDisposed()) {
                    OCMockWorkspace.this.unload(true);
                }
            }
        });
    }

    void initialized() {
        super.initializeAndStart();
        this.myDelegate.setInitialized();
        this.updateRoots();
    }

    @Nullable
    protected File beforeUpdateContentRoots(@Nullable File contentRoot) {
        return contentRoot;
    }

    protected boolean shouldEnableRootConfiguration() {
        return false;
    }

    public void setContentRootAsSourceFolder(boolean value) {
        this.myContentRootAsSourceFolder = value;
        this.updateRoots();
    }

    @Nullable
    public OCLanguageKind addSourceFile(@NotNull VirtualFile file2, @Nullable OCLanguageKind forcedKind, OCResolveConfiguration.ModifiableModel ... addTo) {
        String fileName = file2.getName();
        if (!OCFileTypeHelpers.isHeaderFile((String)fileName)) {
            OCLanguageKind kind;
            OCLanguageKind oCLanguageKind = kind = forcedKind != null ? forcedKind : OCLanguageKindCalculator.calculateMinimalKindByExtension((Project)this.myProject, (String)fileName);
            if (kind == null) {
                System.err.println("Unknown language kind for " + fileName);
            } else {
                for (OCResolveConfiguration.ModifiableModel eachConfig : addTo) {
                    eachConfig.addSource(file2, kind);
                }
                return kind;
            }
        }
        this.myAdditionalSourceFiles.add(file2);
        return null;
    }

    public void removeSourceFile(@NotNull VirtualFile file2, @NotNull OCWorkspace.ModifiableModel model) {
        model.getConfigurations().forEach(it -> it.removeSource(file2));
        this.myAdditionalSourceFiles.remove(file2);
    }

    public void addGeneratedSourceFile(@NotNull VirtualFile file2) {
        this.myGeneratedSourceFiles.add(file2);
    }

    @NotNull
    public OCWorkspace getDelegate() {
        return this.myDelegate;
    }

    @NotNull
    public String getClientKey() {
        return this.myClientKey;
    }

    @NotNull
    protected OCRootsSynchronizer.RootsInfo collectRootsInfo(@Nullable File contentRoot) {
        ArrayList<File> additionalSourceFiles = new ArrayList<File>(VfsUtilCore.virtualToIoFiles(this.myAdditionalSourceFiles));
        if (this.myContentRootAsSourceFolder) {
            additionalSourceFiles.add(contentRoot);
        }
        OCRootsSynchronizer.RootsInfo info = CidrWorkspace.createRootsInfo((List)this.myDelegate.getConfigurations(this.myClientKey), (List)CollectionsKt.listOfNotNull((Object)contentRoot), additionalSourceFiles, (List)VfsUtilCore.virtualToIoFiles(this.myGeneratedSourceFiles));
        info.registerSystemHeaderRootUnderContentRootAsLibraries = true;
        return info;
    }

    void updateRoots() {
        if (!this.isInitialized() || this.myContentRoot == null) {
            return;
        }
        try {
            ((AppUIExecutor)AppUIExecutor.onWriteThread().expireWith((Disposable)this.myProject)).submit(() -> WriteAction.run(() -> this.updateContentRoots())).get();
        }
        catch (Throwable e) {
            ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public static void applyDefaultDefinesAndFeatures(@NotNull OCLanguageKind languageKind, @NotNull OCCompilerSettings.ModifiableModel model) {
        OCMockWorkspace.applyDefinesAndFeatures(languageKind, model, new CompilerSettingsData(null, null, null));
    }

    static void applyDefinesAndFeatures(@NotNull OCLanguageKind languageKind, @NotNull OCCompilerSettings.ModifiableModel model, @NotNull CompilerSettingsData data) {
        THashMap allFeatures = new THashMap();
        StringBuilder allDefines = new StringBuilder();
        if (languageKind.isObjC()) {
            allDefines.append("#define __OBJC__\n#define __objc_no ((BOOL)0)\n#define __objc_yes ((BOOL)1)\n");
            for (OCCompilerFeatures.Feature each : OCCompilerFeatures.Feature.values()) {
                if (!StringUtil.startsWithIgnoreCase((String)each.name(), (String)"OBJC_")) continue;
                allFeatures.put(each, true);
            }
        }
        if (languageKind.isCpp()) {
            OCLanguageStandard std = OCLanguageStandard.CPP11;
            String string = "201103L";
            allDefines.append("#define __cplusplus ").append(string).append("\n");
            for (OCCompilerFeatures.Feature each : OCCompilerFeatures.Feature.values()) {
                if (!StringUtil.startsWithIgnoreCase((String)each.name(), (String)"CXX_")) continue;
                OCLanguageStandard featureStandard = each.getAvailableInStandard();
                allFeatures.put(each, featureStandard != null && std.supports(featureStandard));
            }
        }
        if (data.features != null) {
            allFeatures.putAll(data.features);
        }
        if (data.defines != null) {
            allDefines.append(data.defines).append("\n");
        }
        allDefines.append(GCCCompiler.getClangTestMacros());
        allDefines.append(GCCCompiler.getGCCBuiltInFunctionMacros());
        for (Map.Entry entry : allFeatures.entrySet()) {
            if (!(entry.getKey() instanceof OCCompilerFeatures.Feature)) continue;
            String clangId = ClangFeatures.getClangIdForFeature((OCCompilerFeatures.Feature)((OCCompilerFeatures.Feature)entry.getKey()));
            allDefines.append("#define ").append(GCCCompiler.clangFeatureMacro((String)clangId)).append(" ").append(Boolean.TRUE.equals(entry.getValue()) ? "1" : "0").append("\n");
        }
        model.setPreprocessorDefines(allDefines.toString());
        model.setCompilerFeatures((Map)allFeatures);
        model.setCompilerSwitches(data.switches);
    }

    static class CompilerSettingsData {
        @Nullable
        String defines;
        @Nullable
        Map<OCCompilerFeatures.Type<?>, ?> features;
        @Nullable
        CidrCompilerSwitches switches;

        CompilerSettingsData(@Nullable String defines, @Nullable Map<OCCompilerFeatures.Type<?>, ?> features, @Nullable CidrCompilerSwitches switches) {
            this.defines = defines;
            this.features = features;
            this.switches = switches;
        }
    }
}

