/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.fixtures;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.jetbrains.cidr.lang.daemon.clang.ClangResolveUtils;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.startup.ClangLanguageServiceStartupActivity;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class OCClangdTestUtil {
    public static void setUp(@NotNull Project project2, @NotNull Disposable disposable, final @NotNull Runnable onCrash) {
        ClangUtils.forceClangdOn((Project)project2);
        ClangUtils.forceClangdShowErrorsOn((Project)project2);
        ClangLanguageServiceProvider provider = ClangLanguageServiceProvider.getProvider((Project)project2);
        assert (provider != null);
        project2.putUserData(ClangDaemonContext.URL_CONVERTER_KEY, (Object)new ClangMockUrlConverter());
        project2.putUserData(ClangUtils.CLANGD_ARCHITECTURE, (Object)"x86_64");
        project2.putUserData(ClangUtils.CLANGD_OS, (Object)"darwin");
        project2.putUserData(ClangUtils.CLANGD_ENVIRONMENT, (Object)"unknown");
        project2.putUserData(ClangResolveUtils.CLANG_CAN_OPEN_FILE, (Object)true);
        ClangLanguageServiceStartupActivity.runStartupActivity((Project)project2);
        Disposer.register((Disposable)disposable, () -> {
            provider.stop();
            ClangUtils.nonForceClangd((Project)project2);
            ClangUtils.nonForceClangdShowErrors((Project)project2);
        });
        ClangLanguageService service = provider.getOrStart();
        service.getMessageBus().connect(disposable).subscribe(ClangServerListener.TOPIC, (Object)new ClangServerListener(){

            public void onServerFailure() {
                onCrash.run();
            }
        });
    }

    private static class ClangMockUrlConverter
    extends ClangUrlConverter {
        private static final Map<String, String> myConvertedMockFiles = new HashMap<String, String>();

        private ClangMockUrlConverter() {
        }

        public boolean isAcceptable(@NotNull String url) {
            return true;
        }

        @NotNull
        public String fromUri(@NotNull String uri) {
            return super.fromUri(uri);
        }

        @NotNull
        public String toUri(@NotNull String urlOrPath) {
            if (urlOrPath.startsWith("mock:")) {
                String uri = ClangdLanguageService.vfs2fileUriTransform(x$0 -> super.toUri(x$0), (String)urlOrPath);
                myConvertedMockFiles.put(uri, urlOrPath);
                return uri;
            }
            return super.toUri(urlOrPath);
        }

        @NotNull
        public String fromUriToUrl(@NotNull String uri) {
            String urlOrPath = myConvertedMockFiles.get(uri);
            if (urlOrPath != null) {
                return urlOrPath;
            }
            return super.fromUriToUrl(uri);
        }
    }
}

