/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.completion;

import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.fixtures.OCClangdCodeInsightTestCase;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class CidrCompletionTestCase
extends OCClangdCodeInsightTestCase {
    protected boolean myClangdOn = false;
    protected static final List<String> C_standardStatementCompletionsWithoutDirectives = Arrays.asList("asm()", "char", "do", "double", "enum", "float", "for", "goto", "int", "if", "auto", "register", "volatile", "long", "return", "short", "signed", "sizeof()", "struct", "switch", "typedef", "typeof()", "union", "unsigned", "void", "while", "static", "const");
    protected static final List<String> OBJC_standardStatementCompletionsWithoutDirectives = ContainerUtil.prepend(C_standardStatementCompletionsWithoutDirectives, (Object[])new String[]{"@autoreleasepool {}", "@protocol()", "@selector()", "@synchronized() {}", "@throw", "@try {}"});
    protected static final List<String> CPP_standardStatementCompletionsWithoutDirectives = ContainerUtil.prepend(C_standardStatementCompletionsWithoutDirectives, (Object[])new String[]{"alignas()", "alignof()", "bool", "char16_t", "char32_t", "class", "const_cast<>", "constexpr", "decltype()", "delete", "dynamic_cast<>", "false", "new", "noexcept()", "nullptr", "reinterpret_cast<>", "static_assert()", "static_cast<>", "template", "thread_local", "throw", "true", "try {}", "typeid()", "typename", "using", "wchar_t", "and", "and_eq", "bitand", "bitor", "compl", "not", "not_eq", "or", "or_eq", "xor", "xor_eq"});
    protected static final Set<String> OBJCPP_standardStatementCompletionsWithoutDirectives = new HashSet<String>(ContainerUtil.concat(OBJC_standardStatementCompletionsWithoutDirectives, CPP_standardStatementCompletionsWithoutDirectives));
    protected static final List<String> standardExpressionCompletionsWithoutDirectives = Arrays.asList("char", "double", "enum", "float", "int", "auto", "register", "volatile", "long", "self", "_cmd", "super", "short", "signed", "sizeof", "struct", "typedef", "typeof", "union", "unsigned", "void", "static", "const");

    @Override
    protected void startClangdIfNeeded(@NotNull Project project2) {
        if (this.myClangdOn) {
            super.startClangdIfNeeded(project2);
            return;
        }
        ClangUtils.forceClangdOff((Project)project2);
        ClangUtils.forceClangdShowErrorsOff((Project)project2);
    }

    @Override
    protected boolean isLegacyTest() {
        return !this.myClangdOn;
    }

    protected void expectSingleVariant(String text, String prefix, String item) {
        this.expectSingleVariant(text, prefix, item, false);
    }

    protected void expectSingleVariant(String text, String prefix, String item, boolean cpp) {
        if (cpp) {
            this.configureByTextOCpp(text.replace("$$", prefix + "<caret>"));
        } else {
            this.configureByTextOC(text.replace("$$", prefix + "<caret>"));
        }
        this.myCodeInsightFixture.complete(1);
        if (!item.contains("<caret>")) {
            item = item + "<caret>";
        }
        this.checkResult(text.replace("$$", item));
    }

    public void expectCompletion(String prefix, String ... items) {
        this.myCodeInsightFixture.expectCompletion(prefix, items);
    }

    public void expectCompletionContains(String prefix, String ... items) {
        this.myCodeInsightFixture.expectCompletionContains(prefix, 1, items);
    }

    public void expectCompletionContains(String prefix, int time, String ... items) {
        this.myCodeInsightFixture.expectCompletionContains(prefix, time, items);
    }

    public void expectCompletion(String prefix, int time, String ... items) {
        this.myCodeInsightFixture.expectCompletion(prefix, time, items);
    }
}

