/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.FutureResult;
import com.jetbrains.cidr.CidrDebugProjectMarkup;
import com.jetbrains.cidr.CidrProjectFixture;
import com.jetbrains.cidr.CidrTestProjectDescription;
import com.jetbrains.cidr.execution.CidrExecutionFixture;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerTestCase;
import com.jetbrains.cidr.execution.debugger.CidrDebuggingFixture;
import com.jetbrains.cidr.execution.debugger.DebuggerDriverKind;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrDebuggerDriverThreadsTestCase<PROJECT_FIXTURE extends CidrProjectFixture, EXECUTION_FIXTURE extends CidrExecutionFixture<PROJECT_FIXTURE>, DEBUGGING_FIXTURE extends CidrDebuggingFixture<EXECUTION_FIXTURE>>
extends CidrDebuggerTestCase<PROJECT_FIXTURE, EXECUTION_FIXTURE, DEBUGGING_FIXTURE, CidrDebugProjectMarkup> {
    public CidrDebuggerDriverThreadsTestCase(DebuggerDriverKind backend, String fixtureProjectFileRelativePath) {
        super(backend, CidrDebugProjectMarkup.TARGET_FOR_THREADS, new CidrTestProjectDescription(fixtureProjectFileRelativePath));
    }

    @Override
    @NotNull
    protected CidrDebugProjectMarkup createProjectMarkup(@NotNull VirtualFile projectDir) {
        return new CidrDebugProjectMarkup(projectDir);
    }

    public void testCollectingThreads() throws Exception {
        final FutureResult stopped = new FutureResult();
        this.startDriver(new CidrDebuggerTestCase.NullHandler(){

            public void handleBreakpoint(@NotNull DebuggerDriver.StopPlace stopPlace, int breakpointNumber) {
                stopped.set((Object)stopPlace);
            }
        });
        this.loadApp("fork_2_threads");
        this.myDriver.addBreakpoint(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_THREADS.getPath(), ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_THREADS_NOT_STARTED);
        this.myDriver.addBreakpoint(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_THREADS.getPath(), ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_THREADS_STARTED);
        this.myDriver.addBreakpoint(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_THREADS.getPath(), ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_THREADS_EXITED);
        this.myInferior.start();
        DebuggerDriver.StopPlace stopPlace = (DebuggerDriver.StopPlace)CidrDebuggingFixture.waitFor(stopped);
        this.assertFrame(stopPlace.frame, (Integer)0, this.getExpectedSourceFilePath(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_THREADS), (Integer)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_THREADS_NOT_STARTED);
        List notStartedThreads = this.myDriver.getThreads();
        CidrDebuggerDriverThreadsTestCase.assertContainsElements((Collection)notStartedThreads, (Object[])new LLThread[]{stopPlace.thread});
        this.myDriver.resume();
        stopPlace = (DebuggerDriver.StopPlace)CidrDebuggingFixture.waitFor(stopped);
        this.assertFrame(stopPlace.frame, (Integer)0, this.getExpectedSourceFilePath(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_THREADS), (Integer)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_THREADS_STARTED);
        List actualThreads = this.myDriver.getThreads();
        CidrDebuggerDriverThreadsTestCase.assertContainsElements((Collection)actualThreads, (Object[])new LLThread[]{stopPlace.thread});
        String forkedFuncNameRegex = "forked_thread_func";
        List<LLThread> startedThreads = this.filterTargetThreads(actualThreads, "forked_thread_func");
        if (2 != startedThreads.size()) {
            String status = this.dumpThreadsStatus(actualThreads);
            CidrDebuggerDriverThreadsTestCase.fail((String)String.format("Expected 2 forked threads, detected: %d\nStatus:\n%s", startedThreads.size(), status));
        }
        this.myDriver.resume();
        stopPlace = (DebuggerDriver.StopPlace)CidrDebuggingFixture.waitFor(stopped);
        this.assertFrame(stopPlace.frame, (Integer)0, this.getExpectedSourceFilePath(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_THREADS), (Integer)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_THREADS_EXITED);
        actualThreads = this.myDriver.getThreads();
        CidrDebuggerDriverThreadsTestCase.assertContainsElements((Collection)actualThreads, (Object[])new LLThread[]{stopPlace.thread});
        List<LLThread> exitedThreads = this.filterTargetThreads(actualThreads, "forked_thread_func");
        if (0 != exitedThreads.size()) {
            String status = this.dumpThreadsStatus(actualThreads);
            CidrDebuggerDriverThreadsTestCase.fail((String)String.format("Expected 2 forked threads, detected: %d\nStatus:\n%s", startedThreads.size(), status));
        }
    }

    public void testBreakpointInsideThread() throws Exception {
        final FutureResult stopped = new FutureResult();
        this.startDriver(new CidrDebuggerTestCase.NullHandler(){

            public void handleBreakpoint(@NotNull DebuggerDriver.StopPlace stopPlace, int breakpointNumber) {
                stopped.set((Object)stopPlace);
            }
        });
        this.loadApp("fork_thread");
        this.myDriver.addBreakpoint(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_THREADS.getPath(), ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_THREAD_FUNC_INNER);
        this.myInferior.start();
        DebuggerDriver.StopPlace stopPlace = (DebuggerDriver.StopPlace)CidrDebuggingFixture.waitFor(stopped);
        this.assertFrame(stopPlace.frame, (Integer)0, this.getExpectedSourceFilePath(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_THREADS), (Integer)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_THREAD_FUNC_INNER);
        CidrDebuggingFixture.assertUnorderedLLValues(this.myDriver.getVariables(stopPlace.thread.getId(), stopPlace.frame.getIndex()), "thread_param", "local");
    }

    public void testCollectedThreadIds() throws Exception {
        String status;
        List<LLThread> forkedThreads;
        List allThreads;
        int i;
        final FutureResult stopped = new FutureResult();
        int nrForkedThreads = 3;
        this.startDriver(new CidrDebuggerTestCase.NullHandler(){

            public void handleBreakpoint(@NotNull DebuggerDriver.StopPlace stopPlace, int breakpointNumber) {
                stopped.set((Object)stopPlace);
            }
        });
        this.loadApp("fork_3_threads_chain");
        this.myDriver.addBreakpoint(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_THREADS.getPath(), ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_THREAD_CHAIN_MAIN);
        this.myDriver.addBreakpoint(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_THREADS.getPath(), ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_THREAD_CHAIN_ENTERED);
        this.myDriver.addBreakpoint(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_THREADS.getPath(), ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_THREAD_CHAIN_EXITED);
        this.myInferior.start();
        DebuggerDriver.StopPlace stopPlace = (DebuggerDriver.StopPlace)CidrDebuggingFixture.waitFor(stopped);
        this.assertFrame(stopPlace.frame, (Integer)0, this.getExpectedSourceFilePath(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_THREADS), (Integer)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_THREAD_CHAIN_MAIN);
        List baseThreads = this.myDriver.getThreads();
        CidrDebuggerDriverThreadsTestCase.assertContainsElements((Collection)baseThreads, (Object[])new LLThread[]{stopPlace.thread});
        CidrDebuggerDriverThreadsTestCase.assertEquals((long)this.mainThreadID(), (long)stopPlace.thread.getId());
        this.myDriver.resume();
        String threadFuncNameRegex = "fork_thread_chain";
        for (i = 1; i <= 3; ++i) {
            stopPlace = (DebuggerDriver.StopPlace)CidrDebuggingFixture.waitFor(stopped);
            this.assertFrame(stopPlace.frame, (Integer)0, this.getExpectedSourceFilePath(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_THREADS), (Integer)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_THREAD_CHAIN_ENTERED);
            allThreads = this.myDriver.getThreads();
            forkedThreads = this.filterTargetThreads(allThreads, "fork_thread_chain");
            if (i != forkedThreads.size()) {
                status = this.dumpThreadsStatus(allThreads);
                CidrDebuggerDriverThreadsTestCase.fail((String)String.format("Expected %d forked threads, detected: %d\nStatus:\n%s", i, forkedThreads.size(), status));
            }
            CidrDebuggerDriverThreadsTestCase.assertContainsElements(forkedThreads, (Object[])new LLThread[]{stopPlace.thread});
            CidrDebuggerDriverThreadsTestCase.assertDoesntContain((Collection)baseThreads, (Object[])new LLThread[]{stopPlace.thread});
            CidrDebuggerDriverThreadsTestCase.assertTrue(((long)i <= stopPlace.thread.getId() ? 1 : 0) != 0);
            this.myDriver.resume();
        }
        for (i = 3; i >= 1; --i) {
            stopPlace = (DebuggerDriver.StopPlace)CidrDebuggingFixture.waitFor(stopped);
            this.assertFrame(stopPlace.frame, (Integer)0, this.getExpectedSourceFilePath(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_THREADS), (Integer)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_THREAD_CHAIN_EXITED);
            allThreads = this.myDriver.getThreads();
            forkedThreads = this.filterTargetThreads(allThreads, "fork_thread_chain");
            if (i != forkedThreads.size()) {
                status = this.dumpThreadsStatus(allThreads);
                CidrDebuggerDriverThreadsTestCase.fail((String)String.format("Expected %d forked threads, detected: %d\nStatus:\n%s", i, forkedThreads.size(), status));
            }
            CidrDebuggerDriverThreadsTestCase.assertContainsElements(forkedThreads, (Object[])new LLThread[]{stopPlace.thread});
            CidrDebuggerDriverThreadsTestCase.assertDoesntContain((Collection)baseThreads, (Object[])new LLThread[]{stopPlace.thread});
            CidrDebuggerDriverThreadsTestCase.assertTrue(((long)i <= stopPlace.thread.getId() ? 1 : 0) != 0);
            this.myDriver.resume();
        }
    }

    public void testCollectedThreadNames() throws Exception {
        List allThreads;
        int i;
        final FutureResult stopped = new FutureResult();
        int nrForkedThreads = 3;
        this.startDriver(new CidrDebuggerTestCase.NullHandler(){

            public void handleBreakpoint(@NotNull DebuggerDriver.StopPlace stopPlace, int breakpointNumber) {
                stopped.set((Object)stopPlace);
            }
        });
        this.loadApp("fork_3_threads_chain");
        this.myDriver.addBreakpoint(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_THREADS.getPath(), ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_THREAD_CHAIN_MAIN);
        this.myDriver.addBreakpoint(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_THREADS.getPath(), ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_THREAD_CHAIN_ENTERED);
        this.myDriver.addBreakpoint(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_THREADS.getPath(), ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_THREAD_CHAIN_EXITED);
        this.myInferior.start();
        DebuggerDriver.StopPlace stopPlace = (DebuggerDriver.StopPlace)CidrDebuggingFixture.waitFor(stopped);
        this.assertFrame(stopPlace.frame, (Integer)0, this.getExpectedSourceFilePath(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_THREADS), (Integer)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_THREAD_CHAIN_MAIN);
        CidrDebuggerDriverThreadsTestCase.assertMatches(stopPlace.thread.getDisplayName(), "^Thread-" + this.mainThreadID() + "\\b.*$");
        CidrDebuggerDriverThreadsTestCase.assertEquals((String)"STOPPED", (String)stopPlace.thread.getState());
        List baseThreads = this.myDriver.getThreads();
        int nrBaseThreads = baseThreads.size() + this.mainThreadID() - 1;
        CidrDebuggerDriverThreadsTestCase.assertContainsElements((Collection)baseThreads, (Object[])new LLThread[]{stopPlace.thread});
        this.myDriver.resume();
        for (i = 1; i <= 3; ++i) {
            stopPlace = (DebuggerDriver.StopPlace)CidrDebuggingFixture.waitFor(stopped);
            this.assertFrame(stopPlace.frame, (Integer)0, this.getExpectedSourceFilePath(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_THREADS), (Integer)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_THREAD_CHAIN_ENTERED);
            CidrDebuggerDriverThreadsTestCase.assertMatches(stopPlace.thread.getDisplayName(), "^Thread-" + (nrBaseThreads + i) + "\\b.*$");
            allThreads = this.myDriver.getThreads();
            allThreads.removeAll(baseThreads);
            CidrDebuggerDriverThreadsTestCase.assertContainsElements((Collection)allThreads, (Object[])new LLThread[]{stopPlace.thread});
            for (LLThread thread : allThreads) {
                CidrDebuggerDriverThreadsTestCase.assertMatches(thread.getDisplayName(), "^Thread-\\d+\\b.*$");
                CidrDebuggerDriverThreadsTestCase.assertEquals((String)"STOPPED", (String)thread.getState());
            }
            CidrDebuggerDriverThreadsTestCase.assertSize((int)i, (Collection)allThreads);
            this.myDriver.resume();
        }
        for (i = 3; i >= 1; --i) {
            stopPlace = (DebuggerDriver.StopPlace)CidrDebuggingFixture.waitFor(stopped);
            this.assertFrame(stopPlace.frame, (Integer)0, this.getExpectedSourceFilePath(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_THREADS), (Integer)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_THREAD_CHAIN_EXITED);
            CidrDebuggerDriverThreadsTestCase.assertMatches(stopPlace.thread.getDisplayName(), "^Thread-" + (nrBaseThreads + i) + "\\b.*$");
            allThreads = this.myDriver.getThreads();
            allThreads.removeAll(baseThreads);
            CidrDebuggerDriverThreadsTestCase.assertContainsElements((Collection)allThreads, (Object[])new LLThread[]{stopPlace.thread});
            for (LLThread thread : allThreads) {
                CidrDebuggerDriverThreadsTestCase.assertMatches(thread.getDisplayName(), "^Thread-\\d+\\b.*$");
                CidrDebuggerDriverThreadsTestCase.assertEquals((String)"STOPPED", (String)thread.getState());
            }
            CidrDebuggerDriverThreadsTestCase.assertSize((int)i, (Collection)allThreads);
            this.myDriver.resume();
        }
    }

    public void testCollectingThreadFrames() throws Exception {
        final FutureResult stopped = new FutureResult();
        this.startDriver(new CidrDebuggerTestCase.NullHandler(){

            public void handleBreakpoint(@NotNull DebuggerDriver.StopPlace stopPlace, int breakpointNumber) {
                stopped.set((Object)stopPlace);
            }
        });
        this.loadApp("fork_thread");
        this.myDriver.addBreakpoint(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_THREADS.getPath(), ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_THREAD_FUNC_INNER);
        this.myInferior.start();
        DebuggerDriver.StopPlace stopPlace = (DebuggerDriver.StopPlace)CidrDebuggingFixture.waitFor(stopped);
        CidrDebuggerDriverThreadsTestCase.assertNotNull((Object)CidrDebuggerDriverThreadsTestCase.findFrame(this.myDriver.getFrames((long)stopPlace.thread.getId(), (int)0, (int)100).list, "forked_thread_func"));
        this.checkAndGetMainThreadAndFrame(stopPlace);
    }

    public void testCollectingThreadVariables() throws Exception {
        final FutureResult stopped = new FutureResult();
        final FutureResult validOutputReceived = new FutureResult();
        final Pattern consolePattern = Pattern.compile(".*\\$\\d = \\d.*", 32);
        this.startDriver(new CidrDebuggerTestCase.NullHandler(){

            public void handleBreakpoint(@NotNull DebuggerDriver.StopPlace stopPlace, int breakpointNumber) {
                stopped.set((Object)stopPlace);
            }

            public void handleDebuggerOutput(@NotNull String text, @NotNull Key type) {
                if (consolePattern.matcher(text).matches()) {
                    validOutputReceived.set((Object)true);
                }
            }
        });
        this.loadApp("fork_thread");
        this.myDriver.addBreakpoint(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_THREADS.getPath(), ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_THREAD_FUNC_INNER);
        this.myInferior.start();
        DebuggerDriver.StopPlace stopPlace = (DebuggerDriver.StopPlace)CidrDebuggingFixture.waitFor(stopped);
        CidrDebuggingFixture.assertUnorderedLLValues(this.myDriver.getVariables(stopPlace.thread.getId(), stopPlace.frame.getIndex()), "thread_param", "local");
        Pair<LLThread, LLFrame> main = this.fetchDataFromMainThread(stopPlace);
        CidrDebuggingFixture.assertUnorderedLLValues(this.myDriver.getVariables(((LLThread)main.first).getId(), ((LLFrame)main.second).getIndex()), "argc", "argv", "i");
    }

    public void testSteppingInsideStoppedThread() throws Exception {
        final FutureResult stopped = new FutureResult();
        this.startDriver(new CidrDebuggerTestCase.NullHandler(){

            public void handleBreakpoint(@NotNull DebuggerDriver.StopPlace stopPlace, int breakpointNumber) {
                stopped.set((Object)stopPlace);
            }

            public void handleInterrupted(@NotNull DebuggerDriver.StopPlace stopPlace) {
                stopped.set((Object)stopPlace);
            }
        });
        this.loadApp("fork_thread");
        this.myDriver.addBreakpoint(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_THREADS.getPath(), ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_THREAD_FUNC_INNER);
        this.myInferior.start();
        DebuggerDriver.StopPlace stopPlace = (DebuggerDriver.StopPlace)CidrDebuggingFixture.waitFor(stopped);
        CidrDebuggerDriverThreadsTestCase.assertNotNull((Object)stopPlace);
        this.fetchDataFromMainThread(stopPlace);
        this.myDriver.stepOut();
        long originalThreadId = stopPlace.thread.getId();
        stopPlace = (DebuggerDriver.StopPlace)CidrDebuggingFixture.waitFor(stopped);
        CidrDebuggerDriverThreadsTestCase.assertNotNull((Object)stopPlace);
        CidrDebuggerDriverThreadsTestCase.assertEquals((long)originalThreadId, (long)stopPlace.thread.getId());
    }

    public void testEvaluateOnCorrectThread() throws Exception {
        final FutureResult stopped = new FutureResult();
        final FutureResult validOutputReceived = new FutureResult();
        final Pattern consolePattern = Pattern.compile(".*\\$\\d = \\d.*", 32);
        this.startDriver(new CidrDebuggerTestCase.NullHandler(){

            public void handleBreakpoint(@NotNull DebuggerDriver.StopPlace stopPlace, int breakpointNumber) {
                stopped.set((Object)stopPlace);
            }

            public void handleDebuggerOutput(@NotNull String text, @NotNull Key type) {
                if (consolePattern.matcher(text).matches()) {
                    validOutputReceived.set((Object)true);
                }
            }
        });
        this.loadApp("fork_thread");
        this.myDriver.addBreakpoint(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_THREADS.getPath(), ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_THREAD_FUNC_INNER);
        this.myInferior.start();
        DebuggerDriver.StopPlace stopPlace = (DebuggerDriver.StopPlace)CidrDebuggingFixture.waitFor(stopped);
        Pair<LLThread, LLFrame> main = this.fetchDataFromMainThread(stopPlace);
        this.myDriver.executeConsoleCommand("print local");
        CidrDebuggerDriverThreadsTestCase.assertEquals((Object)Boolean.TRUE, CidrDebuggingFixture.waitFor(validOutputReceived, 1000L));
        this.myDriver.executeConsoleCommand(stopPlace.thread.getId(), stopPlace.frame.getIndex(), "print local");
        CidrDebuggerDriverThreadsTestCase.assertEquals((Object)Boolean.TRUE, CidrDebuggingFixture.waitFor(validOutputReceived, 1000L));
        this.myDriver.executeConsoleCommand(((LLThread)main.first).getId(), ((LLFrame)main.second).getIndex(), "print argc");
        CidrDebuggerDriverThreadsTestCase.assertEquals((Object)Boolean.TRUE, CidrDebuggingFixture.waitFor(validOutputReceived, 1000L));
        this.myDriver.executeConsoleCommand("print local");
        CidrDebuggerDriverThreadsTestCase.assertEquals((Object)Boolean.TRUE, CidrDebuggingFixture.waitFor(validOutputReceived, 1000L));
    }

    private Pair<LLThread, LLFrame> fetchDataFromMainThread(DebuggerDriver.StopPlace stopPlace) throws ExecutionException, DebuggerCommandException {
        Pair<LLThread, LLFrame> threadAndFrame = this.checkAndGetMainThreadAndFrame(stopPlace);
        LLThread otherThread = (LLThread)threadAndFrame.first;
        this.myDriver.getVariables(otherThread.getId(), ((LLFrame)threadAndFrame.second).getIndex());
        return threadAndFrame;
    }

    @NotNull
    private Pair<LLThread, LLFrame> checkAndGetMainThreadAndFrame(DebuggerDriver.StopPlace stopPlace) throws ExecutionException, DebuggerCommandException {
        LLFrame cloneFrame = null;
        LLThread cloneThread = null;
        List threads = this.myDriver.getThreads();
        for (LLThread thread : threads) {
            if (thread.getId() == stopPlace.thread.getId()) continue;
            List frames = this.myDriver.getFrames((long)thread.getId(), (int)0, (int)100).list;
            LLFrame frame = CidrDebuggerDriverThreadsTestCase.findFrame(frames, "main_threads");
            if (frame != null) {
                return Pair.create((Object)thread, (Object)frame);
            }
            if (!SystemInfo.isLinux || this.myBackend != DebuggerDriverKind.LLDB || cloneFrame != null) continue;
            cloneFrame = CidrDebuggerDriverThreadsTestCase.findFrame(frames, "(__)?clone");
            cloneThread = thread;
        }
        if (cloneFrame != null) {
            return Pair.create(cloneThread, cloneFrame);
        }
        CidrDebuggerDriverThreadsTestCase.fail((String)("Main thread not found among " + threads));
        return Pair.empty();
    }

    @Nullable
    private static LLFrame findFrame(@NotNull List<LLFrame> frames, @RegExp String functionName) {
        return frames.stream().filter(it -> it.getFunction().matches(".*" + functionName + ".*")).findFirst().orElse(null);
    }

    @NotNull
    private List<LLThread> filterTargetThreads(@NotNull List<LLThread> threads, @RegExp @NotNull String funcName) throws ExecutionException, DebuggerCommandException {
        ArrayList<LLThread> targetThreads = new ArrayList<LLThread>();
        for (LLThread thread : threads) {
            if (CidrDebuggerDriverThreadsTestCase.findFrame(this.myDriver.getFrames((long)thread.getId(), (int)0, (int)100).list, funcName) == null) continue;
            targetThreads.add(thread);
        }
        return targetThreads;
    }

    @NotNull
    private String dumpThreadsStatus(@NotNull List<LLThread> threads) throws ExecutionException, DebuggerCommandException {
        StringBuilder threadsState = new StringBuilder();
        for (LLThread thread : threads) {
            threadsState.append(thread.toString());
            threadsState.append(" : ");
            DebuggerDriver.ResultList frames = this.myDriver.getFrames(thread.getId(), 0, 20);
            threadsState.append(frames.list.toString());
            if (frames.hasMore) {
                threadsState.append("...");
            }
            threadsState.append("\n");
        }
        return threadsState.toString();
    }
}

