/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.UsefulTestCase;
import com.jetbrains.cidr.CidrProjectFixture;
import com.jetbrains.cidr.execution.CidrContextConfigurationTestCase;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import junit.framework.TestCase;
import org.jetbrains.annotations.NotNull;

public class CidrContextRunConfigurationFixture {
    private final CidrContextConfigurationTestCase myCase;

    public CidrContextRunConfigurationFixture(@NotNull CidrContextConfigurationTestCase ownerCase) {
        this.myCase = ownerCase;
    }

    public CidrTestRunConfiguration assertCheckingConfiguration(PsiElement psiElement) throws RuntimeConfigurationException {
        Object config = this.createContextConfigurationInterface(psiElement);
        CidrContextConfigurationTestCase.assertValidity(config, null);
        UsefulTestCase.assertInstanceOf(config, CidrTestRunConfiguration.class);
        ((CidrTestRunConfiguration)config).getTestData().setTestName(null);
        CidrContextConfigurationTestCase.assertValidity(config, null);
        return (CidrTestRunConfiguration)config;
    }

    @NotNull
    public CidrRunConfiguration createConfiguration(PsiElement element) {
        RunnerAndConfigurationSettings settings = this.myCase.createContextConfiguration(element);
        TestCase.assertNotNull((Object)settings);
        RunConfiguration config = settings.getConfiguration();
        UsefulTestCase.assertInstanceOf((Object)config, CidrRunConfiguration.class);
        return (CidrRunConfiguration)config;
    }

    public void assertNoConfigurationForElement(PsiElement element) {
        RunnerAndConfigurationSettings settings = this.myCase.createContextConfiguration(element);
        TestCase.assertNull((Object)settings);
    }

    @NotNull
    public <T extends CidrRunConfiguration> T createContextConfigurationInterface(PsiElement element) {
        CidrRunConfiguration config = this.createConfiguration(element);
        return (T)config;
    }

    @NotNull
    public <T extends CidrRunConfiguration> T createConfigurationForContext(@NotNull String fileName, @NotNull String label) {
        PsiElement element = this.getFindElement(fileName, label);
        CidrRunConfiguration config = this.createConfiguration(element);
        return (T)config;
    }

    public void assertNoConfigurationForContext(@NotNull String fileName, @NotNull String label) {
        PsiElement element = this.getFindElement(fileName, label);
        this.assertNoConfigurationForElement(element);
    }

    @NotNull
    public PsiElement getFindElement(@NotNull String fileName, @NotNull String label) {
        String text;
        OCFile file2 = ((CidrProjectFixture)this.myCase.getProjectFixture()).findProjectSubOCFile(fileName);
        final String textToFind = "// >>" + label;
        final Ref elementRef = Ref.create();
        file2.accept((PsiElementVisitor)new OCRecursiveVisitor(){

            public void visitComment(@NotNull PsiComment comment) {
                super.visitComment(comment);
                String text = comment.getText();
                if (text != null && text.startsWith(textToFind)) {
                    elementRef.set((Object)comment);
                }
            }
        });
        PsiElement element = (PsiElement)elementRef.get();
        String string = text = element == null ? null : element.getText();
        if (text != null && text.contains("next")) {
            if (text.contains("decl")) {
                element = PsiTreeUtil.getNextSiblingOfType((PsiElement)element, OCDeclarator.class);
            } else if (text.contains("macroCall")) {
                element = PsiTreeUtil.getNextSiblingOfType((PsiElement)element, OCMacroCall.class);
            }
        }
        return element;
    }

    public static String getDefineSubstitution(@NotNull PsiElement context, @NotNull String macroName) {
        return (String)ApplicationManager.getApplication().runReadAction(() -> {
            OCCodeFragment fragment = OCElementFactory.codeFragment((CharSequence)macroName, (Project)context.getProject(), (PsiElement)context, (IFileElementType)OCTokenTypes.OC_FILE, (boolean)false, (boolean)false, (OCLanguageKind)CLanguageKind.C);
            return fragment.getFirstChild() instanceof OCMacroCall ? ((OCMacroCall)fragment.getFirstChild()).getReplacementText() : null;
        });
    }
}

