/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerTestTreeView;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.MapDataContext;
import com.intellij.testFramework.TestDataProvider;
import com.jetbrains.cidr.CidrCodeInsightFixture;
import com.jetbrains.cidr.CidrProjectFixture;
import com.jetbrains.cidr.CidrTestCase;
import com.jetbrains.cidr.execution.BuildTargetAndConfigurationData;
import com.jetbrains.cidr.execution.CidrContextRunConfigurationFixture;
import com.jetbrains.cidr.execution.CidrExecutionFixture;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.debugger.CidrDebuggingFixture;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationData;
import com.jetbrains.cidr.lang.OCTestFrameworks;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import java.util.function.Supplier;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrContextConfigurationTestCase<PROJECT_FIXTURE extends CidrProjectFixture, EXECUTION_FIXTURE extends CidrExecutionFixture<PROJECT_FIXTURE>, DEBUGGING_FIXTURE extends CidrDebuggingFixture<EXECUTION_FIXTURE>>
extends CidrTestCase<PROJECT_FIXTURE, EXECUTION_FIXTURE, DEBUGGING_FIXTURE, CidrCodeInsightFixture> {
    protected CidrContextRunConfigurationFixture myFrameworkFixture;

    @Override
    protected void setUpFixtures() throws Exception {
        super.setUpFixtures();
        this.myFrameworkFixture = new CidrContextRunConfigurationFixture(this);
    }

    @Override
    @NotNull
    public FileSymbolTablesCache.SymbolsProperties.SymbolsKind shouldBuildSymbolTables() {
        return FileSymbolTablesCache.SymbolsProperties.SymbolsKind.ONLY_USED;
    }

    @Nullable
    protected RunnerAndConfigurationSettings createContextConfiguration(PsiElement element, Class<? extends RunConfigurationProducer> runConfigurationProducerClass) {
        MapDataContext dataContext = new MapDataContext();
        ConfigurationContext context = this.createContext(element, dataContext);
        return CidrContextConfigurationTestCase.createContextConfiguration(context, runConfigurationProducerClass);
    }

    @Nullable
    protected static RunnerAndConfigurationSettings createContextConfiguration(@NotNull ConfigurationContext context, Class<? extends RunConfigurationProducer> runConfigurationProducerClass) {
        RunConfigurationProducer producer = RunConfigurationProducer.getInstance(runConfigurationProducerClass);
        ConfigurationFromContext fromContext = producer.findOrCreateConfigurationFromContext(context);
        return fromContext == null ? null : fromContext.getConfigurationSettings();
    }

    @NotNull
    protected ConfigurationContext createContext(@NotNull PsiElement element, @NotNull MapDataContext dataContext) {
        dataContext.put(CommonDataKeys.PROJECT, (Object)this.getProject());
        dataContext.put(LangDataKeys.MODULE, (Object)ModuleUtilCore.findModuleForPsiElement((PsiElement)element));
        dataContext.put(Location.DATA_KEY, (Object)PsiLocation.fromPsiElement((PsiElement)element));
        return ConfigurationContext.getFromContext((DataContext)dataContext);
    }

    public static void assertValidity(@NotNull CidrRunConfiguration config, @Nullable String expectedError) throws RuntimeConfigurationException {
        block3: {
            try {
                config.checkConfiguration();
                if (expectedError != null) {
                    CidrContextConfigurationTestCase.fail((String)("Error expected: " + expectedError));
                }
            }
            catch (RuntimeConfigurationException e) {
                if (expectedError != null && e.getMessage().equals(expectedError)) break block3;
                throw e;
            }
        }
    }

    public void assertReusingExistingConfiguration(PsiElement element) {
        RunnerAndConfigurationSettings settings = this.createContextConfiguration(element);
        RunManagerImpl.getInstanceImpl((Project)this.getProject()).addConfiguration(settings);
        try {
            CidrContextConfigurationTestCase.assertSame((Object)settings, (Object)this.createContextConfiguration(element));
            if (element instanceof LeafElement) {
                element = element.getParent();
            }
            CidrContextConfigurationTestCase.assertSame((Object)settings, (Object)this.createContextConfiguration(PsiTreeUtil.findChildOfType((PsiElement)element, PsiWhiteSpace.class)));
        }
        finally {
            RunManagerImpl.getInstanceImpl((Project)this.getProject()).removeConfiguration(settings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertCreatingFromMultipleTestResults(String pattern, PsiElement psiElement, final SMTestLocator locator, final String ... paths) {
        try {
            CidrContextConfigurationTestCase.getTestApplication().setDataProvider((DataProvider)new TestDataProvider(this.getProject()){

                public Object getData(@NotNull @NonNls String dataId) {
                    if (SMTRunnerTestTreeView.SM_TEST_RUNNER_VIEW.is(dataId)) {
                        return new SMTRunnerTestTreeView(){

                            public TreePath @Nullable [] getSelectionPaths() {
                                TreePath[] res = new TreePath[paths.length];
                                for (int i = 0; i < res.length; ++i) {
                                    res[i] = new TreePath(i);
                                }
                                return res;
                            }

                            @Nullable
                            public SMTestProxy getSelectedTest(@NotNull TreePath selectionPath) {
                                Integer i = (Integer)selectionPath.getLastPathComponent();
                                SMTestProxy test = new SMTestProxy("test" + i, false, paths[i]);
                                test.setLocator(locator);
                                return test;
                            }
                        };
                    }
                    return super.getData(dataId);
                }
            });
            CidrTestRunConfiguration config = (CidrTestRunConfiguration)this.createContextConfiguration(psiElement).getConfiguration();
            CidrContextConfigurationTestCase.assertEquals((Object)CidrTestRunConfigurationData.Mode.PATTERN, (Object)config.getTestData().getTestMode());
            CidrContextConfigurationTestCase.assertEquals((String)pattern, (String)config.getTestData().getTestPattern());
        }
        finally {
            CidrContextConfigurationTestCase.getTestApplication().setDataProvider((DataProvider)new TestDataProvider(this.getProject()));
        }
    }

    protected static void assertTargetForRunConfiguration(@NotNull CidrRunConfiguration configuration2, @Nullable String expectedTargetName) {
        BuildTargetAndConfigurationData buildConfig = configuration2.getTargetAndConfigurationData();
        CidrContextConfigurationTestCase.assertNotNull((Object)buildConfig);
        CidrContextConfigurationTestCase.assertEquals((String)expectedTargetName, (String)buildConfig.target.targetName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean isCanceledWhileProcessed(boolean onEDT, boolean areSymbolsLoaded, @NotNull Computable<Void> computable) {
        Boolean symbolsLoadedInTests = FileSymbolTablesCache.getForceSymbolsLoadedInTests();
        EmptyProgressIndicator progress = new EmptyProgressIndicator();
        try {
            FileSymbolTablesCache.forceSymbolsLoadedInTests((Boolean)areSymbolsLoaded);
            Supplier<Void> producer = () -> CidrContextConfigurationTestCase.lambda$isCanceledWhileProcessed$0(computable, (ProgressIndicator)progress);
            if (onEDT) {
                OCTestFrameworks.executeWithCachedValuesFast(producer);
            } else {
                OCTestFrameworks.executeWithRealValuesSlow(producer);
            }
        }
        finally {
            FileSymbolTablesCache.forceSymbolsLoadedInTests((Boolean)symbolsLoadedInTests);
        }
        return progress.isCanceled();
    }

    public static void checkConfig(@NotNull CidrTestRunConfiguration config, @Nullable String expectedPattern, @Nullable String expectedSuite, @Nullable String expectedTest, @NotNull CidrTestRunConfigurationData.Mode expectedMode, @NotNull String expectedConfName) {
        CidrContextConfigurationTestCase.assertEquals((String)expectedPattern, (String)config.getTestData().getTestPattern());
        CidrContextConfigurationTestCase.assertEquals((String)expectedSuite, (String)config.getTestData().getTestSuite());
        CidrContextConfigurationTestCase.assertEquals((String)expectedTest, (String)config.getTestData().getTestName());
        CidrContextConfigurationTestCase.assertEquals((Object)expectedMode, (Object)config.getTestData().getTestMode());
        CidrContextConfigurationTestCase.assertEquals((String)expectedConfName, (String)config.getName());
    }

    @NotNull
    public PROJECT_FIXTURE getProjectFixture() {
        return (PROJECT_FIXTURE)this.myProjectFixture;
    }

    public abstract RunnerAndConfigurationSettings createContextConfiguration(PsiElement var1);

    private static /* synthetic */ Void lambda$isCanceledWhileProcessed$0(Computable computable, ProgressIndicator progress) {
        return (Void)ProgressManager.getInstance().runProcess(computable, progress);
    }
}

