/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.impl.AbstractProjectViewPSIPane;
import com.intellij.ide.projectView.impl.ProjectViewTree;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.search.scope.NonProjectFilesScope;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.ui.DeferredIcon;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.RowIcon;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrCodeInsightFixture;
import com.jetbrains.cidr.CidrProjectDependentFixture;
import com.jetbrains.cidr.CidrProjectFixture;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public abstract class CidrProjectViewFixture
implements CidrProjectDependentFixture {
    private final CidrProjectFixture myProjectFixture;

    public CidrProjectViewFixture(@NotNull CidrProjectFixture projectFixture) {
        this.myProjectFixture = projectFixture;
    }

    public void setUp() throws Exception {
        this.myProjectFixture.addProjectDependentFixture(this);
    }

    public void tearDown() throws Exception {
        this.myProjectFixture.removeProjectDependentFixture(this);
    }

    @Override
    @NotNull
    public FileSymbolTablesCache.SymbolsProperties.SymbolsKind shouldBuildSymbolTables() {
        return FileSymbolTablesCache.SymbolsProperties.SymbolsKind.NO_SYMBOLS;
    }

    @Override
    public void afterProjectOpened() {
    }

    @Override
    public void beforeProjectClosed() {
    }

    protected abstract AbstractProjectViewPSIPane createPane();

    public void assertNodes(String expectedNodes) {
        Assert.assertEquals((Object)expectedNodes, (Object)this.buildAndPrintTree(false));
    }

    public void assertNodesContain(String expectedNodes) {
        this.assertNodesContain(false, expectedNodes);
    }

    public void assertNodesContain(boolean printIcons, String expectedNodes) {
        String text = this.buildAndPrintTree(printIcons);
        ArrayList textLines = ContainerUtil.newArrayList((Object[])text.split("\n"));
        UsefulTestCase.assertContainsOrdered((Collection)textLines, (Collection)ContainerUtil.newArrayList((Object[])expectedNodes.split("\n")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private String buildAndPrintTree(boolean printIcons) {
        HashSet sourceNodes = new HashSet();
        AbstractProjectViewPSIPane pane = this.createPane();
        try {
            pane.createComponent();
            JTree tree = pane.getTree();
            PlatformTestUtil.expandAll((JTree)tree);
            StringBuilder builder = new StringBuilder();
            this.printTree((ProjectViewTree)tree, tree.getModel().getRoot(), builder, "", sourceNodes, printIcons);
            String string = builder.toString();
            return string;
        }
        finally {
            Disposer.dispose((Disposable)pane);
        }
    }

    private void printTree(ProjectViewTree tree, Object root, StringBuilder builder, String indent, Set<AbstractTreeNode<?>> sourceNodes, boolean printIcons) {
        AbstractTreeNode node = CidrProjectViewFixture.getTreeNode(root);
        if (node != null) {
            if ("External Libraries".equals(node.getName())) {
                return;
            }
            builder.append(indent).append(node.getName());
            if (node.getPresentation().getLocationString() != null) {
                builder.append("@").append(node.getPresentation().getLocationString());
            }
            if (printIcons) {
                builder.append(" ").append(CidrCodeInsightFixture.printIcon(node.getIcon()));
            } else {
                FileColorManager colorManager = FileColorManager.getInstance((Project)this.myProjectFixture.getProject());
                Color color = tree.getFileColorFor((Object)node);
                if (Objects.equals(color, colorManager.getScopeColor(NonProjectFilesScope.NAME))) {
                    builder.append(" [non-project]");
                } else {
                    builder.append(" [project]");
                }
                Icon icon = node.getIcon();
                if (icon instanceof DeferredIcon) {
                    icon = ((DeferredIcon)icon).evaluate();
                }
                if (icon instanceof RowIcon) {
                    icon = (Icon)ArrayUtil.getFirstElement((Object[])((RowIcon)icon).getAllIcons());
                }
                if (icon == AllIcons.Modules.SourceRoot && !PlatformUtils.isAppCode()) {
                    builder.append(" [source root]");
                }
                if (icon == AllIcons.Modules.ExcludeRoot) {
                    builder.append(" [excluded root]");
                }
            }
        } else {
            builder.append("unknown node");
        }
        for (int i = 0; i < tree.getModel().getChildCount(root); ++i) {
            builder.append("\n");
            this.printTree(tree, tree.getModel().getChild(root, i), builder, indent + "  ", sourceNodes, printIcons);
        }
    }

    @Nullable
    private static AbstractTreeNode getTreeNode(Object o) {
        Object object = ((DefaultMutableTreeNode)o).getUserObject();
        return object instanceof AbstractTreeNode ? (AbstractTreeNode)object : null;
    }
}

