/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.PairProcessor;
import com.intellij.util.PathUtilRt;
import com.jetbrains.cidr.CidrCodeInsightFixture;
import com.jetbrains.cidr.CidrProjectFixture;
import com.jetbrains.cidr.CidrRefactoringFixture;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.jetbrains.annotations.NotNull;

public class CidrIncludeModificationsFixture {
    @NotNull
    private final CidrCodeInsightFixture myCodeInsightFixture;
    @NotNull
    private final CidrProjectFixture myProjectFixture;
    @NotNull
    private final Project myProject;
    private final int myExpectedFilesCount;

    public CidrIncludeModificationsFixture(@NotNull CidrProjectFixture projectFixture, @NotNull CidrCodeInsightFixture fixture, int expectedFilesCount) {
        this.myCodeInsightFixture = fixture;
        this.myProjectFixture = projectFixture;
        this.myProject = projectFixture.getProject();
        this.myExpectedFilesCount = expectedFilesCount;
    }

    public static String @NotNull [] affects(String filename, String before, String after) {
        return new String[]{filename, before, after};
    }

    @NotNull
    public static String includeQ(String path) {
        return "#include \"" + path + "\"";
    }

    @NotNull
    public static String includeB(String path) {
        return "#include <" + path + ">";
    }

    @NotNull
    public static String importQ(String path) {
        return "#import \"" + path + "\"";
    }

    @NotNull
    public static String importB(String path) {
        return "#import <" + path + ">";
    }

    public void doTestRename(String from, String to, String[] ... affected) {
        Map<VirtualFile, List<String>> expected = this.prepareExpected(affected);
        CidrRefactoringFixture.performRenameFile(this.myProject, (PsiFile)this.myCodeInsightFixture.getOCFile(from), to);
        TestCase.assertNull((String)("Renamed file still exists with old name " + from), (Object)this.myProjectFixture.findProjectSubFile(from));
        String parentPath = PathUtilRt.getParentPath((String)from);
        TestCase.assertNotNull((String)("Renamed file not found with new name " + from + " -> " + to), (Object)this.myProjectFixture.findProjectSubFile(parentPath + (parentPath.isEmpty() ? "" : "/") + to));
        this.checkIncludes(expected);
    }

    public void doTestMove(String filePath, String newLocation, String[] ... affected) {
        Map<VirtualFile, List<String>> expected = this.prepareExpected(affected);
        OCFile file2 = this.myCodeInsightFixture.getOCFile(filePath);
        PsiDirectory target = this.myProjectFixture.findProjectSubPsiDirectory(newLocation);
        TestCase.assertNotNull((String)"Invalid move target", (Object)target);
        CidrRefactoringFixture.performMoveFile(this.myProject, (PsiFile)file2, target);
        TestCase.assertNull((String)("Moved file still exists " + filePath), (Object)this.myProjectFixture.findProjectSubFile(filePath));
        TestCase.assertNotNull((String)("Moved file not found at the new location " + filePath + " -> " + newLocation), (Object)this.myProjectFixture.findProjectSubFile(newLocation + (newLocation.isEmpty() ? "" : "/") + PathUtilRt.getFileName((String)filePath)));
        this.checkIncludes(expected);
    }

    @NotNull
    private Map<VirtualFile, List<String>> prepareExpected(String[][] affected) {
        HashMap<VirtualFile, List<String>> expected = new HashMap<VirtualFile, List<String>>();
        HashMap<Pair, String> affectedFiles = new HashMap<Pair, String>();
        for (String[] triplet : affected) {
            affectedFiles.put(Pair.create((Object)this.myProjectFixture.getProjectSubFile(triplet[0]), (Object)triplet[1]), triplet[2]);
        }
        this.myCodeInsightFixture.processOCFiles((PairProcessor<OCFile, VirtualFile>)((PairProcessor)(ocFile, file2) -> {
            ArrayList<String> includes = new ArrayList<String>();
            for (OCIncludeDirective directive : ocFile.findIncludeDirectives()) {
                if (directive.getDelimiters() == OCIncludeDirective.Delimiters.NONE) continue;
                String newText = (String)affectedFiles.get(Pair.create((Object)file2, (Object)directive.getText()));
                includes.add(newText != null ? newText : directive.getText());
            }
            expected.put((VirtualFile)file2, (List<String>)includes);
            return true;
        }), this.myExpectedFilesCount);
        return expected;
    }

    private void checkIncludes(Map<VirtualFile, List<String>> expected) {
        this.myCodeInsightFixture.processOCFiles((PairProcessor<OCFile, VirtualFile>)((PairProcessor)(ocFile, file2) -> {
            ArrayList<String> actualIncludes = new ArrayList<String>();
            for (OCIncludeDirective directive : ocFile.findIncludeDirectives()) {
                if (directive.getDelimiters() == OCIncludeDirective.Delimiters.NONE) continue;
                actualIncludes.add(directive.getText());
            }
            UsefulTestCase.assertOrderedEquals((String)("Unexpected includes for " + file2.getName()), actualIncludes, (Iterable)((Iterable)expected.get(file2)));
            return true;
        }), this.myExpectedFilesCount);
    }
}

