/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui;

import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ui.AbstractTableView;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DomTableView
extends AbstractTableView<DomElement> {
    private final List<TypeSafeDataProvider> myCustomDataProviders = new SmartList();

    public DomTableView(Project project2) {
        super(project2);
    }

    public DomTableView(Project project2, String emptyPaneText, String helpID) {
        super(project2, emptyPaneText, helpID);
    }

    public void addCustomDataProvider(TypeSafeDataProvider provider) {
        this.myCustomDataProviders.add(provider);
    }

    @Override
    public void calcData(@NotNull DataKey key, @NotNull DataSink sink) {
        super.calcData(key, sink);
        for (TypeSafeDataProvider customDataProvider : this.myCustomDataProviders) {
            customDataProvider.calcData(key, sink);
        }
    }

    @Override
    protected void wrapValueSetting(@NotNull DomElement domElement, Runnable valueSetter) {
        if (domElement.isValid()) {
            WriteCommandAction.writeCommandAction((Project)this.getProject(), (PsiFile[])new PsiFile[]{DomUtil.getFile(domElement)}).run(() -> valueSetter.run());
            this.fireChanged();
        }
    }
}

