/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.actions.generate;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.ui.actions.generate.GenerateDomElementProvider;
import java.lang.reflect.Type;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class DefaultGenerateElementProvider<T extends DomElement>
extends GenerateDomElementProvider<T> {
    private final Class<T> myChildElementClass;

    public DefaultGenerateElementProvider(String name, Class<T> childElementClass) {
        super(name);
        this.myChildElementClass = childElementClass;
    }

    @Override
    @Nullable
    public T generate(Project project2, Editor editor, PsiFile file2) {
        return this.generate(this.getParentDomElement(project2, editor, file2), editor);
    }

    @Nullable
    protected abstract DomElement getParentDomElement(Project var1, Editor var2, PsiFile var3);

    @Nullable
    public T generate(@Nullable DomElement parent, Editor editor) {
        if (parent == null) {
            return null;
        }
        List<? extends DomCollectionChildDescription> list = parent.getGenericInfo().getCollectionChildrenDescriptions();
        for (DomCollectionChildDescription domCollectionChildDescription : list) {
            int index;
            if (!ReflectionUtil.getRawType((Type)domCollectionChildDescription.getType()).isAssignableFrom(this.myChildElementClass)) continue;
            XmlTag parentTag = parent.getXmlTag();
            if (editor != null && parentTag != null) {
                int offset = editor.getCaretModel().getOffset();
                PsiFile file2 = parentTag.getContainingFile();
                PsiElement psiElement = file2.findElementAt(offset);
                if (psiElement instanceof PsiWhiteSpace && PsiTreeUtil.isAncestor((PsiElement)parentTag, (PsiElement)psiElement, (boolean)false)) {
                    Document document = editor.getDocument();
                    XmlTag childTag = parentTag.createChildTag(domCollectionChildDescription.getXmlElementName(), null, null, true);
                    String text = childTag.getText();
                    document.insertString(offset, (CharSequence)text);
                    Project project2 = editor.getProject();
                    assert (project2 != null);
                    PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
                    documentManager.commitDocument(document);
                    PsiElement element = file2.findElementAt(offset + 1);
                    T domElement = DomUtil.findDomElement(element, this.myChildElementClass);
                    if (domElement != null) {
                        return domElement;
                    }
                    document.deleteString(offset, offset + text.length());
                    documentManager.commitDocument(document);
                }
            }
            return (T)((index = DefaultGenerateElementProvider.getCollectionIndex(parent, domCollectionChildDescription, editor)) < 0 ? domCollectionChildDescription.addValue(parent, this.myChildElementClass) : domCollectionChildDescription.addValue(parent, this.myChildElementClass, index));
        }
        return null;
    }

    private static int getCollectionIndex(DomElement parent, DomCollectionChildDescription childDescription, Editor editor) {
        int offset = editor.getCaretModel().getOffset();
        for (int i = 0; i < childDescription.getValues(parent).size(); ++i) {
            DomElement element = childDescription.getValues(parent).get(i);
            XmlElement xmlElement = element.getXmlElement();
            if (xmlElement == null || xmlElement.getTextRange().getStartOffset() < offset) continue;
            return i;
        }
        return -1;
    }
}

