/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.actions.generate;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.text.NameUtilCore;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementNavigationProvider;
import com.intellij.util.xml.actions.generate.DefaultGenerateElementProvider;
import com.intellij.util.xml.actions.generate.DomTemplateRunner;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDomGenerateProvider<T extends DomElement>
extends DefaultGenerateElementProvider<T> {
    public static final String NAMESPACE_PREFIX_VAR = "NS_PREFIX";
    @Nullable
    private final String myMappingId;

    public AbstractDomGenerateProvider(String description, Class<T> aClass) {
        this(description, aClass, null);
    }

    public AbstractDomGenerateProvider(String description, Class<T> aClass, @Nullable String mappingId) {
        super(description, aClass);
        this.myMappingId = mappingId;
    }

    @Override
    public T generate(Project project2, Editor editor, PsiFile file2) {
        DomElement parentDomElement = this.getParentDomElement(project2, editor, file2);
        Object t = this.generate(parentDomElement, editor);
        this.runTemplate(editor, file2, t, this.getPredefinedVars(parentDomElement, t, editor, file2));
        return t;
    }

    protected Map<String, String> getPredefinedVars(@Nullable DomElement parentDomElement, @Nullable T t, @NotNull Editor editor, @NotNull PsiFile file2) {
        return AbstractDomGenerateProvider.createNamespacePrefixMap(parentDomElement);
    }

    @NotNull
    public static Map<String, String> createNamespacePrefixMap(@Nullable DomElement domElement) {
        HashMap<String, String> vars = new HashMap<String, String>();
        AbstractDomGenerateProvider.addNamespacePrefix(domElement, vars);
        return vars;
    }

    public static void addNamespacePrefix(@Nullable DomElement domElement, @NotNull Map<String, String> vars) {
        String namespacePrefix;
        XmlTag tag;
        if (domElement != null && (tag = domElement.getXmlTag()) != null && !StringUtil.isEmptyOrSpaces((String)(namespacePrefix = tag.getNamespacePrefix()))) {
            vars.put(NAMESPACE_PREFIX_VAR, namespacePrefix + ":");
        }
    }

    protected void runTemplate(Editor editor, PsiFile file2, T t, Map<String, String> predefinedVars) {
        DomTemplateRunner.getInstance(file2.getProject()).runTemplate(t, this.myMappingId, editor, predefinedVars);
    }

    @Override
    protected abstract DomElement getParentDomElement(Project var1, Editor var2, PsiFile var3);

    @Override
    protected void doNavigate(DomElementNavigationProvider navigateProvider, DomElement copy) {
        DomElement element = this.getElementToNavigate(copy);
        if (element != null) {
            super.doNavigate(navigateProvider, element);
        }
    }

    @Nullable
    protected DomElement getElementToNavigate(T t) {
        return t;
    }

    protected static String getDescription(Class<? extends DomElement> aClass) {
        return StringUtil.join(Arrays.asList(NameUtilCore.nameToWords((String)aClass.getSimpleName())), (String)" ");
    }

    @Nullable
    public String getMappingId() {
        return this.myMappingId;
    }
}

