/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.testFramework.IdeaTestUtil;
import com.intellij.testFramework.JavaModuleTestCase;
import com.intellij.testFramework.PsiTestData;
import com.intellij.testFramework.PsiTestUtil;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.util.IncorrectOperationException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.StringTokenizer;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class JavaPsiTestCase
extends JavaModuleTestCase {
    protected PsiManagerImpl myPsiManager;
    protected PsiFile myFile;
    protected PsiTestData myTestDataBefore;
    protected PsiTestData myTestDataAfter;
    private String myDataRoot;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.myPsiManager = (PsiManagerImpl)PsiManager.getInstance((Project)this.myProject);
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            this.myPsiManager = null;
            this.myFile = null;
            this.myTestDataBefore = null;
            this.myTestDataAfter = null;
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    @NotNull
    protected PsiFile createDummyFile(@NotNull String fileName, @NotNull String text) throws IncorrectOperationException {
        FileType type = FileTypeRegistry.getInstance().getFileTypeByFileName(fileName);
        return PsiFileFactory.getInstance((Project)this.myProject).createFileFromText(fileName, type, (CharSequence)text);
    }

    @NotNull
    protected PsiFile createFile(@NonNls @NotNull String fileName, @NotNull String text) throws Exception {
        return this.createFile(this.myModule, fileName, text);
    }

    @NotNull
    protected PsiFile createFile(@NotNull Module module, @NotNull String fileName, @NotNull String text) throws Exception {
        VirtualFile vDir = this.createTempVfsDirectory();
        return this.createFile(module, vDir, fileName, text);
    }

    @NotNull
    protected VirtualFile createTempVfsDirectory() throws IOException {
        File dir = this.createTempDirectory();
        VirtualFile vDir = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(dir);
        assert (vDir != null) : dir;
        return vDir;
    }

    @NotNull
    protected PsiFile createFile(@NotNull Module module, @NotNull VirtualFile vDir, @NotNull String fileName, @NotNull String text) throws IOException {
        return (PsiFile)WriteAction.computeAndWait(() -> {
            if (!ModuleRootManager.getInstance((Module)module).getFileIndex().isInSourceContent(vDir)) {
                this.addSourceContentToRoots(module, vDir);
            }
            VirtualFile vFile = vDir.createChildData((Object)vDir, fileName);
            VfsUtil.saveText((VirtualFile)vFile, (String)text);
            JavaPsiTestCase.assertNotNull((Object)vFile);
            PsiFile file2 = this.myPsiManager.findFile(vFile);
            JavaPsiTestCase.assertNotNull((Object)file2);
            return file2;
        });
    }

    protected void addSourceContentToRoots(@NotNull Module module, @NotNull VirtualFile vDir) {
        PsiTestUtil.addSourceContentToRoots((Module)module, (VirtualFile)vDir);
    }

    protected PsiElement configureByFileWithMarker(@NotNull String filePath, @NotNull String marker) throws Exception {
        VirtualFile vFile = VfsTestUtil.findFileByCaseSensitivePath((String)filePath);
        String fileText = VfsUtilCore.loadText((VirtualFile)vFile);
        int offset = (fileText = StringUtil.convertLineSeparators((String)fileText)).indexOf(marker);
        JavaPsiTestCase.assertTrue((offset >= 0 ? 1 : 0) != 0);
        fileText = fileText.substring(0, offset) + fileText.substring(offset + marker.length());
        this.myFile = this.createFile(vFile.getName(), fileText);
        return this.myFile.findElementAt(offset);
    }

    protected void configure(@NotNull String path, String dataName) throws Exception {
        this.myDataRoot = this.getTestDataPath() + path;
        this.myTestDataBefore = this.loadData(dataName);
        PsiTestUtil.removeAllRoots((Module)this.myModule, (Sdk)IdeaTestUtil.getMockJdk17());
        VirtualFile vDir = PsiTestUtil.createTestProjectStructure((Project)this.myProject, (Module)this.myModule, (String)this.myDataRoot, (Collection)this.myFilesToDelete);
        VirtualFile vFile = vDir.findChild(this.myTestDataBefore.getTextFile());
        this.myFile = this.myPsiManager.findFile(vFile);
    }

    @NotNull
    protected String getTestDataPath() {
        return PathManagerEx.getTestDataPath();
    }

    @NotNull
    protected String loadFile(@NotNull String name) throws Exception {
        String result = FileUtil.loadFile((File)new File(this.getTestDataPath() + File.separatorChar + name));
        return StringUtil.convertLineSeparators((String)result);
    }

    @NotNull
    private PsiTestData loadData(String dataName) throws Exception {
        PsiTestData data = this.createData();
        Element documentElement = JDOMUtil.load((Path)Paths.get(this.myDataRoot, "data.xml"));
        for (Element node : documentElement.getChildren("data")) {
            String value = node.getAttributeValue("name");
            if (!value.equals(dataName)) continue;
            DefaultJDOMExternalizer.readExternal((Object)data, (Element)node);
            data.loadText(this.myDataRoot);
            return data;
        }
        throw new IllegalArgumentException("Cannot find data chunk '" + dataName + "'");
    }

    @NotNull
    protected PsiTestData createData() {
        return new PsiTestData();
    }

    protected void checkResult(String dataName) throws Exception {
        String actualText;
        this.myTestDataAfter = this.loadData(dataName);
        String textExpected = this.myTestDataAfter.getText();
        if (!textExpected.equals(actualText = this.myFile.getText())) {
            System.out.println("Text mismatch: " + this.getName() + "(" + ((Object)((Object)this)).getClass().getName() + ")");
            System.out.println("Text expected:");
            JavaPsiTestCase.printText(textExpected);
            System.out.println("Text found:");
            JavaPsiTestCase.printText(actualText);
            JavaPsiTestCase.fail((String)"text");
        }
    }

    protected static void printText(@NotNull String text) {
        String q = "\"";
        System.out.print("\"");
        text = StringUtil.convertLineSeparators((String)text);
        StringTokenizer tokenizer = new StringTokenizer(text, "\n", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("\n")) {
                System.out.print("\"");
                System.out.println();
                System.out.print("\"");
                continue;
            }
            System.out.print(token);
        }
        System.out.print("\"");
        System.out.println();
    }

    protected void addLibraryToRoots(@NotNull VirtualFile jarFile, @NotNull OrderRootType rootType) {
        JavaPsiTestCase.addLibraryToRoots(this.myModule, jarFile, rootType);
    }

    protected static void addLibraryToRoots(@NotNull Module module, @NotNull VirtualFile root, @NotNull OrderRootType rootType) {
        JavaPsiTestCase.assertEquals((Object)OrderRootType.CLASSES, (Object)rootType);
        ModuleRootModificationUtil.addModuleLibrary((Module)module, (String)root.getUrl());
    }

    public PsiFile getFile() {
        return this.myFile;
    }

    public Document getDocument(@NotNull PsiFile file2) {
        return PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(file2);
    }

    public Document getDocument(@NotNull VirtualFile file2) {
        return FileDocumentManager.getInstance().getDocument(file2);
    }

    public void commitDocument(@NotNull Document document) {
        PsiDocumentManager.getInstance((Project)this.getProject()).commitDocument(document);
    }
}

