/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.git4idea;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Vector;
import org.apache.xmlrpc.DefaultXmlRpcTransportFactory;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcTransportFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitAppUtil {
    public static <T> T sendXmlRequest(@NotNull String methodName, String token, int port, Object ... parameters) {
        try {
            URL url = new URL("http", "127.0.0.1", port, "/RPC2");
            DefaultXmlRpcTransportFactory factory = new DefaultXmlRpcTransportFactory(url);
            factory.setBasicAuthentication("_token_", token);
            XmlRpcClient client = new XmlRpcClient(url, (XmlRpcTransportFactory)factory);
            Vector<Object> params = new Vector<Object>(Arrays.asList(parameters));
            return (T)client.execute(methodName, params);
        }
        catch (IOException | XmlRpcException e) {
            throw new RuntimeException("Invocation failed " + e.getMessage(), e);
        }
    }

    @NotNull
    public static String adjustNullTo(@Nullable String s) {
        return s == null ? "-" : "+" + s;
    }

    @Nullable
    public static String adjustNullFrom(@NotNull String s) {
        return s.charAt(0) == '-' ? null : s.substring(1);
    }

    @NotNull
    public static String getEnv(@NotNull String env) {
        String value = System.getenv(env);
        if (value == null) {
            throw new IllegalStateException(env + " environment variable is not defined!");
        }
        return value;
    }

    public static int getEnvInt(@NotNull String env) {
        return Integer.parseInt(GitAppUtil.getEnv(env));
    }
}

