/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.flags;

import com.android.flags.Flag;
import com.android.flags.FlagGroup;
import com.android.flags.FlagOverrides;
import com.android.flags.Flags;
import com.android.flags.ImmutableFlagOverrides;
import com.android.flags.overrides.DefaultFlagOverrides;
import com.android.flags.overrides.PropertyOverrides;
import com.android.tools.idea.flags.StudioFlagSettings;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.annotations.NotNull;

public final class StudioFlags {
    private static final Flags FLAGS = StudioFlags.createFlags();
    private static final FlagGroup NPW = new FlagGroup(FLAGS, "npw", "New Project Wizard");
    public static final Flag<Boolean> NPW_FIRST_RUN_WIZARD = Flag.create((FlagGroup)NPW, (String)"first.run.wizard", (String)"Show new Welcome Wizard", (String)"Show new version of the Welcome Wizard when Studio starts", (boolean)false);
    public static final Flag<Boolean> NPW_FIRST_RUN_SHOW = Flag.create((FlagGroup)NPW, (String)"first.run.wizard.show", (String)"Show Welcome Wizard always", (String)"Show the Welcome Wizard when Studio starts", (boolean)false);
    public static final Flag<Boolean> NPW_SHOW_JDK_STEP = Flag.create((FlagGroup)NPW, (String)"first.run.jdk.step", (String)"Show JDK setup step", (String)"Show JDK Setup Step in Welcome Wizard", (boolean)true);
    public static final Flag<Boolean> NPW_SHOW_FRAGMENT_GALLERY = Flag.create((FlagGroup)NPW, (String)"show.fragment.gallery", (String)"Show fragment gallery", (String)"Show fragment gallery which contains fragment based templates", (boolean)true);
    public static final Flag<Boolean> NPW_SHOW_GRADLE_KTS_OPTION = Flag.create((FlagGroup)NPW, (String)"show.gradle.kts.option", (String)"Show gradle kts option", (String)"Shows an option on new Project/Module to allow the use of Kotlin script", (boolean)false);
    public static final Flag<Boolean> NPW_NEW_MODULE_WITH_SIDE_BAR = Flag.create((FlagGroup)NPW, (String)"new.module.with.side.bar", (String)"New Module with sidebar", (String)"Shows latest UX implementation of New Module with a left side bar", (boolean)true);
    public static final Flag<Boolean> NPW_NEW_NATIVE_MODULE = Flag.create((FlagGroup)NPW, (String)"new.native.module", (String)"New Android Native Module", (String)"Show template to create a new Android Native module in the new module wizard.", (boolean)false);
    private static final FlagGroup PROFILER = new FlagGroup(FLAGS, "profiler", "Android Profiler");
    public static final Flag<Boolean> PROFILER_CPU_CAPTURE_STAGE = Flag.create((FlagGroup)PROFILER, (String)"cpu.capture.stage", (String)"Enable new capture stage", (String)"With the new System Trace design we have a cpu capture stage. This flag uses that flow instead of the legacy CpuProfilerStageView flow.", (boolean)true);
    public static final Flag<Boolean> PROFILER_ENABLE_NATIVE_SAMPLE = Flag.create((FlagGroup)PROFILER, (String)"memory.heapprofd", (String)"Enable heapprofd captures in the memory profiler.", (String)"Toggles if users can capture heapprofd recordings in the memory profiler. This gates mostly the UI and importing of traces. The perfd functionality is not gated. This feature has a dependency on the trace processor.", (boolean)true);
    public static final Flag<Boolean> PROFILER_UNIFIED_PIPELINE = Flag.create((FlagGroup)PROFILER, (String)"unified.pipeline", (String)"Enables new event pipeline to be used for core components.", (String)"Toggles usage of gRPC apis to fetch data from perfd and the datastore.", (boolean)true);
    public static final Flag<Boolean> PROFILER_ENERGY_PROFILER_ENABLED = Flag.create((FlagGroup)PROFILER, (String)"energy", (String)"Enable Energy profiling", (String)"Enable the new energy profiler. It monitors battery usage of the selected app.", (boolean)true);
    public static final Flag<Boolean> PROFILER_STARTUP_CPU_PROFILING = Flag.create((FlagGroup)PROFILER, (String)"startup.cpu.profiling", (String)"Enable startup CPU Profiling", (String)"Record a method trace on startup by enabling it in the Profiler tab of Run/Debug configuration.", (boolean)true);
    public static final Flag<Boolean> PROFILER_USE_LIVE_ALLOCATIONS = Flag.create((FlagGroup)PROFILER, (String)"livealloc", (String)"Enable JVMTI-based live allocation tracking", (String)"For Android O or newer, allocations are tracked all the time while inside the Memory Profiler.", (boolean)true);
    public static final Flag<Boolean> PROFILER_MEMORY_SNAPSHOT = Flag.create((FlagGroup)PROFILER, (String)"memory.livealloc.snapshot", (String)"Enable Memory Class Histogram Display", (String)"For Android O or newer, supports single-point selection which shows a snapshot of the heap at the specific time.", (boolean)true);
    public static final Flag<Boolean> PROFILER_SAMPLE_LIVE_ALLOCATIONS = Flag.create((FlagGroup)PROFILER, (String)"memory.livealloc.sampled", (String)"Enable Sampled Live Allocation Tracking", (String)"For Android O or newer, allows users to configure the sampling mode of live allocation tracking", (boolean)true);
    public static final Flag<Boolean> PROFILER_TRACK_JNI_REFS = Flag.create((FlagGroup)PROFILER, (String)"jni", (String)"Enable JVMTI-based JNI reference tracking.", (String)"For Android O or newer, JNI references are tracked in Memory Profiler and shown in JNI heap.", (boolean)true);
    public static final Flag<Boolean> PROFILER_PERFORMANCE_MONITORING = Flag.create((FlagGroup)PROFILER, (String)"performance.monitoring", (String)"Enable Profiler Performance Monitoring Options", (String)"Toggles if profiler performance metrics options are enabled.", (boolean)false);
    public static final Flag<Boolean> PROFILER_CPU_NEW_RECORDING_WORKFLOW = Flag.create((FlagGroup)PROFILER, (String)"cpu.new.recording.workflow", (String)"Enable new CPU recording workflow", (String)"Shows recording options and status of the ongoing recording in the method trace pane.", (boolean)true);
    public static final Flag<Boolean> PROFILER_CUSTOM_EVENT_VISUALIZATION = Flag.create((FlagGroup)PROFILER, (String)"custom.event.visualization", (String)"Enable Profiler Custom Event Visualization", (String)"When enabled, profiler will track and display events defined through developer APIs", (boolean)false);
    public static final Flag<Boolean> PROFILER_HEAPDUMP_SEPARATE = Flag.create((FlagGroup)PROFILER, (String)"memory.heapdump.separate", (String)"Show heap dump separately", (String)"Show heap dump as a separate view instead of sharing with the memory monitor", (boolean)true);
    public static final Flag<Boolean> PROFILER_USE_TRACEPROCESSOR = Flag.create((FlagGroup)PROFILER, (String)"perfetto.traceprocessor", (String)"Enable TraceProcessorDaemon", (String)"Use TraceProcessor to parse Perfetto captures instead of Trebuchet/Atrace backend.", (boolean)true);
    private static final FlagGroup ML = new FlagGroup(FLAGS, "ml", "ML");
    public static final Flag<Boolean> ML_MODEL_BINDING = Flag.create((FlagGroup)ML, (String)"modelbinding", (String)"Enable ML model binding", (String)"When enabled, TFLite model file will be recognized and indexed. Please invalidates file caches after enabling (File -> Invalidate Caches...) in order to reindex model files.", (boolean)true);
    private static final FlagGroup ASSET = new FlagGroup(FLAGS, "asset", "Asset Studio");
    public static final Flag<Boolean> ASSET_COPY_MATERIAL_ICONS = Flag.create((FlagGroup)ASSET, (String)"copy.material.icons", (String)"Allow copying icons to Sdk folder", (String)"Allow the IconPickerDialog in Asset Studio to copy bundled material icons in to the Android/Sdk folder", (boolean)false);
    public static final Flag<Boolean> ASSET_DOWNLOAD_MATERIAL_ICONS = Flag.create((FlagGroup)ASSET, (String)"download.material.icons", (String)"Allow downloading icons to Sdk folder", (String)"Allow the IconPickerDialog in Asset Studio to download any new material icons in to the Android/Sdk folder", (boolean)false);
    private static final FlagGroup NELE = new FlagGroup(FLAGS, "nele", "Layout Editor");
    public static final Flag<Boolean> NELE_ANIMATIONS_PREVIEW = Flag.create((FlagGroup)NELE, (String)"animated.preview", (String)"Show preview animations toolbar", (String)"Show an animations bar that allows playback of vector drawable animations.", (boolean)false);
    public static final Flag<Boolean> NELE_MOTION_LAYOUT_ANIMATIONS = Flag.create((FlagGroup)NELE, (String)"animated.motion.layout", (String)"Show preview animations toolbar for MotionLayout", (String)"Show an animations bar that allows playback of MotionLayout animations.", (boolean)false);
    public static final Flag<Boolean> NELE_MOTION_LAYOUT_EDITOR = Flag.create((FlagGroup)NELE, (String)"animated.motion.editor", (String)"Show motion editor for MotionLayout", (String)"Show the motion editor UI for MotionLayout.", (boolean)true);
    public static final Flag<Boolean> NELE_CONSTRAINT_SELECTOR = Flag.create((FlagGroup)NELE, (String)"constraint.selection", (String)"Allow selection of Constraints", (String)"Allow the selection of constraints.", (boolean)true);
    public static final Flag<Boolean> NELE_MOTION_HORIZONTAL = Flag.create((FlagGroup)NELE, (String)"animated.motion.horizontal", (String)"Display motion editor horizontally", (String)"Controls the placement of the motion editor (horizontal versus vertical).", (boolean)false);
    public static final Flag<Boolean> NELE_MOCKUP_EDITOR = Flag.create((FlagGroup)NELE, (String)"mockup.editor", (String)"Enable the Mockup Editor", (String)"Enable the Mockup Editor to ease the creation of Layouts from a design file.", (boolean)false);
    public static final Flag<Boolean> NELE_CONVERT_VIEW = Flag.create((FlagGroup)NELE, (String)"convert.view", (String)"Enable the Convert View action", (String)"Enable the Convert View Action when right clicking on a component", (boolean)true);
    public static final Flag<Boolean> NELE_RENDER_DIAGNOSTICS = Flag.create((FlagGroup)NELE, (String)"diagnostics", (String)"Enable rendering on-screen stats", (String)"If enabled, the surface displays some debug information to diagnose performance", (boolean)false);
    public static final Flag<Boolean> NELE_COLOR_RESOURCE_PICKER_FOR_FILE_EDITORS = Flag.create((FlagGroup)NELE, (String)"editor.color.picker", (String)"Enable popup color resource picker for java and kotlin files.", (String)"Show the popup color resource picker when clicking the gutter icon of color resource in java and kotlin files.", (boolean)true);
    public static final Flag<Boolean> NELE_DRAWABLE_POPUP_PICKER = Flag.create((FlagGroup)NELE, (String)"show.drawable.popup.picker", (String)"Enable drawable popup picker in Xml Editor.", (String)"Show the resource popup picker for picking drawable resources from the Editor's gutter icon.", (boolean)true);
    public static final Flag<Boolean> NELE_LOG_ANDROID_FRAMEWORK = Flag.create((FlagGroup)NELE, (String)"log.android.framework", (String)"Log messages coming from Layoutlib Native.", (String)"Log in the IDEA log the messages coming from Java and native code of Layoutlib Native.", (boolean)false);
    public static final Flag<Boolean> NELE_SCENEVIEW_TOP_TOOLBAR = Flag.create((FlagGroup)NELE, (String)"sceneview.top.toolbar", (String)"Enable the per SceneView top toolbar.", (String)"Enable the per SceneView top toolbar that displays the SceneView contextual actions.", (boolean)true);
    public static final Flag<Boolean> NELE_SCENEVIEW_BOTTOM_BAR = Flag.create((FlagGroup)NELE, (String)"sceneview.bottom.bar", (String)"Enable the per SceneView bottom bar.", (String)"Enable the per SceneView bottom bar that displays the SceneView contextual actions.", (boolean)false);
    public static final Flag<Boolean> NELE_SCENEVIEW_LEFT_BAR = Flag.create((FlagGroup)NELE, (String)"sceneview.left.bar", (String)"Enable SceneView left bar for overlay actions.", (String)"Enable the SceneView left bar that displays the overlay actions.", (boolean)true);
    private static final FlagGroup ASSISTANT = new FlagGroup(FLAGS, "assistant", "Assistants");
    public static final Flag<Boolean> CONNECTION_ASSISTANT_ENABLED = Flag.create((FlagGroup)ASSISTANT, (String)"connection.enabled", (String)"Enable the connection assistant", (String)"If enabled, user can access the Connection Assistant under \"Tools\" and \"Deploy Target Dialog\"", (boolean)true);
    public static final Flag<Boolean> NELE_CONSTRAINT_LAYOUT_ASSISTANT = Flag.create((FlagGroup)ASSISTANT, (String)"layout.editor.help.constraintlayout", (String)"Display Help for Constraint Layout", (String)"If enabled, the assistant panel will display helpful guide on using Constraint Layout.", (boolean)true);
    public static final Flag<Boolean> NELE_MOTION_LAYOUT_ASSISTANT = Flag.create((FlagGroup)ASSISTANT, (String)"layout.editor.help.motionlayout", (String)"Display Help for Motion Layout", (String)"If enabled, the assistant panel will display helpful guide on using Motion Layout.", (boolean)true);
    public static final Flag<Boolean> NELE_NAV_EDITOR_ASSISTANT = Flag.create((FlagGroup)ASSISTANT, (String)"layout.editor.help.naveditor", (String)"Display Help for Navigation Editor", (String)"If enabled, the assistant panel will display helpful guide on using the Navigation Editor.", (boolean)true);
    public static final Flag<Boolean> NELE_DRAG_PLACEHOLDER = Flag.create((FlagGroup)NELE, (String)"drag.placeholder", (String)"Dragging widgets with Placeholders", (String)"New architecture for dragging widgets in Layout Editor", (boolean)true);
    public static final Flag<Boolean> NELE_PROPERTY_PANEL_ACTIONBAR = Flag.create((FlagGroup)NELE, (String)"property.panel.actionbar", (String)"Property Panel Actionbar", (String)"Support Actionbar in property panel", (boolean)false);
    public static final Flag<Boolean> NELE_VISUALIZATION = Flag.create((FlagGroup)NELE, (String)"visualisation", (String)"Layout Validation Tool", (String)"Enable Layout Validation Tool to preview layout in multiple configurations at the same time", (boolean)true);
    public static final Flag<Boolean> NELE_VISUALIZATION_LOCALE_MODE = Flag.create((FlagGroup)NELE, (String)"visualization.locale", (String)"Locale Mode in Layout Validation Tool", (String)"Enable locale mode in Layout Validation Tool to preview layout in project's locales", (boolean)false);
    public static final Flag<Boolean> NELE_SOURCE_CODE_EDITOR = Flag.create((FlagGroup)NELE, (String)"show.source.code.editor", (String)"New Source Code Editor", (String)"Enable new source code editor with preview(s) coming as a substitute to Compose and Custom View editors.", (boolean)true);
    public static final Flag<Boolean> NELE_TOGGLE_TOOLS_ATTRIBUTES_IN_PREVIEW = Flag.create((FlagGroup)NELE, (String)"toggle.tools.attributes.preview", (String)"New Toggle for Tools namespaces attributes", (String)"Enable the new toggle in the Layout Editor. Allows toggling tools attributes in the Layout preview.", (boolean)true);
    public static final Flag<Boolean> NELE_SHOW_RECYCLER_VIEW_SETUP_WIZARD = Flag.create((FlagGroup)NELE, (String)"recyclerview.setup.wizard", (String)"Show setup wizard for recycler view", (String)"When you right click recycler view in layout editor, you can now see \"Generate Adapter\" that takes you through setup wizard", (boolean)false);
    public static final Flag<Boolean> NELE_CUSTOM_SHORTCUT_KEYMAP = Flag.create((FlagGroup)NELE, (String)"custom.shortcut.keymap", (String)"Design Tool Custom Shortcut", (String)"Make the shortcuts of design tools configurable. The shortcut keymap can be changed in Preferences -> Keymap -> Android Design Tools", (boolean)true);
    public static final Flag<Boolean> NELE_LAYOUT_SCANNER_IN_EDITOR = Flag.create((FlagGroup)NELE, (String)"toggle.layout.editor.validator.a11y", (String)"Toggle layout validator for layout editor.", (String)"When the model changes, layout editor will run the series of layout validations and update lint output", (boolean)false);
    public static final Flag<Boolean> NELE_TRANSFORM_PANEL = Flag.create((FlagGroup)NELE, (String)"toggle.layout.editor.transform.panel", (String)"Toggle transform panel in layout editor and motion editor.", (String)"Enable the new transform panel in the layout editor and motion editor", (boolean)true);
    public static final Flag<Boolean> NELE_TRANSITION_PANEL = Flag.create((FlagGroup)NELE, (String)"toggle.layout.editor.transition.panel", (String)"Toggle transition panel in motion editor.", (String)"Enable the new transition panel in the motion editor", (boolean)true);
    public static final Flag<Boolean> NELE_OVERLAY_PROVIDER = Flag.create((FlagGroup)NELE, (String)"toggle.overlay.provider.extension.point", (String)"Toggle overlay provider extension point.", (String)"Enable the overlay provider extension point", (boolean)true);
    public static final Flag<Boolean> NELE_ASSET_REPOSITORY_INCLUDE_AARS_THROUGH_PROJECT_SYSTEM = Flag.create((FlagGroup)NELE, (String)"asset.repository.include.aars.through.project.system", (String)"Include AARs through project system", (String)"Include resource directories from AARs found through project system.", (boolean)false);
    private static final FlagGroup NAV_EDITOR = new FlagGroup(FLAGS, "nav", "Navigation Editor");
    public static final Flag<Boolean> NAV_SAFE_ARGS_SUPPORT = Flag.create((FlagGroup)NAV_EDITOR, (String)"safe.args.enabled", (String)"Enable support for Safe Args", (String)"Generate in-memory Safe Args classes if the current module is using the feature.", (boolean)true);
    private static final FlagGroup RES_MANAGER = new FlagGroup(FLAGS, "res.manager", "Resource Manager");
    public static final Flag<Boolean> EXTENDED_TYPE_FILTERS = Flag.create((FlagGroup)RES_MANAGER, (String)"extended.filters", (String)"Enable extended filters for resources", (String)"Adds more filter options for resources based on the selected ResourceType. Includes options to filter by resource XML tag or File extension.", (boolean)true);
    public static final Flag<Boolean> NAVIGATION_PREVIEW = Flag.create((FlagGroup)RES_MANAGER, (String)"nav.preview", (String)"Enable previews for Navigation resources", (String)"Adds a visual preview to the Navigation resources in the Resource Manager. The preview corresponds to the start destination of the graph.", (boolean)true);
    private static final FlagGroup RUNDEBUG = new FlagGroup(FLAGS, "rundebug", "Run/Debug");
    public static final Flag<Boolean> RUNDEBUG_LOGCAT_CONSOLE_OUTPUT_ENABLED = Flag.create((FlagGroup)RUNDEBUG, (String)"logcat.console.output.enabled", (String)"Show logcat process output in Run/Debug console window", (String)"When running or debugging an Android process, output the logcat output of the process in the console window.", (boolean)true);
    public static final Flag<Boolean> RUNDEBUG_ANDROID_BUILD_BUNDLE_ENABLED = Flag.create((FlagGroup)RUNDEBUG, (String)"android.bundle.build.enabled", (String)"Enable the Build Bundle action", (String)"If enabled, the \"Build Bundle(s)\" menu item is enabled. Changing the value of this flag requires restarting Android Studio.", (boolean)true);
    public static final Flag<Boolean> DELTA_INSTALL = Flag.create((FlagGroup)RUNDEBUG, (String)"deltainstall", (String)"Delta install", (String)"Upon installing, if application is already on device, only send parts of the apks which have changed (the delta).", (boolean)true);
    public static final Flag<Boolean> APPLY_CHANGES_OPTIMISTIC_SWAP = Flag.create((FlagGroup)RUNDEBUG, (String)"applychanges.optimisticswap", (String)"Use the 'Apply Changes 2.0' deployment pipeline", (String)"Supports Install-without-Install, Speculative Diff and Structural Redefinition", (boolean)true);
    public static final Flag<Boolean> APPLY_CHANGES_OPTIMISTIC_RESOURCE_SWAP = Flag.create((FlagGroup)RUNDEBUG, (String)"applychanges.optimisticresourceswap", (String)"Use the 'Apply Changes 2.0' deployment pipeline for full Apply Changes", (String)"Requires applychanges.optimisticswap to be true.", (boolean)true);
    public static final Flag<OptimisticInstallSupportLevel> OPTIMISTIC_INSTALL_SUPPORT_LEVEL = Flag.create((FlagGroup)RUNDEBUG, (String)"optimisticinstall.supportlevel", (String)"The amount of support for using the 'Apply Changes 2.0' pipeline on Run.", (String)"This can be \"DISABLED\" to always use a package manager installation; \"DEX\" to use the pipeline for dex-only changes; \"DEX_AND_NATIVE\" to use the pipeline for dex and native library-only changes; or \"DEX_AND_NATIVE_AND_RESOURCES\" to use the pipeline for changes to dex, native libraries, and/or resource/asset files. Deploying changes that exceed the level of support configured here will cause the deployment to install via the package manager.", (Enum)OptimisticInstallSupportLevel.DEX);
    public static final Flag<Boolean> APPLY_CHANGES_STRUCTURAL_DEFINITION = Flag.create((FlagGroup)RUNDEBUG, (String)"applychanges.structuralredefinition", (String)"Use ART's new structural redefinition extension for Apply Changes.", (String)"Requires applychanges.optimisticswap to be true.", (boolean)true);
    public static final Flag<Boolean> APPLY_CHANGES_VARIABLE_REINITIALIZATION = Flag.create((FlagGroup)RUNDEBUG, (String)"applychanges.variablereinitialization", (String)"Use ART's new variable reinitializaiton extension for Apply Changes.", (String)"Requires applychanges.structuralredefinition to be true.", (boolean)true);
    public static final Flag<Boolean> APPLY_CHANGES_FAST_RESTART_ON_SWAP_FAIL = Flag.create((FlagGroup)RUNDEBUG, (String)"applychanges.swap.fastrestartonswapfail", (String)"Allow fast restart on swap failure.", (String)"Eliminate the need to build again when auto re-run checkbox is turned on.", (boolean)true);
    public static final Flag<Boolean> APPLY_CHANGES_KEEP_CONNECTION_ALIVE = Flag.create((FlagGroup)RUNDEBUG, (String)"applychanges.connection.keepalive", (String)"Keep connection to device alive.", (String)"Eliminate the cost of opening a connection and spawning a process when using Apply Changes.", (boolean)true);
    public static final Flag<Boolean> SELECT_DEVICE_SNAPSHOT_COMBO_BOX_SNAPSHOTS_ENABLED = Flag.create((FlagGroup)RUNDEBUG, (String)"select.device.snapshot.combo.box.snapshots.enabled", (String)"Enable Select Device/Snapshot combo box snapshots", (String)"So the new Instant Run can use the combo box", (boolean)false);
    public static final Flag<Boolean> RUN_ON_MULTIPLE_DEVICES_ACTION_ENABLED = Flag.create((FlagGroup)RUNDEBUG, (String)"run.on.multiple.devices.action.enabled", (String)"Enable the Run on Multiple Devices action", (String)"To revert to the 4.0 behavior until multiple devices are properly supported for the other executors", (boolean)false);
    public static final Flag<Boolean> ADB_CONNECTION_STATUS_WIDGET_ENABLED = Flag.create((FlagGroup)RUNDEBUG, (String)"adb.connection.status.widget.enabled", (String)"Enable and Show ADB Connection Widget", (String)"Enables and shows the ADB connection status widget in the status bar", (boolean)false);
    public static final Flag<Boolean> ADB_WIRELESS_PAIRING_ENABLED = Flag.create((FlagGroup)RUNDEBUG, (String)"adb.wireless.enabled", (String)"Enable pairing devices through ADB wireless", (String)"Allow pairing new physical device through QR Code pairing via ADB wireless", (boolean)false);
    public static final Flag<Boolean> ADB_SERVER_MANAGEMENT_MODE_SETTINGS_VISIBLE = Flag.create((FlagGroup)RUNDEBUG, (String)"adb.server.management.mode.settings.visible", (String)"Show ADB server management mode settings", (String)"To allow toggling between automatic or user managed ADB server mode.", (boolean)false);
    public static final Flag<DefaultActivityLocatorStrategy> DEFAULT_ACTIVITY_LOCATOR_STRATEGY = Flag.create((FlagGroup)RUNDEBUG, (String)"default.activity.locator.strategy", (String)"Choose a strategy for selecting the default activity to launch from the merged manifest.", (String)"This can be \"BLOCK\" to unconditionally block on a fresh merged manifest, \"STALE\" to use a potentially stale manifest, or \"INDEX\" to use the custom Android Manifest index (only select this option if manifest indexing is enabled).", (Enum)DefaultActivityLocatorStrategy.INDEX);
    public static final Flag<Boolean> DEFAULT_ACTIVITY_LOCATOR_FROM_APKS = Flag.create((FlagGroup)RUNDEBUG, (String)"default.activity.locator.sourceoftruth", (String)"Use APKs as source of truth", (String)"Open APK and parse the manifest in order to discover default activity.", (boolean)true);
    public static final Flag<Boolean> SUPPORT_FEATURE_ON_FEATURE_DEPS = Flag.create((FlagGroup)RUNDEBUG, (String)"feature.on.feature", (String)"Enable feature-on-feature dependencies", (String)"Enables Studio to understand feature-on-feature dependencies when launching dynamic apps.", (boolean)false);
    public static final Flag<Boolean> GRADLE_UNIT_TESTING = Flag.create((FlagGroup)RUNDEBUG, (String)"run.unit.tests.via.gradle", (String)"Run Android unit tests through Gradle", (String)"Switch to running unit tests via Gradle Tooling API instead of JUnit", (boolean)false);
    private static final FlagGroup GRADLE_IDE = new FlagGroup(FLAGS, "gradle.ide", "Gradle Project System");
    public static final Flag<Boolean> FIX_ANDROID_RUN_CONFIGURATIONS_ENABLED = Flag.create((FlagGroup)GRADLE_IDE, (String)"gradle.run.configuration.fix.enabled", (String)"Check Android Run Configurations contains the \"Gradle-aware Make\" task and fix them", (String)"When a project is loaded, automatically add a \"Gradle-aware Make\" task to each Run Configuration if the task is missing", (boolean)true);
    public static final Flag<Boolean> NEW_PSD_ENABLED = Flag.create((FlagGroup)GRADLE_IDE, (String)"new.psd", (String)"Enable new \"Project Structure\" dialog", (String)"Turns on the new \"Project Structure\" dialog.", (boolean)true);
    public static final Flag<Boolean> USE_DEVELOPMENT_OFFLINE_REPOS = Flag.create((FlagGroup)GRADLE_IDE, (String)"development.offline.repos", (String)"Enable development offline repositories", (String)"Makes Gradle use development offline repositories such as /out/repo", (boolean)StudioFlags.isDevBuild());
    public static final Flag<Boolean> BUILD_ATTRIBUTION_ENABLED = Flag.create((FlagGroup)GRADLE_IDE, (String)"build.attribution", (String)"Enable build attribution", (String)"Enable build attribution.", (boolean)true);
    public static final Flag<Boolean> NEW_BUILD_ANALYZER_UI_NAVIGATION_ENABLED = Flag.create((FlagGroup)GRADLE_IDE, (String)"build.analyzer.new.ui.navigation", (String)"Enable new UI navigation model for \"Build Analyzer\"", (String)"Enable new UI navigation model for \"Build Analyzer\".", (boolean)true);
    public static final Flag<Boolean> NEW_BUILD_ANALYZER_UI_VISUALIZATION_ENABLED = Flag.create((FlagGroup)GRADLE_IDE, (String)"build.analyzer.new.ui.visualization", (String)"Enable new visualization for \"Build Analyzer\"", (String)"Enable new visualization of tasks impact for \"Build Analyzer\" as well as filtering feature that depends on it", (boolean)true);
    public static final Flag<Boolean> AGP_UPGRADE_ASSISTANT = Flag.create((FlagGroup)GRADLE_IDE, (String)"agp.upgrade.assistant", (String)"Enable AGP Upgrade Assistant", (String)"Enable the Upgrade Assistant for helping with AGP upgrades", (boolean)true);
    public static final Flag<Boolean> DISABLE_FORCED_UPGRADES = Flag.create((FlagGroup)GRADLE_IDE, (String)"forced.agp.update", (String)"Disable forced Android Gradle plugin upgrades", (String)"This option is only respected when running Android Studio internally.", (boolean)false);
    public static final Flag<Boolean> ALLOW_DIFFERENT_JDK_VERSION = Flag.create((FlagGroup)GRADLE_IDE, (String)"jdk.allow.different", (String)"Allow different Gradle JDK", (String)"Allow usage of a different JDK version when running Gradle.", (boolean)true);
    private static final FlagGroup DATABASE_INSPECTOR = new FlagGroup(FLAGS, "database.inspector", "Database Inspector");
    public static final Flag<Boolean> DATABASE_INSPECTOR_ENABLED = Flag.create((FlagGroup)DATABASE_INSPECTOR, (String)"enabled", (String)"Enable Database Inspector", (String)"If enabled the Database Inspector tool window will appear.SQLite files opened from the Device Explorer will be opened in the inspector.", (boolean)true);
    public static final Flag<Boolean> DATABASE_INSPECTOR_OPEN_FILES_ENABLED = Flag.create((FlagGroup)DATABASE_INSPECTOR, (String)"open.files.enabled", (String)"Enable support for opening SQLite files in Database Inspector", (String)"If enabled, the Database Inspector tool will be able to open SQLite files.eg. SQLite files opened from the Device Explorer will open in the inspector.", (boolean)false);
    public static final Flag<Boolean> DATABASE_INSPECTOR_OFFLINE_MODE_ENABLED = Flag.create((FlagGroup)DATABASE_INSPECTOR, (String)"offline.enabled", (String)"Enable offline mode in Database Inspector", (String)"If enabled, Database Inspector will download a copy of open databases when the connection to the device is lost.", (boolean)true);
    private static final FlagGroup LAYOUT_INSPECTOR = new FlagGroup(FLAGS, "layout.inspector", "Layout Inspector");
    public static final Flag<Boolean> LAYOUT_INSPECTOR_LOAD_OVERLAY_ENABLED = Flag.create((FlagGroup)LAYOUT_INSPECTOR, (String)"load.overlay", (String)"Enable the Load Overlay feature", (String)"If enabled, show actions to let user choose overlay image on preview.", (boolean)true);
    public static final Flag<Boolean> LAYOUT_INSPECTOR_SUB_VIEW_ENABLED = Flag.create((FlagGroup)LAYOUT_INSPECTOR, (String)"sub.view", (String)"Enable the sub view feature", (String)"If enabled, changes the preview to focus on a component.", (boolean)true);
    public static final Flag<Boolean> LAYOUT_INSPECTOR_V2_PROTOCOL_ENABLED = Flag.create((FlagGroup)LAYOUT_INSPECTOR, (String)"capture.v2", (String)"Enable using V2 protocol to capture view data", (String)"If enabled, uses V2 protocol to capture view information from device.", (boolean)false);
    public static final Flag<Boolean> LAYOUT_INSPECTOR_EDITING_ENABLED = Flag.create((FlagGroup)LAYOUT_INSPECTOR, (String)"ui.editing", (String)"Enable editing ViewNode properties in the properties table.", (String)"If enabled, users can edit properties in the properties table.", (boolean)false);
    public static final Flag<Boolean> DYNAMIC_LAYOUT_INSPECTOR_ENABLED = Flag.create((FlagGroup)LAYOUT_INSPECTOR, (String)"dynamic.layout.inspector", (String)"Enable dynamic layout inspector", (String)"Turns on the dynamic layout inspector.", (boolean)true);
    public static final Flag<Boolean> DYNAMIC_LAYOUT_INSPECTOR_EDITING_ENABLED = Flag.create((FlagGroup)LAYOUT_INSPECTOR, (String)"dynamic.layout.editor", (String)"Enable dynamic layout editor", (String)"If enabled, users can edit layout properties with live updates on a device while the dynamic layout inspector is running.", (boolean)false);
    public static final Flag<Boolean> DYNAMIC_LAYOUT_INSPECTOR_USE_DEVBUILD_SKIA_SERVER = Flag.create((FlagGroup)LAYOUT_INSPECTOR, (String)"dynamic.layout.inspector.devbuild.skia", (String)"Use the locally-built skia rendering server", (String)"If enabled and this is a locally-built studio instance, use the locally-built skia server instead of one from the SDK.", (boolean)false);
    public static final Flag<Boolean> DYNAMIC_LAYOUT_INSPECTOR_ENABLE_COMPOSE_SUPPORT = Flag.create((FlagGroup)LAYOUT_INSPECTOR, (String)"dynamic.layout.inspector.compose.support", (String)"Show inspectables from Compose", (String)"If enabled the component tree will include Composable nodes if they are wrapped in an Inspectable.", (boolean)false);
    private static final FlagGroup EMBEDDED_EMULATOR = new FlagGroup(FLAGS, "embedded.emulator", "Embedded Emulator");
    public static final Flag<Boolean> EMBEDDED_EMULATOR_NEW_SNAPSHOT_UI = Flag.create((FlagGroup)EMBEDDED_EMULATOR, (String)"new.snapshot.ui", (String)"Enable new snapshot UI", (String)"Enables the new snapshot management UI", (boolean)true);
    public static final Flag<Boolean> EMBEDDED_EMULATOR_EXTENDED_CONTROLS = Flag.create((FlagGroup)EMBEDDED_EMULATOR, (String)"extended.controls", (String)"Enable Emulator Extended Controls", (String)"Enables the extended controls in the Embedded Emulator", (boolean)false);
    public static final Flag<Boolean> EMBEDDED_EMULATOR_TRACE_GRPC_CALLS = Flag.create((FlagGroup)EMBEDDED_EMULATOR, (String)"trace.grpc.calls", (String)"Enable Emulator gRPC Tracing", (String)"Enables tracing of most Emulator gRPC calls", (boolean)false);
    public static final Flag<Boolean> EMBEDDED_EMULATOR_TRACE_HIGH_VOLUME_GRPC_CALLS = Flag.create((FlagGroup)EMBEDDED_EMULATOR, (String)"trace.high.volume.grpc.calls", (String)"Enable High Volume Emulator gRPC Tracing", (String)"Enables tracing of high volume Emulator gRPC calls", (boolean)false);
    public static final Flag<Boolean> EMBEDDED_EMULATOR_TRACE_SCREENSHOTS = Flag.create((FlagGroup)EMBEDDED_EMULATOR, (String)"trace.screenshots", (String)"Enable Emulator Screenshot Tracing", (String)"Enables tracing of received Emulator screenshots", (boolean)false);
    public static final Flag<Boolean> EMBEDDED_EMULATOR_TRACE_DISCOVERY = Flag.create((FlagGroup)EMBEDDED_EMULATOR, (String)"trace.discovery", (String)"Enable Tracing of Emulator Discovery", (String)"Enables tracing of Emulator discovery", (boolean)false);
    private static final FlagGroup REFACTORINGS = new FlagGroup(FLAGS, "refactor", "Refactor menu");
    public static final Flag<Boolean> MIGRATE_TO_RESOURCE_NAMESPACES_REFACTORING_ENABLED = Flag.create((FlagGroup)REFACTORINGS, (String)"migrateto.resourcenamespaces.enabled", (String)"Enable the Migrate to Resource Namespaces refactoring", (String)"If enabled, show the action in the refactoring menu", (boolean)false);
    public static final Flag<Boolean> MIGRATE_TO_NON_TRANSITIVE_R_CLASSES_REFACTORING_ENABLED = Flag.create((FlagGroup)REFACTORINGS, (String)"migrateto.nontransitiverclasses.enabled", (String)"Enable the Migrate to non-transitive R classes refactoring", (String)"If enabled, show the action in the refactoring menu", (boolean)false);
    private static final FlagGroup IOT = new FlagGroup(FLAGS, "iot", "IoT features");
    public static final Flag<Boolean> UNINSTALL_LAUNCHER_APPS_ENABLED = Flag.create((FlagGroup)IOT, (String)"iot.uninstalllauncherapps.enabled", (String)"Enable the Uninstall of IoT launcher apps feature", (String)"If enabled, uninstall IoT launcher apps when installing a new one", (boolean)false);
    private static final FlagGroup NDK = new FlagGroup(FLAGS, "ndk", "Native code features");
    public static final Flag<Boolean> CMAKE_ENABLE_FEATURES_FROM_CLION = Flag.create((FlagGroup)NDK, (String)"cmakeclionfeatures", (String)"Enable CMake language support from CLion", (String)"If enabled, language support features (e.g. syntax highlighting) currently present in CLion will be turned on.", (boolean)true);
    public static final Flag<Boolean> LLDB_ASSEMBLY_DEBUGGING = Flag.create((FlagGroup)NDK, (String)"debugging.assembly", (String)"Enable assembly debugging", (String)"If enabled, frames without sources will show the assembly of the function and allow breakpoints to be set there", (boolean)false);
    public static final Flag<Boolean> APK_DEBUG_BUILD_ID_CHECK = Flag.create((FlagGroup)NDK, (String)"apkdebugbuildidcheck", (String)"Enable build ID check in APK debugging", (String)"If enabled, the build ID of user-provided symbol files are compared against the binaries inside the APK.", (boolean)true);
    public static final Flag<Boolean> APK_DEBUG_RELOAD = Flag.create((FlagGroup)NDK, (String)"apkdebugreload", (String)"Enable APK reloading feature", (String)"If enabled, the user will be provided with an option to reload the APK inside an APK debugging project", (boolean)true);
    private static final FlagGroup NDK_SIDE_BY_SIDE = new FlagGroup(FLAGS, "ndk.sxs", "NDK Side by Side");
    public static final Flag<Boolean> NDK_SIDE_BY_SIDE_ENABLED = Flag.create((FlagGroup)NDK_SIDE_BY_SIDE, (String)"ndk.sxs.enabled", (String)"Enable side by side NDK support", (String)"If enabled, C/C++ projects will have NDK side by side support", (boolean)true);
    public static final Flag<Boolean> USE_CONTENT_ROOTS_FOR_NATIVE_PROJECT_VIEW = Flag.create((FlagGroup)NDK, (String)"use.content.roots.for.native.project.view", (String)"Use content roots for native project view", (String)"If enabled, the C/C++ content roots are displayed in Android View and Project View. Otherwise, each individual native target is displayed.", (boolean)false);
    private static final FlagGroup EDITOR = new FlagGroup(FLAGS, "editor", "Editor features");
    public static final Flag<Boolean> COLLAPSE_ANDROID_NAMESPACE = Flag.create((FlagGroup)EDITOR, (String)"collapse.android.namespace", (String)"Collapse the android namespace in XML code completion", (String)"If enabled, XML code completion doesn't include resources from the android namespace. Instead a fake completion item is used to offer just the namespace prefix.", (boolean)true);
    public static final Flag<Boolean> RESOLVE_USING_REPOS = Flag.create((FlagGroup)EDITOR, (String)"resolve.using.repos", (String)"Resolve references using resource repositories", (String)"Use ResourceRepository to resolve references, not ResourceManager.", (boolean)true);
    public static final Flag<Boolean> ADVANCED_JNI_ASSISTANCE = Flag.create((FlagGroup)EDITOR, (String)"advanced.jni.assistance", (String)"Enable advanced JNI assistance", (String)"If enabled, additional inspection, completion, and refactoring supports are provided related to JNI. If disabled, some inspections related to JNI may stop working.", (boolean)true);
    public static final Flag<Boolean> CUSTOM_JAVA_NEW_CLASS_DIALOG = Flag.create((FlagGroup)EDITOR, (String)"custom.new.class.dialog", (String)"Enable custom New Class dialog", (String)"If enabled, our custom UI for creating a new Java class is used. Otherwise the platform default is used.", (boolean)false);
    public static final Flag<Boolean> INCREMENTAL_RESOURCE_REPOSITORIES = Flag.create((FlagGroup)EDITOR, (String)"incremental.resource.repositories", (String)"Handle PSI events incrementally in ResourceFolderRepository", (String)"If enabled, ResourceFolderRepository will handle PSI events synchronously, rather than rescanning the whole file.", (boolean)true);
    public static final Flag<Boolean> TWEAK_COLOR_SCHEME = Flag.create((FlagGroup)EDITOR, (String)"tweak.color.scheme", (String)"Change the default color scheme", (String)"If enabled, we modify the default color scheme slightly.", (boolean)true);
    public static final Flag<Boolean> SAMPLES_SUPPORT_ENABLED = Flag.create((FlagGroup)EDITOR, (String)"samples.support.enabled", (String)"Enable supports of samples (tag inside KDoc) that are used in quick documentation", (String)"Enable supports of samples (tag inside KDoc) that are used in quick documentation", (boolean)false);
    public static final Flag<Boolean> DAGGER_SUPPORT_ENABLED = Flag.create((FlagGroup)EDITOR, (String)"dagger.support.enabled", (String)"Enable editor support for Dagger", (String)"If enabled adds Dagger specific find usages, gutter icons and new parsing for Dagger errors", (boolean)true);
    public static final Flag<Boolean> CONTENT_ACCESS_SUPPORT_ENABLED = Flag.create((FlagGroup)EDITOR, (String)"contentaccess.support.enabled", (String)"Enable editor support for ContentAccess", (String)"If enabled adds ContentAccesss specific inspections and code completion", (boolean)true);
    private static final FlagGroup UAB = new FlagGroup(FLAGS, "uab", "Unified App Bundle");
    public static final Flag<Boolean> UAB_ENABLE_NEW_INSTANT_APP_RUN_CONFIGURATIONS = Flag.create((FlagGroup)UAB, (String)"enable.ia.run.configs", (String)"Enable new instant app run configuration options", (String)"If enabled, shows the new instant app deploy checkbox in the run configuration dialog and allows new instant app deploy workflow.", (boolean)true);
    private static final FlagGroup TESTING = new FlagGroup(FLAGS, "testing", "Testing support");
    public static final Flag<Boolean> PRINT_INSTRUMENTATION_STATUS = Flag.create((FlagGroup)TESTING, (String)"print.instrumentation.status", (String)"Print instrumentation status information when testing", (String)"If enabled, instrumentation output keys (from calling Instrumentation#sendStatus) that begin with 'android.studio.display.' will have their values printed after a test has finished running.", (boolean)true);
    public static final Flag<Boolean> MULTIDEVICE_INSTRUMENTATION_TESTS = Flag.create((FlagGroup)TESTING, (String)"multidevice.instrumentation.tests", (String)"Allow running instrumentation tests on multiple devices at a time.", (String)"If enabled, you can choose run-on-selected-devices for android instrumentation test run configurations.", (boolean)true);
    public static final Flag<Boolean> UTP_TEST_RESULT_SUPPORT = Flag.create((FlagGroup)TESTING, (String)"utp.instrumentation.tests", (String)"Allow importing UTP test results.", (String)"If enabled, you can import UTP test results and display them in test result panel.", (boolean)false);
    private static final FlagGroup MEMORY_SETTINGS = new FlagGroup(FLAGS, "memory.settings", "Memory Settings");
    public static final Flag<Boolean> LOW_IDE_XMX_CAP = Flag.create((FlagGroup)MEMORY_SETTINGS, (String)"low.ide.xmx.cap", (String)"Set low IDE Xmx cap in memory settings", (String)"If set, IDE Xmx is capped at 4GB in the configuration dialog. Otherwise, the cap is 8GB", (boolean)true);
    private static final FlagGroup SYSTEM_HEALTH = new FlagGroup(FLAGS, "system.health", "System Health");
    public static final Flag<Boolean> WINDOWS_UCRT_CHECK_ENABLED = Flag.create((FlagGroup)SYSTEM_HEALTH, (String)"windows.ucrt.check.enabled", (String)"Enable Universal C Runtime system health check", (String)"If enabled, a notification will be shown if the Universal C Runtime in Windows is not installed", (boolean)false);
    public static final Flag<Boolean> ANTIVIRUS_NOTIFICATION_ENABLED = Flag.create((FlagGroup)SYSTEM_HEALTH, (String)"antivirus.notification.enabled", (String)"Enable antivirus system health check", (String)"If enabled, a notification will be shown if antivirus realtime scanning is enabled and directories relevant to build performance aren't excluded", (boolean)true);
    public static final Flag<Boolean> ANTIVIRUS_METRICS_ENABLED = Flag.create((FlagGroup)SYSTEM_HEALTH, (String)"antivirus.metrics.enabled", (String)"Enable antivirus metrics collection", (String)"If enabled, metrics about the status of antivirus realtime scanning and excluded directories will be collected", (boolean)true);
    public static final Flag<Boolean> ANTIVIRUS_CHECK_USE_REGISTRY = Flag.create((FlagGroup)SYSTEM_HEALTH, (String)"antivirus.check.registry", (String)"Use registry instead of PowerShell for checking antivirus status", (String)"If enabled, the antivirus status checker will use the Windows registry instead of PowerShell commands", (boolean)true);
    private static final FlagGroup COMPOSE = new FlagGroup(FLAGS, "compose", "Compose");
    public static final Flag<Boolean> COMPOSE_PREVIEW = Flag.create((FlagGroup)COMPOSE, (String)"preview.enabled", (String)"Enable the Compose preview", (String)"If enabled, a visual preview will be available for Compose.", (boolean)false);
    public static final Flag<Boolean> COMPOSE_PREVIEW_ONLY_KOTLIN_BUILD = Flag.create((FlagGroup)COMPOSE, (String)"preview.fast.build.enabled", (String)"Enable the use of \"compileDebugKotlin\" for the preview refresh", (String)"If enabled, the refresh button will only trigger the \"compileDebugKotlin\" task as opposed to others like\"generateDebugSources\" or \"compileJava\".", (boolean)false);
    public static final Flag<Boolean> COMPOSE_PREVIEW_BUILD_ON_SAVE = Flag.create((FlagGroup)COMPOSE, (String)"preview.build.on.save.enabled", (String)"Enable the compose \"build on save\"", (String)"If enabled, the preview will automatically trigger a build after the user or IntelliJ save the documents.", (boolean)false);
    public static final Flag<Boolean> COMPOSE_PREVIEW_RUN_CONFIGURATION = Flag.create((FlagGroup)COMPOSE, (String)"preview.run.configuration", (String)"Enable running Compose Previews on device/emulator", (String)"If enabled, it will be possible to create run configurations that launch a Compose Preview directly to the device/emulator.", (boolean)false);
    public static final Flag<Boolean> COMPOSE_PREVIEW_DOUBLE_RENDER = Flag.create((FlagGroup)COMPOSE, (String)"preview.double.render", (String)"Enable the Compose double render mode", (String)"If enabled, preview components will be rendered twice so components depending on a recompose (like tableDecoration) render correctly.", (boolean)false);
    public static final Flag<Boolean> COMPOSE_PREVIEW_SCROLL_ON_CARET_MOVE = Flag.create((FlagGroup)COMPOSE, (String)"preview.scroll.on.caret.move", (String)"Enable the Compose Preview scrolling when the caret moves", (String)"If enabled, when moving the caret in the text editor, the Preview will show the preview currently under the cursor.", (boolean)false);
    public static final Flag<Boolean> COMPOSE_EDITOR_SUPPORT = Flag.create((FlagGroup)COMPOSE, (String)"editor", (String)"Compose-specific support in the code editor", (String)"Controls whether Compose-specific editor features, like completion tweaks, are enabled. This flag has priority over all flags in the `compose.editor.*` namespace.", (boolean)false);
    public static final Flag<Boolean> COMPOSE_COMPLETION_PRESENTATION = Flag.create((FlagGroup)COMPOSE, (String)"editor.completion.presentation", (String)"Custom presentation for code completion items for composable functions", (String)"If enabled, code completion items for composable functions use a custom presentation (icon, text).", (boolean)false);
    public static final Flag<Boolean> COMPOSE_COMPLETION_WEIGHER = Flag.create((FlagGroup)COMPOSE, (String)"editor.completion.weigher", (String)"Custom weigher for Compose", (String)"If enabled, code completion puts composable functions above other completion suggestions.", (boolean)false);
    public static final Flag<Boolean> COMPOSE_COMPLETION_INSERT_HANDLER = Flag.create((FlagGroup)COMPOSE, (String)"editor.completion.insert.handler", (String)"Custom insert handler for composable functions", (String)"If enabled, code completion for composable functions uses a custom InsertHandler that inserts required parameter names.", (boolean)false);
    public static final Flag<Boolean> COMPOSE_AUTO_DOCUMENTATION = Flag.create((FlagGroup)COMPOSE, (String)"editor.auto.documentation", (String)"Show quick documentation automatically for Compose", (String)"If enabled, during code completion popup with documentation shows automatically", (boolean)false);
    public static final Flag<Boolean> COMPOSE_RENDER_SAMPLE_IN_DOCUMENTATION = Flag.create((FlagGroup)COMPOSE, (String)"editor.render.sample", (String)"Render samples of compose elements inside documentation", (String)"If enabled, adds rendered image of sample for compose element if such exists", (boolean)false);
    public static final Flag<Boolean> COMPOSE_RENDER_SAMPLE_IN_DOCUMENTATION_SLOW = Flag.create((FlagGroup)COMPOSE, (String)"editor.render.sample.slow", (String)"Slow down rendering of samples of compose elements inside documentation", (String)"If enabled, slow down rendering of samples of compose elements inside documentation, this flag is used for demonstration of non-blocking behavior", (boolean)false);
    public static final Flag<Boolean> COMPOSE_FUNCTION_EXTRACTION = Flag.create((FlagGroup)COMPOSE, (String)"editor.function.extraction", (String)"Enables extracting @Composable function from other composables", (String)"If enabled, function extracted from @Composable function will annotated @Composable", (boolean)false);
    public static final Flag<Boolean> COMPOSE_WIZARD_TEMPLATES = Flag.create((FlagGroup)COMPOSE, (String)"wizard.templates", (String)"Show Compose Wizards", (String)"If enabled, allows adding new Compose Projects/Modules/Activities through the wizards", (boolean)false);
    public static final Flag<Boolean> COMPOSE_ANIMATED_PREVIEW = Flag.create((FlagGroup)COMPOSE, (String)"preview.animated.enable", (String)"Enable animated compose preview", (String)"If enabled, a user can switch compose preview to be animated", (boolean)false);
    public static final Flag<Boolean> COMPOSE_ANIMATED_PREVIEW_SHOW_CLICK = Flag.create((FlagGroup)COMPOSE, (String)"preview.animated.click.enable", (String)"Enable displaying clicks on the animated preview", (String)"If enabled, clicking on the animated preview will generate a ripple", (boolean)false);
    public static final Flag<Boolean> COMPOSE_ANIMATION_INSPECTOR = Flag.create((FlagGroup)COMPOSE, (String)"preview.animation.inspector", (String)"Enable compose preview animation inspection", (String)"If enabled, users can inspect animations in compose previews, e.g. play/pause and jump to specific frame", (boolean)false);
    public static final Flag<Boolean> COMPOSE_LIVE_LITERALS = Flag.create((FlagGroup)COMPOSE, (String)"preview.live.literals", (String)"Enable the live literals", (String)"If enabled, the live literals feature is enabled", (boolean)false);
    public static final Flag<Boolean> COMPOSE_DEBUG_BOUNDS = Flag.create((FlagGroup)COMPOSE, (String)"preview.debug.bounds", (String)"Enable the debug bounds switch controls", (String)"If enabled, the user can enable/disable the painting of debug bounds", (boolean)false);
    public static final Flag<Boolean> COMPOSE_PREVIEW_ELEMENT_PICKER = Flag.create((FlagGroup)COMPOSE, (String)"preview.element.picker.enable", (String)"Enable @Preview picker", (String)"If enabled, the picker for @Preview elements will be available", (boolean)false);
    public static final Flag<Boolean> COMPOSE_BLUEPRINT_MODE = Flag.create((FlagGroup)COMPOSE, (String)"preview.blueprint", (String)"Enable the blueprint mode for Compose previews", (String)"If enabled, the user can change the mode of Compose previews, between design and blueprint mode", (boolean)false);
    public static final Flag<Boolean> COMPOSE_QUICK_ANIMATED_PREVIEW = Flag.create((FlagGroup)COMPOSE, (String)"preview.animated.quick", (String)"Speed up transition between static and animated compose previews", (String)"If enabled, a transition between static and animated compose preview is almost instant", (boolean)false);
    public static final Flag<Boolean> COMPOSE_COLORBLIND_MODE = Flag.create((FlagGroup)COMPOSE, (String)"preview.colorblind", (String)"Enable the colorblind mode for Compose previews", (String)"If enabled, the user can change the mode of Compose previews, between different types of colorblind modes", (boolean)false);
    private static final FlagGroup MANIFESTS = new FlagGroup(FLAGS, "manifests", "Android Manifests");
    public static final Flag<Boolean> ANDROID_MANIFEST_INDEX_ENABLED = Flag.create((FlagGroup)MANIFESTS, (String)"index.enabled", (String)"Enable Android Manifest Indexing", (String)"Enables a custom index for pre-parsing your project's AndroidManifest.xml files", (boolean)true);
    private static final FlagGroup APP_INSPECTION = new FlagGroup(FLAGS, "appinspection", "App Inspection");
    public static final Flag<Boolean> ENABLE_APP_INSPECTION_TOOL_WINDOW = Flag.create((FlagGroup)APP_INSPECTION, (String)"enable.tool.window", (String)"Enable App Inspection Tool Window", (String)"Enables the top-level App Inspection tool window, which will contain tabs to various feature inspectors", (boolean)true);
    private static final FlagGroup WORK_MANAGER_INSPECTOR = new FlagGroup(FLAGS, "work.inspector", "WorkManager Inspector");
    public static final Flag<Boolean> ENABLE_WORK_MANAGER_INSPECTOR_TAB = Flag.create((FlagGroup)WORK_MANAGER_INSPECTOR, (String)"enable.tab", (String)"Enable WorkManager Inspector Tab", (String)"Enables a WorkManager Inspector Tab in the App Inspection tool window", (boolean)false);
    private static final FlagGroup DEVICE_MANAGER = new FlagGroup(FLAGS, "device.manager", "Device Manager");
    public static final Flag<Boolean> ENABLE_NEW_DEVICE_MANAGER_PANEL = Flag.create((FlagGroup)DEVICE_MANAGER, (String)"enable.device.manager", (String)"Enable new Device Manager panel", (String)"Enables the new Device Manager panel on the right. It will be a replacement for an AVD manager with additional functionality", (boolean)false);

    @NotNull
    private static Flags createFlags() {
        Application app = ApplicationManager.getApplication();
        Object userOverrides = app != null && !app.isUnitTestMode() ? StudioFlagSettings.getInstance() : new DefaultFlagOverrides();
        return new Flags((FlagOverrides)userOverrides, new ImmutableFlagOverrides[]{new PropertyOverrides()});
    }

    private static boolean isDevBuild() {
        if (ApplicationManager.getApplication() == null) {
            return true;
        }
        ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
        return applicationInfo == null || applicationInfo.getStrictVersion().equals("0.0.0.0");
    }

    private StudioFlags() {
    }

    public static enum DefaultActivityLocatorStrategy {
        BLOCK,
        INDEX,
        STALE;

    }

    public static enum OptimisticInstallSupportLevel {
        DISABLED,
        DEX,
        DEX_AND_NATIVE,
        DEX_AND_NATIVE_AND_RESOURCES;

    }
}

