/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.view;

import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.view.CoverageListNode;
import com.intellij.coverage.view.CoverageListRootNode;
import com.intellij.coverage.view.CoverageViewDescriptor;
import com.intellij.coverage.view.CoverageViewExtension;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CoverageViewTreeStructure
extends AbstractTreeStructure {
    private final Project myProject;
    final CoverageSuitesBundle myData;
    final CoverageViewManager.StateBean myStateBean;
    private final CoverageListRootNode myRootNode;
    private final CoverageViewExtension myCoverageViewExtension;

    public CoverageViewTreeStructure(Project project, CoverageSuitesBundle bundle, CoverageViewManager.StateBean stateBean) {
        this.myProject = project;
        this.myData = bundle;
        this.myStateBean = stateBean;
        this.myCoverageViewExtension = this.myData.getCoverageEngine().createCoverageViewExtension(project, bundle, stateBean);
        this.myRootNode = (CoverageListRootNode)this.myCoverageViewExtension.createRootNode();
    }

    @NotNull
    public Object getRootElement() {
        return this.myRootNode;
    }

    public Object @NotNull [] getChildElements(@NotNull Object element) {
        return CoverageViewTreeStructure.getChildren(element, this.myData, this.myStateBean);
    }

    static Object[] getChildren(Object element, CoverageSuitesBundle bundle, CoverageViewManager.StateBean stateBean) {
        if (element instanceof CoverageListRootNode && stateBean.myFlattenPackages) {
            Collection<? extends AbstractTreeNode<?>> children = ((CoverageListRootNode)((Object)element)).getChildren();
            return ArrayUtil.toObjectArray(children);
        }
        if (element instanceof CoverageListNode) {
            List<AbstractTreeNode<?>> children = bundle.getCoverageEngine().createCoverageViewExtension(((CoverageListNode)((Object)element)).getProject(), bundle, stateBean).getChildrenNodes((CoverageListNode)((Object)element));
            return children.toArray(new CoverageListNode[0]);
        }
        return null;
    }

    public Object getParentElement(@NotNull Object element) {
        PsiElement psiElement = (PsiElement)element;
        return this.myCoverageViewExtension.getParentElement(psiElement);
    }

    @NotNull
    public CoverageViewDescriptor createDescriptor(@NotNull Object element, NodeDescriptor parentDescriptor) {
        return new CoverageViewDescriptor(this.myProject, parentDescriptor, element);
    }

    public void commit() {
    }

    public boolean hasSomethingToCommit() {
        return false;
    }

    public boolean supportFlattenPackages() {
        return this.myCoverageViewExtension.supportFlattenPackages();
    }
}

