/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InconsistentDebugInfoException;
import com.sun.jdi.InternalException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.VMDisconnectedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.caches.resolve.KotlinCacheService;
import org.jetbrains.kotlin.idea.core.util.AttachmentUtilsKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluatorBuilderKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentCompiler;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentParameter;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CompiledDataDescriptor;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;
import org.jetbrains.kotlin.psi.KtCodeFragment;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=2, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u001a\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n\u001a\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0010H\u0002\u001a.\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u001a\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001b\u001a\u00020\u000e2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u0010H\u0002\"\u0019\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u001d"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "createCompiledDataDescriptor", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CompiledDataDescriptor;", "result", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentCompiler$CompilationResult;", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "evaluationException", "", "msg", "", "e", "", "getResolutionFacadeForCodeFragment", "Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "isSpecialException", "", "th", "reportError", "", "position", "message", "throwable", "kotlin.jvm-debugger.evaluation"})
public final class KotlinEvaluatorBuilderKt {
    @NotNull
    private static final Logger LOG;

    @NotNull
    public static final Logger getLOG() {
        return LOG;
    }

    private static final boolean isSpecialException(Throwable th) {
        Throwable throwable = th;
        return throwable instanceof ClassNotPreparedException || throwable instanceof InternalException || throwable instanceof AbsentInformationException || throwable instanceof ClassNotLoadedException || throwable instanceof IncompatibleThreadStateException || throwable instanceof InconsistentDebugInfoException || throwable instanceof ObjectCollectedException || throwable instanceof VMDisconnectedException;
    }

    private static final void reportError(KtCodeFragment codeFragment, SourcePosition position, String message, Throwable throwable) {
        ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<Unit>(codeFragment, position, message, throwable){
            final /* synthetic */ KtCodeFragment $codeFragment;
            final /* synthetic */ SourcePosition $position;
            final /* synthetic */ String $message;
            final /* synthetic */ Throwable $throwable;

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                String string;
                PsiElement psiElement = this.$codeFragment.getContext();
                PsiFile contextFile = psiElement != null ? psiElement.getContainingFile() : null;
                Attachment[] attachmentArray = new Attachment[4];
                attachmentArray[0] = AttachmentUtilsKt.attachmentByPsiFile((PsiFile)contextFile);
                attachmentArray[1] = AttachmentUtilsKt.attachmentByPsiFile((PsiFile)((PsiFile)this.$codeFragment));
                Attachment[] attachmentArray2 = attachmentArray;
                Attachment[] attachmentArray3 = attachmentArray;
                int n = 2;
                String string2 = "breakpoint.info";
                StringBuilder stringBuilder = new StringBuilder().append("Position: ");
                SourcePosition sourcePosition = this.$position;
                if (sourcePosition != null) {
                    void $this$run;
                    SourcePosition sourcePosition2 = sourcePosition;
                    boolean bl = false;
                    boolean bl2 = false;
                    SourcePosition sourcePosition3 = sourcePosition2;
                    StringBuilder stringBuilder2 = stringBuilder;
                    String string3 = string2;
                    int n2 = n;
                    Attachment[] attachmentArray4 = attachmentArray2;
                    Attachment[] attachmentArray5 = attachmentArray3;
                    boolean bl3 = false;
                    StringBuilder stringBuilder3 = new StringBuilder();
                    PsiFile psiFile = $this$run.getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"file");
                    String string4 = stringBuilder3.append(psiFile.getName()).append(':').append($this$run.getLine()).toString();
                    attachmentArray3 = attachmentArray5;
                    attachmentArray2 = attachmentArray4;
                    n = n2;
                    string2 = string3;
                    stringBuilder = stringBuilder2;
                    string = string4;
                } else {
                    string = null;
                }
                String string5 = stringBuilder.append(string).toString();
                String string6 = string2;
                attachmentArray2[n] = new Attachment(string6, string5);
                attachmentArray3[3] = new Attachment("context.info", (String)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<String>(this){
                    final /* synthetic */ reportError.1 this$0;

                    @NotNull
                    public final String invoke() {
                        Object object = this.this$0.$codeFragment.getContext();
                        if (object == null || (object = object.getText()) == null) {
                            object = "null";
                        }
                        return object;
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                })));
                Attachment[] attachments2 = attachmentArray3;
                KotlinEvaluatorBuilderKt.getLOG().error("Cannot evaluate a code fragment of type " + this.$codeFragment.getClass() + ": " + StringsKt.decapitalize((String)this.$message), this.$throwable, new Attachment[]{AttachmentUtilsKt.mergeAttachments((Attachment[])Arrays.copyOf(attachments2, attachments2.length))});
            }
            {
                this.$codeFragment = ktCodeFragment;
                this.$position = sourcePosition;
                this.$message = string;
                this.$throwable = throwable;
                super(0);
            }
        }));
    }

    static /* synthetic */ void reportError$default(KtCodeFragment ktCodeFragment, SourcePosition sourcePosition, String string, Throwable throwable, int n, Object object) {
        if ((n & 8) != 0) {
            throwable = null;
        }
        KotlinEvaluatorBuilderKt.reportError(ktCodeFragment, sourcePosition, string, throwable);
    }

    @NotNull
    public static final CompiledDataDescriptor createCompiledDataDescriptor(@NotNull CodeFragmentCompiler.CompilationResult result, @Nullable SourcePosition sourcePosition) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Map<CodeFragmentParameter.Dumb, String> localFunctionSuffixes = result.getLocalFunctionSuffixes();
        ArrayList dumbParameters = new ArrayList(result.getParameterInfo().getParameters().size());
        for (CodeFragmentParameter.Smart parameter : result.getParameterInfo().getParameters()) {
            String suffix;
            CodeFragmentParameter.Dumb dumb = parameter.getDumb();
            if (dumb.getKind() == CodeFragmentParameter.Kind.LOCAL_FUNCTION && (suffix = localFunctionSuffixes.get(dumb)) != null) {
                Collection collection = dumbParameters;
                CodeFragmentParameter.Dumb dumb2 = CodeFragmentParameter.Dumb.copy$default((CodeFragmentParameter.Dumb)dumb, null, (String)(dumb.getName() + suffix), null, (int)5, null);
                boolean bl = false;
                collection.add(dumb2);
                continue;
            }
            Collection collection = dumbParameters;
            boolean bl = false;
            collection.add(dumb);
        }
        return new CompiledDataDescriptor(result.getClasses(), (List)dumbParameters, result.getParameterInfo().getCrossingBounds(), result.getMainMethodSignature(), sourcePosition);
    }

    private static final Void evaluationException(String msg) {
        EvaluateException evaluateException = EvaluateExceptionUtil.createEvaluateException((String)msg);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)evaluateException), (String)"EvaluateExceptionUtil.createEvaluateException(msg)");
        throw (Throwable)evaluateException;
    }

    private static final Void evaluationException(Throwable e) {
        EvaluateException evaluateException = EvaluateExceptionUtil.createEvaluateException((Throwable)e);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)evaluateException), (String)"EvaluateExceptionUtil.createEvaluateException(e)");
        throw (Throwable)evaluateException;
    }

    @NotNull
    public static final ResolutionFacade getResolutionFacadeForCodeFragment(@NotNull KtCodeFragment codeFragment) {
        Intrinsics.checkNotNullParameter((Object)codeFragment, (String)"codeFragment");
        List filesToAnalyze = CollectionsKt.listOf((Object)codeFragment);
        Project project = codeFragment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"codeFragment.project");
        KotlinCacheService kotlinCacheService = KotlinCacheService.Companion.getInstance(project);
        return kotlinCacheService.getResolutionFacade(filesToAnalyze, JvmPlatforms.INSTANCE.getUnspecifiedJvmPlatform());
    }

    static {
        Logger logger = Logger.getInstance(KotlinEvaluator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(KotlinEvaluator::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ Void access$evaluationException(String msg) {
        return KotlinEvaluatorBuilderKt.evaluationException(msg);
    }

    public static final /* synthetic */ Void access$evaluationException(Throwable e) {
        return KotlinEvaluatorBuilderKt.evaluationException(e);
    }

    public static final /* synthetic */ boolean access$isSpecialException(Throwable th) {
        return KotlinEvaluatorBuilderKt.isSpecialException(th);
    }

    public static final /* synthetic */ void access$reportError(KtCodeFragment codeFragment, SourcePosition position, String message, Throwable throwable) {
        KotlinEvaluatorBuilderKt.reportError(codeFragment, position, message, throwable);
    }
}

