/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.webp;

import com.android.tools.adtui.webp.WebpImageReaderSpi;
import com.intellij.openapi.application.PluginPathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import java.io.IOException;

public class WebpNativeLibHelper {
    private static boolean sJniLibLoaded;
    private static boolean sJniLibLoadAttempted;

    private WebpNativeLibHelper() {
    }

    static void requireNativeLibrary() throws IOException {
        if (!WebpNativeLibHelper.loadNativeLibraryIfNeeded()) {
            throw new IOException("The WebP decoder library could not be loaded");
        }
    }

    public static String getDecoderVersion() {
        return "1280";
    }

    public static String getEncoderVersion() {
        return WebpNativeLibHelper.getDecoderVersion();
    }

    public static boolean loadNativeLibraryIfNeeded() {
        if (!sJniLibLoadAttempted) {
            try {
                WebpNativeLibHelper.loadNativeLibrary();
            }
            catch (UnsatisfiedLinkError e) {
                Logger.getInstance(WebpImageReaderSpi.class).warn((Throwable)e);
            }
        }
        return sJniLibLoaded;
    }

    private static synchronized void loadNativeLibrary() {
        if (sJniLibLoadAttempted) {
            return;
        }
        try {
            String libFileName = WebpNativeLibHelper.getLibName();
            File pluginPath = WebpNativeLibHelper.getLibLocation();
            File libPath = new File(pluginPath, libFileName);
            if (!libPath.exists()) {
                throw new UnsatisfiedLinkError(String.format("'%1$s' not found at '%2$s'", libFileName, libPath.getAbsolutePath()));
            }
            System.load(libPath.getAbsolutePath());
        }
        finally {
            sJniLibLoadAttempted = true;
        }
        sJniLibLoaded = true;
    }

    public static String getLibName() {
        String baseName = SystemInfo.is64Bit ? "webp_jni64" : "webp_jni";
        String fileName = System.mapLibraryName(baseName);
        if (SystemInfo.isMac) {
            fileName = fileName.replace(".jnilib", ".dylib");
        }
        return fileName;
    }

    public static File getLibLocation() {
        String libPath = "/lib/libwebp/" + WebpNativeLibHelper.getPlatformName();
        return new File(PluginPathManager.getPluginHomePath((String)"webp") + libPath);
    }

    private static String getPlatformName() {
        if (SystemInfo.isWindows) {
            return "win";
        }
        if (SystemInfo.isMac) {
            return "mac";
        }
        if (SystemInfo.isLinux) {
            return "linux";
        }
        return "";
    }
}

