/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac.ast.api;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.javac.ast.api.JavacRef;

public abstract class JavacDef {
    private final JavacRef myDefinedElement;

    public JavacDef(JavacRef element) {
        this.myDefinedElement = element;
    }

    @NotNull
    public JavacRef getDefinedElement() {
        return this.myDefinedElement;
    }

    public static class JavacMemberDef
    extends JavacDef {
        private final JavacRef myRawReturnType;
        private final byte myArrayDimension;
        private final boolean myStatic;

        public JavacMemberDef(JavacRef element, JavacRef rawReturnType, byte dimension, boolean isStatic) {
            super(element);
            this.myRawReturnType = rawReturnType;
            this.myArrayDimension = dimension;
            this.myStatic = isStatic;
        }

        public JavacRef getReturnType() {
            return this.myRawReturnType;
        }

        public byte getIteratorKind() {
            return this.myArrayDimension;
        }

        public boolean isStatic() {
            return this.myStatic;
        }
    }

    public static class JavacClassDef
    extends JavacDef {
        private final JavacRef[] myClasses;

        public JavacClassDef(JavacRef aClass, JavacRef[] superClasses) {
            super(aClass);
            this.myClasses = superClasses;
        }

        @NotNull
        public JavacRef[] getSuperClasses() {
            return this.myClasses;
        }
    }

    public static class JavacFunExprDef
    extends JavacDef {
        public JavacFunExprDef(JavacRef functionalInterface) {
            super(functionalInterface);
        }
    }
}

