/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac;

import java.io.CharArrayReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.nio.CharBuffer;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.CharArrayCharSequence;

public abstract class JpsFileObject
extends SimpleJavaFileObject {
    private static final JavaFileObject.Kind[] ourAvailableKinds = JavaFileObject.Kind.values();
    private final JavaFileManager.Location myLocation;

    public JpsFileObject(URI uri, JavaFileObject.Kind kind, @Nullable JavaFileManager.Location location) {
        super(uri, kind);
        this.myLocation = location;
    }

    @Nullable
    public JavaFileManager.Location getLocation() {
        return this.myLocation;
    }

    protected static JavaFileObject.Kind findKind(String name) {
        for (JavaFileObject.Kind kind : ourAvailableKinds) {
            if (kind == JavaFileObject.Kind.OTHER || !name.regionMatches(true, name.length() - kind.extension.length(), kind.extension, 0, kind.extension.length())) continue;
            return kind;
        }
        return JavaFileObject.Kind.OTHER;
    }

    @Nullable
    protected abstract String inferBinaryName(Iterable<? extends File> var1, boolean var2);

    @Override
    public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
        CharBuffer buffer;
        CharSequence content = this.getCharContent(ignoreEncodingErrors);
        if (content == null) {
            throw new UnsupportedOperationException();
        }
        if (content instanceof CharArrayCharSequence) {
            CharArrayCharSequence _content = (CharArrayCharSequence)content;
            return new CharArrayReader(_content.getBackendArray(), _content.getStart(), _content.length());
        }
        if (content instanceof CharBuffer && (buffer = (CharBuffer)content).hasArray()) {
            return new CharArrayReader(buffer.array(), buffer.arrayOffset(), buffer.length());
        }
        return new StringReader(content.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected static CharSequence loadCharContent(@NotNull File file, @Nullable String encoding) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        try {
            CharArrayCharSequence charArrayCharSequence;
            InputStreamReader reader = encoding == null ? new InputStreamReader(stream) : new InputStreamReader((InputStream)stream, encoding);
            try {
                int count;
                int n;
                char[] chars = new char[(int)stream.getChannel().size()];
                for (count = 0; count < chars.length && (n = ((Reader)reader).read(chars, count, chars.length - count)) > 0; count += n) {
                }
                charArrayCharSequence = new CharArrayCharSequence(chars, 0, count);
            }
            catch (Throwable throwable) {
                ((Reader)reader).close();
                throw throwable;
            }
            ((Reader)reader).close();
            return charArrayCharSequence;
        }
        finally {
            stream.close();
        }
    }

    public int hashCode() {
        return this.toUri().hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof JpsFileObject && this.toUri().equals(((JpsFileObject)obj).toUri());
    }
}

