/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac;

import com.intellij.util.BooleanFunction;
import com.intellij.util.Function;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public class Iterators {
    public static <T> Iterable<T> flat(final Iterable<? extends T> first, final Iterable<? extends T> second) {
        return new Iterable<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                return Iterators.flat(first.iterator(), second.iterator());
            }
        };
    }

    static <T> Iterator<T> flat(final Iterator<? extends T> first, final Iterator<? extends T> second) {
        return new BaseIterator<T>(){

            @Override
            public boolean hasNext() {
                return first.hasNext() || second.hasNext();
            }

            @Override
            public T next() {
                return first.hasNext() ? first.next() : second.next();
            }
        };
    }

    public static <T> Iterable<T> flat(Collection<? extends Iterable<T>> parts) {
        if (parts.isEmpty()) {
            return Collections.emptyList();
        }
        if (parts.size() == 1) {
            return parts.iterator().next();
        }
        return Iterators.flat(parts);
    }

    public static <T> Iterable<T> flat(final Iterable<? extends Iterable<? extends T>> parts) {
        return new Iterable<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                return Iterators.flat(Iterators.map(parts.iterator(), new Function<Iterable<? extends T>, Iterator<T>>(){

                    public Iterator<T> fun(Iterable<? extends T> itr) {
                        return Iterators.asIterator(itr);
                    }
                }));
            }
        };
    }

    public static <T> Iterator<T> flat(final Iterator<? extends Iterator<T>> groupsIterator) {
        return new BaseIterator<T>(){
            private Iterator<T> currentGroup;

            @Override
            public boolean hasNext() {
                return this.findNextUnprocessed() != null;
            }

            @Override
            public T next() {
                Iterator group = this.findNextUnprocessed();
                if (group != null) {
                    return group.next();
                }
                throw new NoSuchElementException();
            }

            private Iterator<T> findNextUnprocessed() {
                if (this.currentGroup == null || !this.currentGroup.hasNext()) {
                    do {
                        Iterator iterator = this.currentGroup = groupsIterator.hasNext() ? (Iterator)groupsIterator.next() : null;
                    } while (this.currentGroup != null && !this.currentGroup.hasNext());
                }
                return this.currentGroup;
            }
        };
    }

    public static <I> Iterator<I> asIterator(Iterable<? extends I> from) {
        return Iterators.map(from.iterator(), new Function<I, I>(){

            public I fun(I i) {
                return i;
            }
        });
    }

    public static <I, O> Iterable<O> map(final Iterable<? extends I> from, final Function<? super I, ? extends O> mapper) {
        return new Iterable<O>(){

            @Override
            @NotNull
            public Iterator<O> iterator() {
                return Iterators.map(from.iterator(), mapper);
            }
        };
    }

    public static <I, O> Iterator<O> map(final Iterator<? extends I> it, final Function<? super I, ? extends O> mapper) {
        return new BaseIterator<O>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public O next() {
                return mapper.fun(it.next());
            }
        };
    }

    public static <T> Iterable<T> filter(final Iterable<? extends T> it, final BooleanFunction<? super T> predicate) {
        return new Iterable<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                return Iterators.filter(it.iterator(), predicate);
            }
        };
    }

    public static <T> Iterator<T> filter(final Iterator<? extends T> it, final BooleanFunction<? super T> predicate) {
        return new BaseIterator<T>(){
            private T current = null;
            private boolean isPending = false;

            @Override
            public boolean hasNext() {
                if (!this.isPending) {
                    this.findNext();
                }
                return this.isPending;
            }

            @Override
            public T next() {
                try {
                    if (!this.isPending) {
                        this.findNext();
                        if (!this.isPending) {
                            throw new NoSuchElementException();
                        }
                    }
                    Object t = this.current;
                    return t;
                }
                finally {
                    this.current = null;
                    this.isPending = false;
                }
            }

            private void findNext() {
                this.isPending = false;
                this.current = null;
                while (it.hasNext()) {
                    Object next = it.next();
                    if (!predicate.fun(next)) continue;
                    this.isPending = true;
                    this.current = next;
                    break;
                }
            }
        };
    }

    private static abstract class BaseIterator<T>
    implements Iterator<T> {
        private BaseIterator() {
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

