/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.nj2k;

import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.elements.KtLightDeclaration;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.nj2k.JKSymbolProviderKt;
import org.jetbrains.kotlin.nj2k.conversions.JKResolver;
import org.jetbrains.kotlin.nj2k.symbols.JKClassSymbol;
import org.jetbrains.kotlin.nj2k.symbols.JKFieldSymbol;
import org.jetbrains.kotlin.nj2k.symbols.JKMethodSymbol;
import org.jetbrains.kotlin.nj2k.symbols.JKMultiverseClassSymbol;
import org.jetbrains.kotlin.nj2k.symbols.JKMultiverseFieldSymbol;
import org.jetbrains.kotlin.nj2k.symbols.JKMultiverseFunctionSymbol;
import org.jetbrains.kotlin.nj2k.symbols.JKMultiverseKtClassSymbol;
import org.jetbrains.kotlin.nj2k.symbols.JKMultiverseKtEnumEntrySymbol;
import org.jetbrains.kotlin.nj2k.symbols.JKMultiverseKtTypeParameterSymbol;
import org.jetbrains.kotlin.nj2k.symbols.JKMultiverseMethodSymbol;
import org.jetbrains.kotlin.nj2k.symbols.JKMultiversePackageSymbol;
import org.jetbrains.kotlin.nj2k.symbols.JKMultiversePropertySymbol;
import org.jetbrains.kotlin.nj2k.symbols.JKMultiverseTypeParameterSymbol;
import org.jetbrains.kotlin.nj2k.symbols.JKPackageSymbol;
import org.jetbrains.kotlin.nj2k.symbols.JKSymbol;
import org.jetbrains.kotlin.nj2k.symbols.JKTypeAliasKtClassSymbol;
import org.jetbrains.kotlin.nj2k.symbols.JKTypeParameterSymbol;
import org.jetbrains.kotlin.nj2k.symbols.JKUniverseClassSymbol;
import org.jetbrains.kotlin.nj2k.symbols.JKUniverseFieldSymbol;
import org.jetbrains.kotlin.nj2k.symbols.JKUniverseMethodSymbol;
import org.jetbrains.kotlin.nj2k.symbols.JKUniversePackageSymbol;
import org.jetbrains.kotlin.nj2k.symbols.JKUniverseSymbol;
import org.jetbrains.kotlin.nj2k.symbols.JKUniverseTypeParameterSymbol;
import org.jetbrains.kotlin.nj2k.symbols.JKUnresolvedClassSymbol;
import org.jetbrains.kotlin.nj2k.symbols.JKUnresolvedField;
import org.jetbrains.kotlin.nj2k.symbols.JKUnresolvedMethod;
import org.jetbrains.kotlin.nj2k.symbols.JKUnresolvedSymbol;
import org.jetbrains.kotlin.nj2k.tree.JKClass;
import org.jetbrains.kotlin.nj2k.tree.JKDeclaration;
import org.jetbrains.kotlin.nj2k.tree.JKMethod;
import org.jetbrains.kotlin.nj2k.tree.JKPackageDeclaration;
import org.jetbrains.kotlin.nj2k.tree.JKTypeParameter;
import org.jetbrains.kotlin.nj2k.tree.JKVariable;
import org.jetbrains.kotlin.nj2k.types.JKTypeFactory;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeParameter;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001@B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0017\u001a\u00020\u0018\"\u0006\b\u0000\u0010\u0019\u0018\u0001\"\u0006\b\u0001\u0010\u001a\u0018\u0001H\u0080\b\u00a2\u0006\u0002\b\u001bJ\u0014\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001fJ\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\tJ\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020$J\u000e\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020\u000eJ\u000e\u0010'\u001a\u00020(2\u0006\u0010\"\u001a\u00020\tJ\u000e\u0010'\u001a\u00020(2\u0006\u0010\"\u001a\u00020#J\u000e\u0010)\u001a\u00020*2\u0006\u0010\"\u001a\u00020\tJ\u000e\u0010)\u001a\u00020*2\u0006\u0010\"\u001a\u00020#J$\u0010+\u001a\u0002H,\"\n\b\u0000\u0010,\u0018\u0001*\u00020\n2\u0006\u0010-\u001a\u00020.H\u0080\b\u00a2\u0006\u0004\b/\u00100J\u000e\u00101\u001a\u00020\n2\u0006\u0010&\u001a\u00020\u000eJ\u0016\u00101\u001a\u00020\n2\u0006\u0010&\u001a\u00020\u000e2\u0006\u00102\u001a\u00020\fJ\u000e\u00101\u001a\u00020!2\u0006\u00103\u001a\u000204J\u0014\u00101\u001a\b\u0012\u0002\b\u0003\u0018\u0001052\u0006\u00103\u001a\u00020\fJ\u000e\u00101\u001a\u00020*2\u0006\u00103\u001a\u000206J\u000e\u00101\u001a\u0002072\u0006\u00103\u001a\u000208J\u000e\u00101\u001a\u0002092\u0006\u00103\u001a\u00020:J\u000e\u00101\u001a\u00020(2\u0006\u00103\u001a\u00020;J\u0010\u0010<\u001a\u00020\n2\u0006\u0010&\u001a\u00020\u000eH\u0002J\u0018\u0010=\u001a\u0004\u0018\u00010\n2\u0006\u0010>\u001a\u00020\f2\u0006\u0010?\u001a\u00020\fR\u0012\u0010\u0005\u001a\u00060\u0006R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006A"}, d2={"Lorg/jetbrains/kotlin/nj2k/JKSymbolProvider;", "", "resolver", "Lorg/jetbrains/kotlin/nj2k/conversions/JKResolver;", "(Lorg/jetbrains/kotlin/nj2k/conversions/JKResolver;)V", "elementVisitor", "Lorg/jetbrains/kotlin/nj2k/JKSymbolProvider$ElementVisitor;", "symbolsByFqName", "", "", "Lorg/jetbrains/kotlin/nj2k/symbols/JKSymbol;", "symbolsByJK", "Lorg/jetbrains/kotlin/nj2k/tree/JKDeclaration;", "symbolsByPsi", "Lcom/intellij/psi/PsiElement;", "getSymbolsByPsi", "()Ljava/util/Map;", "typeFactory", "Lorg/jetbrains/kotlin/nj2k/types/JKTypeFactory;", "getTypeFactory", "()Lorg/jetbrains/kotlin/nj2k/types/JKTypeFactory;", "setTypeFactory", "(Lorg/jetbrains/kotlin/nj2k/types/JKTypeFactory;)V", "isAssignable", "", "A", "B", "isAssignable$kotlin_j2k_new", "preBuildTree", "", "inputElements", "", "provideClassSymbol", "Lorg/jetbrains/kotlin/nj2k/symbols/JKClassSymbol;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "provideDirectSymbol", "psi", "provideFieldSymbol", "Lorg/jetbrains/kotlin/nj2k/symbols/JKFieldSymbol;", "provideMethodSymbol", "Lorg/jetbrains/kotlin/nj2k/symbols/JKMethodSymbol;", "provideSymbolForReference", "T", "reference", "Lcom/intellij/psi/PsiReference;", "provideSymbolForReference$kotlin_j2k_new", "(Lcom/intellij/psi/PsiReference;)Lorg/jetbrains/kotlin/nj2k/symbols/JKSymbol;", "provideUniverseSymbol", "declaration", "jk", "Lorg/jetbrains/kotlin/nj2k/tree/JKClass;", "Lorg/jetbrains/kotlin/nj2k/symbols/JKUniverseSymbol;", "Lorg/jetbrains/kotlin/nj2k/tree/JKMethod;", "Lorg/jetbrains/kotlin/nj2k/symbols/JKPackageSymbol;", "Lorg/jetbrains/kotlin/nj2k/tree/JKPackageDeclaration;", "Lorg/jetbrains/kotlin/nj2k/symbols/JKTypeParameterSymbol;", "Lorg/jetbrains/kotlin/nj2k/tree/JKTypeParameter;", "Lorg/jetbrains/kotlin/nj2k/tree/JKVariable;", "symbolForNonKotlinElement", "transferSymbol", "to", "from", "ElementVisitor", "kotlin.j2k.new"})
public final class JKSymbolProvider {
    private final Map<String, JKSymbol> symbolsByFqName;
    @NotNull
    private final Map<PsiElement, JKSymbol> symbolsByPsi;
    private final Map<JKDeclaration, JKSymbol> symbolsByJK;
    private final ElementVisitor elementVisitor;
    public JKTypeFactory typeFactory;
    private final JKResolver resolver;

    @NotNull
    public final Map<PsiElement, JKSymbol> getSymbolsByPsi() {
        return this.symbolsByPsi;
    }

    @NotNull
    public final JKTypeFactory getTypeFactory() {
        JKTypeFactory jKTypeFactory = this.typeFactory;
        if (jKTypeFactory == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"typeFactory");
        }
        return jKTypeFactory;
    }

    public final void setTypeFactory(@NotNull JKTypeFactory jKTypeFactory) {
        Intrinsics.checkNotNullParameter((Object)jKTypeFactory, (String)"<set-?>");
        this.typeFactory = jKTypeFactory;
    }

    public final void preBuildTree(@NotNull List<? extends PsiElement> inputElements) {
        Intrinsics.checkNotNullParameter(inputElements, (String)"inputElements");
        Iterable $this$forEach$iv = inputElements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiElement it = (PsiElement)element$iv;
            boolean bl = false;
            it.accept((PsiElementVisitor)this.elementVisitor);
        }
    }

    private final JKSymbol symbolForNonKotlinElement(PsiElement psi) {
        JKSymbol jKSymbol;
        PsiElement psiElement = psi;
        if (psiElement instanceof PsiTypeParameter) {
            PsiTypeParameter psiTypeParameter = (PsiTypeParameter)psi;
            JKTypeFactory jKTypeFactory = this.typeFactory;
            if (jKTypeFactory == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"typeFactory");
            }
            jKSymbol = new JKMultiverseTypeParameterSymbol(psiTypeParameter, jKTypeFactory);
        } else if (psiElement instanceof KtTypeParameter) {
            KtTypeParameter ktTypeParameter = (KtTypeParameter)psi;
            JKTypeFactory jKTypeFactory = this.typeFactory;
            if (jKTypeFactory == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"typeFactory");
            }
            jKSymbol = new JKMultiverseKtTypeParameterSymbol(ktTypeParameter, jKTypeFactory);
        } else if (psiElement instanceof KtEnumEntry) {
            KtEnumEntry ktEnumEntry = (KtEnumEntry)psi;
            JKTypeFactory jKTypeFactory = this.typeFactory;
            if (jKTypeFactory == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"typeFactory");
            }
            jKSymbol = new JKMultiverseKtEnumEntrySymbol(ktEnumEntry, jKTypeFactory);
        } else if (psiElement instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)psi;
            JKTypeFactory jKTypeFactory = this.typeFactory;
            if (jKTypeFactory == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"typeFactory");
            }
            jKSymbol = new JKMultiverseClassSymbol(psiClass, jKTypeFactory);
        } else if (psiElement instanceof KtClassOrObject) {
            KtClassOrObject ktClassOrObject = (KtClassOrObject)psi;
            JKTypeFactory jKTypeFactory = this.typeFactory;
            if (jKTypeFactory == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"typeFactory");
            }
            jKSymbol = new JKMultiverseKtClassSymbol(ktClassOrObject, jKTypeFactory);
        } else if (psiElement instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)psi;
            JKTypeFactory jKTypeFactory = this.typeFactory;
            if (jKTypeFactory == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"typeFactory");
            }
            jKSymbol = new JKMultiverseMethodSymbol(psiMethod, jKTypeFactory);
        } else if (psiElement instanceof PsiField) {
            PsiVariable psiVariable = (PsiVariable)psi;
            JKTypeFactory jKTypeFactory = this.typeFactory;
            if (jKTypeFactory == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"typeFactory");
            }
            jKSymbol = new JKMultiverseFieldSymbol(psiVariable, jKTypeFactory);
        } else if (psiElement instanceof KtFunction) {
            KtFunction ktFunction = (KtFunction)psi;
            JKTypeFactory jKTypeFactory = this.typeFactory;
            if (jKTypeFactory == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"typeFactory");
            }
            jKSymbol = new JKMultiverseFunctionSymbol(ktFunction, jKTypeFactory);
        } else if (psiElement instanceof KtProperty) {
            KtCallableDeclaration ktCallableDeclaration = (KtCallableDeclaration)psi;
            JKTypeFactory jKTypeFactory = this.typeFactory;
            if (jKTypeFactory == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"typeFactory");
            }
            jKSymbol = new JKMultiversePropertySymbol(ktCallableDeclaration, jKTypeFactory);
        } else if (psiElement instanceof KtParameter) {
            KtCallableDeclaration ktCallableDeclaration = (KtCallableDeclaration)psi;
            JKTypeFactory jKTypeFactory = this.typeFactory;
            if (jKTypeFactory == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"typeFactory");
            }
            jKSymbol = new JKMultiversePropertySymbol(ktCallableDeclaration, jKTypeFactory);
        } else if (psiElement instanceof PsiParameter) {
            PsiVariable psiVariable = (PsiVariable)psi;
            JKTypeFactory jKTypeFactory = this.typeFactory;
            if (jKTypeFactory == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"typeFactory");
            }
            jKSymbol = new JKMultiverseFieldSymbol(psiVariable, jKTypeFactory);
        } else if (psiElement instanceof PsiLocalVariable) {
            PsiVariable psiVariable = (PsiVariable)psi;
            JKTypeFactory jKTypeFactory = this.typeFactory;
            if (jKTypeFactory == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"typeFactory");
            }
            jKSymbol = new JKMultiverseFieldSymbol(psiVariable, jKTypeFactory);
        } else if (psiElement instanceof PsiPackage) {
            PsiPackage psiPackage = (PsiPackage)psi;
            JKTypeFactory jKTypeFactory = this.typeFactory;
            if (jKTypeFactory == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"typeFactory");
            }
            jKSymbol = new JKMultiversePackageSymbol(psiPackage, jKTypeFactory);
        } else if (psiElement instanceof KtTypeAlias) {
            KtTypeAlias ktTypeAlias = (KtTypeAlias)psi;
            JKTypeFactory jKTypeFactory = this.typeFactory;
            if (jKTypeFactory == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"typeFactory");
            }
            jKSymbol = new JKTypeAliasKtClassSymbol(ktTypeAlias, jKTypeFactory);
        } else {
            String string = Reflection.getOrCreateKotlinClass(psi.getClass()).toString();
            boolean bl = false;
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
        }
        return jKSymbol;
    }

    @NotNull
    public final JKSymbol provideDirectSymbol(@NotNull PsiElement psi) {
        JKSymbol jKSymbol;
        block6: {
            JKSymbol value$iv;
            block2: {
                JKSymbol jKSymbol2;
                Map<PsiElement, JKSymbol> $this$getOrPut$iv;
                block5: {
                    block3: {
                        block4: {
                            Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
                            $this$getOrPut$iv = this.symbolsByPsi;
                            boolean $i$f$getOrPut = false;
                            value$iv = $this$getOrPut$iv.get(psi);
                            if (value$iv != null) break block2;
                            boolean bl = false;
                            if (!(psi instanceof KtLightDeclaration)) break block3;
                            jKSymbol2 = (KtDeclaration)((KtLightDeclaration)psi).getKotlinOrigin();
                            if (jKSymbol2 == null) break block4;
                            JKSymbol jKSymbol3 = jKSymbol2;
                            boolean bl2 = false;
                            boolean bl3 = false;
                            JKSymbol it = jKSymbol3;
                            boolean bl4 = false;
                            jKSymbol2 = this.provideDirectSymbol((PsiElement)it);
                            if (jKSymbol2 != null) break block5;
                        }
                        jKSymbol2 = this.symbolForNonKotlinElement(psi);
                        break block5;
                    }
                    jKSymbol2 = this.symbolForNonKotlinElement(psi);
                }
                JKSymbol answer$iv = jKSymbol2;
                $this$getOrPut$iv.put(psi, answer$iv);
                jKSymbol = answer$iv;
                break block6;
            }
            jKSymbol = value$iv;
        }
        return jKSymbol;
    }

    public final /* synthetic */ <T extends JKSymbol> T provideSymbolForReference$kotlin_j2k_new(PsiReference reference) {
        JKUnresolvedSymbol jKUnresolvedSymbol;
        int $i$f$provideSymbolForReference$kotlin_j2k_new = 0;
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        PsiElement target = reference.resolve();
        if (target != null) {
            JKSymbol jKSymbol = this.provideDirectSymbol(target);
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            return (T)jKSymbol;
        }
        JKSymbolProvider this_$iv = this;
        boolean $i$f$isAssignable$kotlin_j2k_new = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        if (Object.class.isAssignableFrom(JKUnresolvedField.class)) {
            String string = reference.getCanonicalText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"reference.canonicalText");
            jKUnresolvedSymbol = new JKUnresolvedField(string, this.getTypeFactory());
        } else {
            jKUnresolvedSymbol = new JKUnresolvedMethod(reference, this.getTypeFactory());
        }
        Intrinsics.reifiedOperationMarker((int)1, (String)"T");
        return (T)jKUnresolvedSymbol;
    }

    @NotNull
    public final JKSymbol provideUniverseSymbol(@NotNull PsiElement psi, @NotNull JKDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        JKSymbol jKSymbol = this.provideUniverseSymbol(psi);
        boolean bl = false;
        boolean bl2 = false;
        JKSymbol symbol = jKSymbol;
        boolean bl3 = false;
        JKSymbol jKSymbol2 = symbol;
        if (jKSymbol2 instanceof JKUniverseClassSymbol) {
            ((JKUniverseClassSymbol)symbol).setTarget((JKClass)declaration);
        } else if (jKSymbol2 instanceof JKUniverseFieldSymbol) {
            ((JKUniverseFieldSymbol)symbol).setTarget((JKVariable)declaration);
        } else if (jKSymbol2 instanceof JKUniverseMethodSymbol) {
            ((JKUniverseMethodSymbol)symbol).setTarget((JKMethod)declaration);
        } else if (jKSymbol2 instanceof JKUniverseTypeParameterSymbol) {
            ((JKUniverseTypeParameterSymbol)symbol).setTarget((JKTypeParameter)declaration);
        } else if (jKSymbol2 instanceof JKUniversePackageSymbol) {
            ((JKUniversePackageSymbol)symbol).setTarget((JKPackageDeclaration)declaration);
        }
        this.symbolsByJK.put(declaration, symbol);
        return jKSymbol;
    }

    @NotNull
    public final JKSymbol provideUniverseSymbol(@NotNull PsiElement psi) {
        JKSymbol jKSymbol;
        Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
        Map<PsiElement, JKSymbol> $this$getOrPut$iv = this.symbolsByPsi;
        boolean $i$f$getOrPut = false;
        JKSymbol value$iv = $this$getOrPut$iv.get(psi);
        if (value$iv == null) {
            JKUniverseSymbol jKUniverseSymbol;
            boolean bl = false;
            PsiElement psiElement = psi;
            if (psiElement instanceof PsiVariable) {
                JKTypeFactory jKTypeFactory = this.typeFactory;
                if (jKTypeFactory == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"typeFactory");
                }
                jKUniverseSymbol = new JKUniverseFieldSymbol(jKTypeFactory);
            } else if (psiElement instanceof PsiMethod) {
                JKTypeFactory jKTypeFactory = this.typeFactory;
                if (jKTypeFactory == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"typeFactory");
                }
                jKUniverseSymbol = new JKUniverseMethodSymbol(jKTypeFactory);
            } else if (psiElement instanceof PsiTypeParameter) {
                JKTypeFactory jKTypeFactory = this.typeFactory;
                if (jKTypeFactory == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"typeFactory");
                }
                jKUniverseSymbol = new JKUniverseTypeParameterSymbol(jKTypeFactory);
            } else if (psiElement instanceof PsiClass) {
                JKTypeFactory jKTypeFactory = this.typeFactory;
                if (jKTypeFactory == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"typeFactory");
                }
                jKUniverseSymbol = new JKUniverseClassSymbol(jKTypeFactory);
            } else if (psiElement instanceof PsiPackageStatement) {
                JKTypeFactory jKTypeFactory = this.typeFactory;
                if (jKTypeFactory == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"typeFactory");
                }
                jKUniverseSymbol = new JKUniversePackageSymbol(jKTypeFactory);
            } else {
                boolean bl2 = false;
                throw (Throwable)new NotImplementedError(null, 1, null);
            }
            JKSymbol answer$iv = jKUniverseSymbol;
            $this$getOrPut$iv.put(psi, answer$iv);
            jKSymbol = answer$iv;
        } else {
            jKSymbol = value$iv;
        }
        return jKSymbol;
    }

    @Nullable
    public final JKSymbol transferSymbol(@NotNull JKDeclaration to, @NotNull JKDeclaration from) {
        JKSymbol jKSymbol;
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        JKSymbol jKSymbol2 = this.symbolsByJK.get(from);
        if (jKSymbol2 != null) {
            JKSymbol jKSymbol3 = jKSymbol2;
            boolean bl = false;
            boolean bl2 = false;
            JKSymbol it = jKSymbol3;
            boolean bl3 = false;
            JKSymbol jKSymbol4 = it;
            if (jKSymbol4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.nj2k.symbols.JKUniverseSymbol<org.jetbrains.kotlin.nj2k.tree.JKDeclaration>");
            }
            JKUniverseSymbol cfr_ignored_0 = (JKUniverseSymbol)jKSymbol4;
            ((JKUniverseSymbol)it).setTarget(to);
            this.symbolsByJK.put(to, it);
            jKSymbol = jKSymbol3;
        } else {
            jKSymbol = null;
        }
        return jKSymbol;
    }

    @NotNull
    public final JKClassSymbol provideUniverseSymbol(@NotNull JKClass jk) {
        JKSymbol jKSymbol;
        Intrinsics.checkNotNullParameter((Object)jk, (String)"jk");
        Map<JKDeclaration, JKSymbol> $this$getOrPut$iv = this.symbolsByJK;
        boolean $i$f$getOrPut = false;
        JKSymbol value$iv = $this$getOrPut$iv.get(jk);
        if (value$iv == null) {
            boolean bl = false;
            JKTypeFactory jKTypeFactory = this.typeFactory;
            if (jKTypeFactory == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"typeFactory");
            }
            JKUniverseClassSymbol jKUniverseClassSymbol = new JKUniverseClassSymbol(jKTypeFactory);
            boolean bl2 = false;
            boolean bl3 = false;
            JKUniverseClassSymbol it = jKUniverseClassSymbol;
            boolean bl4 = false;
            it.setTarget(jk);
            JKSymbol answer$iv = jKUniverseClassSymbol;
            $this$getOrPut$iv.put(jk, answer$iv);
            jKSymbol = answer$iv;
        } else {
            jKSymbol = value$iv;
        }
        return (JKClassSymbol)jKSymbol;
    }

    @NotNull
    public final JKFieldSymbol provideUniverseSymbol(@NotNull JKVariable jk) {
        JKSymbol jKSymbol;
        Intrinsics.checkNotNullParameter((Object)jk, (String)"jk");
        Map<JKDeclaration, JKSymbol> $this$getOrPut$iv = this.symbolsByJK;
        boolean $i$f$getOrPut = false;
        JKSymbol value$iv = $this$getOrPut$iv.get(jk);
        if (value$iv == null) {
            boolean bl = false;
            JKTypeFactory jKTypeFactory = this.typeFactory;
            if (jKTypeFactory == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"typeFactory");
            }
            JKUniverseFieldSymbol jKUniverseFieldSymbol = new JKUniverseFieldSymbol(jKTypeFactory);
            boolean bl2 = false;
            boolean bl3 = false;
            JKUniverseFieldSymbol it = jKUniverseFieldSymbol;
            boolean bl4 = false;
            it.setTarget(jk);
            JKSymbol answer$iv = jKUniverseFieldSymbol;
            $this$getOrPut$iv.put(jk, answer$iv);
            jKSymbol = answer$iv;
        } else {
            jKSymbol = value$iv;
        }
        return (JKFieldSymbol)jKSymbol;
    }

    @NotNull
    public final JKMethodSymbol provideUniverseSymbol(@NotNull JKMethod jk) {
        JKSymbol jKSymbol;
        Intrinsics.checkNotNullParameter((Object)jk, (String)"jk");
        Map<JKDeclaration, JKSymbol> $this$getOrPut$iv = this.symbolsByJK;
        boolean $i$f$getOrPut = false;
        JKSymbol value$iv = $this$getOrPut$iv.get(jk);
        if (value$iv == null) {
            boolean bl = false;
            JKTypeFactory jKTypeFactory = this.typeFactory;
            if (jKTypeFactory == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"typeFactory");
            }
            JKUniverseMethodSymbol jKUniverseMethodSymbol = new JKUniverseMethodSymbol(jKTypeFactory);
            boolean bl2 = false;
            boolean bl3 = false;
            JKUniverseMethodSymbol it = jKUniverseMethodSymbol;
            boolean bl4 = false;
            it.setTarget(jk);
            JKSymbol answer$iv = jKUniverseMethodSymbol;
            $this$getOrPut$iv.put(jk, answer$iv);
            jKSymbol = answer$iv;
        } else {
            jKSymbol = value$iv;
        }
        return (JKMethodSymbol)jKSymbol;
    }

    @NotNull
    public final JKTypeParameterSymbol provideUniverseSymbol(@NotNull JKTypeParameter jk) {
        JKSymbol jKSymbol;
        Intrinsics.checkNotNullParameter((Object)jk, (String)"jk");
        Map<JKDeclaration, JKSymbol> $this$getOrPut$iv = this.symbolsByJK;
        boolean $i$f$getOrPut = false;
        JKSymbol value$iv = $this$getOrPut$iv.get(jk);
        if (value$iv == null) {
            boolean bl = false;
            JKTypeFactory jKTypeFactory = this.typeFactory;
            if (jKTypeFactory == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"typeFactory");
            }
            JKUniverseTypeParameterSymbol jKUniverseTypeParameterSymbol = new JKUniverseTypeParameterSymbol(jKTypeFactory);
            boolean bl2 = false;
            boolean bl3 = false;
            JKUniverseTypeParameterSymbol it = jKUniverseTypeParameterSymbol;
            boolean bl4 = false;
            it.setTarget(jk);
            JKSymbol answer$iv = jKUniverseTypeParameterSymbol;
            $this$getOrPut$iv.put(jk, answer$iv);
            jKSymbol = answer$iv;
        } else {
            jKSymbol = value$iv;
        }
        return (JKTypeParameterSymbol)jKSymbol;
    }

    @NotNull
    public final JKPackageSymbol provideUniverseSymbol(@NotNull JKPackageDeclaration jk) {
        JKSymbol jKSymbol;
        Intrinsics.checkNotNullParameter((Object)jk, (String)"jk");
        Map<JKDeclaration, JKSymbol> $this$getOrPut$iv = this.symbolsByJK;
        boolean $i$f$getOrPut = false;
        JKSymbol value$iv = $this$getOrPut$iv.get(jk);
        if (value$iv == null) {
            boolean bl = false;
            JKTypeFactory jKTypeFactory = this.typeFactory;
            if (jKTypeFactory == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"typeFactory");
            }
            JKUniversePackageSymbol jKUniversePackageSymbol = new JKUniversePackageSymbol(jKTypeFactory);
            boolean bl2 = false;
            boolean bl3 = false;
            JKUniversePackageSymbol it = jKUniversePackageSymbol;
            boolean bl4 = false;
            it.setTarget(jk);
            JKSymbol answer$iv = jKUniversePackageSymbol;
            $this$getOrPut$iv.put(jk, answer$iv);
            jKSymbol = answer$iv;
        } else {
            jKSymbol = value$iv;
        }
        return (JKPackageSymbol)jKSymbol;
    }

    @Nullable
    public final JKUniverseSymbol<?> provideUniverseSymbol(@NotNull JKDeclaration jk) {
        JKSymbol jKSymbol;
        Intrinsics.checkNotNullParameter((Object)jk, (String)"jk");
        JKDeclaration jKDeclaration = jk;
        if (!((jKDeclaration instanceof JKClass ? (JKSymbol)this.provideUniverseSymbol((JKClass)jk) : (jKDeclaration instanceof JKVariable ? (JKSymbol)this.provideUniverseSymbol((JKVariable)jk) : (jKDeclaration instanceof JKMethod ? (JKSymbol)this.provideUniverseSymbol((JKMethod)jk) : (jKSymbol = jKDeclaration instanceof JKTypeParameter ? (JKSymbol)this.provideUniverseSymbol((JKTypeParameter)jk) : null)))) instanceof JKUniverseSymbol)) {
            jKSymbol = null;
        }
        return (JKUniverseSymbol)jKSymbol;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JKClassSymbol provideClassSymbol(@NotNull FqName fqName) {
        JKClassSymbol jKClassSymbol;
        Object object;
        void $this$getOrPutIfNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        Map<String, JKSymbol> map = this.symbolsByFqName;
        String string = fqName.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fqName.asString()");
        String key$iv = string;
        boolean $i$f$getOrPutIfNotNull = false;
        Object value$iv = $this$getOrPutIfNotNull$iv.get(key$iv);
        if (value$iv == null) {
            JKClassSymbol jKClassSymbol2;
            boolean bl = false;
            PsiElement psiElement = this.resolver.resolveClass(fqName);
            if (psiElement != null) {
                PsiElement psiElement2 = psiElement;
                boolean bl2 = false;
                boolean bl3 = false;
                PsiElement it = psiElement2;
                boolean bl4 = false;
                JKSymbol jKSymbol = this.provideDirectSymbol(it);
                if (!(jKSymbol instanceof JKClassSymbol)) {
                    jKSymbol = null;
                }
                jKClassSymbol2 = (JKClassSymbol)jKSymbol;
            } else {
                jKClassSymbol2 = null;
            }
            JKSymbol jKSymbol = jKClassSymbol2;
            if (jKSymbol == null) {
                object = null;
            } else {
                JKSymbol answer$iv = jKSymbol;
                $this$getOrPutIfNotNull$iv.put(key$iv, answer$iv);
                object = answer$iv;
            }
        } else {
            object = value$iv;
        }
        Object v = object;
        if (!(object instanceof JKClassSymbol)) {
            v = null;
        }
        if ((jKClassSymbol = (JKClassSymbol)v) == null) {
            String string2 = fqName.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"fqName.asString()");
            JKTypeFactory jKTypeFactory = this.typeFactory;
            if (jKTypeFactory == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"typeFactory");
            }
            jKClassSymbol = new JKUnresolvedClassSymbol(string2, jKTypeFactory);
        }
        return jKClassSymbol;
    }

    @NotNull
    public final JKClassSymbol provideClassSymbol(@NotNull String fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        return this.provideClassSymbol(new FqName(JKSymbolProviderKt.access$asSafeFqNameString(fqName)));
    }

    @NotNull
    public final JKClassSymbol provideClassSymbol(@NotNull FqNameUnsafe fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        FqName fqName2 = fqName.toSafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"fqName.toSafe()");
        return this.provideClassSymbol(fqName2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JKMethodSymbol provideMethodSymbol(@NotNull FqName fqName) {
        JKMethodSymbol jKMethodSymbol;
        Object object;
        void $this$getOrPutIfNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        Map<String, JKSymbol> map = this.symbolsByFqName;
        String string = fqName.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fqName.asString()");
        String key$iv = string;
        boolean $i$f$getOrPutIfNotNull = false;
        Object value$iv = $this$getOrPutIfNotNull$iv.get(key$iv);
        if (value$iv == null) {
            JKMethodSymbol jKMethodSymbol2;
            boolean bl = false;
            PsiElement psiElement = this.resolver.resolveMethod(fqName);
            if (psiElement != null) {
                PsiElement psiElement2 = psiElement;
                boolean bl2 = false;
                boolean bl3 = false;
                PsiElement it = psiElement2;
                boolean bl4 = false;
                JKSymbol jKSymbol = this.provideDirectSymbol(it);
                if (!(jKSymbol instanceof JKMethodSymbol)) {
                    jKSymbol = null;
                }
                jKMethodSymbol2 = (JKMethodSymbol)jKSymbol;
            } else {
                jKMethodSymbol2 = null;
            }
            JKSymbol jKSymbol = jKMethodSymbol2;
            if (jKSymbol == null) {
                object = null;
            } else {
                JKSymbol answer$iv = jKSymbol;
                $this$getOrPutIfNotNull$iv.put(key$iv, answer$iv);
                object = answer$iv;
            }
        } else {
            object = value$iv;
        }
        Object v = object;
        if (!(object instanceof JKMethodSymbol)) {
            v = null;
        }
        if ((jKMethodSymbol = (JKMethodSymbol)v) == null) {
            String string2 = fqName.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"fqName.asString()");
            JKTypeFactory jKTypeFactory = this.typeFactory;
            if (jKTypeFactory == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"typeFactory");
            }
            jKMethodSymbol = new JKUnresolvedMethod(string2, jKTypeFactory, null, 4, null);
        }
        return jKMethodSymbol;
    }

    @NotNull
    public final JKMethodSymbol provideMethodSymbol(@NotNull String fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        return this.provideMethodSymbol(new FqName(JKSymbolProviderKt.access$asSafeFqNameString(fqName)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JKFieldSymbol provideFieldSymbol(@NotNull FqName fqName) {
        JKFieldSymbol jKFieldSymbol;
        Object object;
        void $this$getOrPutIfNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        Map<String, JKSymbol> map = this.symbolsByFqName;
        String string = fqName.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fqName.asString()");
        String key$iv = string;
        boolean $i$f$getOrPutIfNotNull = false;
        Object value$iv = $this$getOrPutIfNotNull$iv.get(key$iv);
        if (value$iv == null) {
            JKFieldSymbol jKFieldSymbol2;
            boolean bl = false;
            PsiElement psiElement = this.resolver.resolveField(fqName);
            if (psiElement != null) {
                PsiElement psiElement2 = psiElement;
                boolean bl2 = false;
                boolean bl3 = false;
                PsiElement it = psiElement2;
                boolean bl4 = false;
                JKSymbol jKSymbol = this.provideDirectSymbol(it);
                if (!(jKSymbol instanceof JKFieldSymbol)) {
                    jKSymbol = null;
                }
                jKFieldSymbol2 = (JKFieldSymbol)jKSymbol;
            } else {
                jKFieldSymbol2 = null;
            }
            JKSymbol jKSymbol = jKFieldSymbol2;
            if (jKSymbol == null) {
                object = null;
            } else {
                JKSymbol answer$iv = jKSymbol;
                $this$getOrPutIfNotNull$iv.put(key$iv, answer$iv);
                object = answer$iv;
            }
        } else {
            object = value$iv;
        }
        Object v = object;
        if (!(object instanceof JKFieldSymbol)) {
            v = null;
        }
        if ((jKFieldSymbol = (JKFieldSymbol)v) == null) {
            String string2 = fqName.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"fqName.asString()");
            JKTypeFactory jKTypeFactory = this.typeFactory;
            if (jKTypeFactory == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"typeFactory");
            }
            jKFieldSymbol = new JKUnresolvedField(string2, jKTypeFactory);
        }
        return jKFieldSymbol;
    }

    @NotNull
    public final JKFieldSymbol provideFieldSymbol(@NotNull String fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        return this.provideFieldSymbol(new FqName(JKSymbolProviderKt.access$asSafeFqNameString(fqName)));
    }

    public final /* synthetic */ <A, B> boolean isAssignable$kotlin_j2k_new() {
        int $i$f$isAssignable$kotlin_j2k_new = 0;
        Intrinsics.reifiedOperationMarker((int)4, (String)"A");
        Intrinsics.reifiedOperationMarker((int)4, (String)"B");
        return Object.class.isAssignableFrom(Object.class);
    }

    public JKSymbolProvider(@NotNull JKResolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        this.resolver = resolver;
        boolean bl = false;
        this.symbolsByFqName = new LinkedHashMap();
        bl = false;
        this.symbolsByPsi = new LinkedHashMap();
        bl = false;
        this.symbolsByJK = new LinkedHashMap();
        this.elementVisitor = new ElementVisitor();
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0016\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/nj2k/JKSymbolProvider$ElementVisitor;", "Lcom/intellij/psi/JavaElementVisitor;", "(Lorg/jetbrains/kotlin/nj2k/JKSymbolProvider;)V", "visitClass", "", "aClass", "Lcom/intellij/psi/PsiClass;", "visitElement", "element", "Lcom/intellij/psi/PsiElement;", "visitEnumConstant", "enumConstant", "Lcom/intellij/psi/PsiEnumConstant;", "visitField", "field", "Lcom/intellij/psi/PsiField;", "visitFile", "file", "Lcom/intellij/psi/PsiFile;", "visitMethod", "method", "Lcom/intellij/psi/PsiMethod;", "visitPackageStatement", "statement", "Lcom/intellij/psi/PsiPackageStatement;", "visitParameter", "parameter", "Lcom/intellij/psi/PsiParameter;", "visitTypeParameter", "classParameter", "Lcom/intellij/psi/PsiTypeParameter;", "kotlin.j2k.new"})
    private final class ElementVisitor
    extends JavaElementVisitor {
        public void visitElement(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            element.acceptChildren((PsiElementVisitor)this);
        }

        public void visitClass(@NotNull PsiClass aClass) {
            Intrinsics.checkNotNullParameter((Object)aClass, (String)"aClass");
            JKSymbolProvider.this.provideUniverseSymbol((PsiElement)aClass);
            aClass.acceptChildren((PsiElementVisitor)this);
        }

        public void visitField(@NotNull PsiField field) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            JKSymbolProvider.this.provideUniverseSymbol((PsiElement)field);
        }

        public void visitParameter(@NotNull PsiParameter parameter) {
            Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
            JKSymbolProvider.this.provideUniverseSymbol((PsiElement)parameter);
        }

        public void visitMethod(@NotNull PsiMethod method) {
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            JKSymbolProvider.this.provideUniverseSymbol((PsiElement)method);
            method.acceptChildren((PsiElementVisitor)this);
        }

        public void visitEnumConstant(@NotNull PsiEnumConstant enumConstant) {
            Intrinsics.checkNotNullParameter((Object)enumConstant, (String)"enumConstant");
            JKSymbolProvider.this.provideUniverseSymbol((PsiElement)enumConstant);
            enumConstant.acceptChildren((PsiElementVisitor)this);
        }

        public void visitTypeParameter(@NotNull PsiTypeParameter classParameter) {
            Intrinsics.checkNotNullParameter((Object)classParameter, (String)"classParameter");
            JKSymbolProvider.this.provideUniverseSymbol((PsiElement)classParameter);
        }

        public void visitPackageStatement(@NotNull PsiPackageStatement statement) {
            Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
            JKSymbolProvider.this.provideUniverseSymbol((PsiElement)statement);
        }

        public void visitFile(@NotNull PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            file.acceptChildren((PsiElementVisitor)this);
        }
    }
}

