/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.state;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.spellchecker.dictionary.EditableDictionary;
import com.intellij.spellchecker.state.DictionaryState;
import com.intellij.spellchecker.state.DictionaryStateListener;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import org.jetbrains.annotations.NotNull;

@State(name="CachedDictionaryState", storages={@Storage(value="cachedDictionary.xml", roamingType=RoamingType.DISABLED)}, reportStatistic=false)
public class CachedDictionaryState
extends DictionaryState
implements PersistentStateComponent<DictionaryState> {
    public static final String DEFAULT_NAME = "cached";
    private final EventDispatcher<DictionaryStateListener> myDictListenerEventDispatcher = EventDispatcher.create(DictionaryStateListener.class);

    public CachedDictionaryState() {
        this.name = DEFAULT_NAME;
    }

    @NotNull
    public static CachedDictionaryState getInstance() {
        return (CachedDictionaryState)ServiceManager.getService(CachedDictionaryState.class);
    }

    @NonInjectable
    public CachedDictionaryState(EditableDictionary dictionary) {
        super(dictionary);
        this.name = DEFAULT_NAME;
    }

    @Override
    public void loadState(@NotNull DictionaryState state) {
        if (state.name == null) {
            state.name = DEFAULT_NAME;
        }
        super.loadState(state);
        ((DictionaryStateListener)this.myDictListenerEventDispatcher.getMulticaster()).dictChanged(this.getDictionary());
    }

    public void addCachedDictListener(DictionaryStateListener listener) {
        this.myDictListenerEventDispatcher.addListener((EventListener)listener);
    }
}

