/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.quickfixes;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.spellchecker.SpellCheckerManager;
import com.intellij.spellchecker.quickfixes.SpellCheckerQuickFix;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import com.intellij.ui.components.JBList;
import icons.SpellcheckerIcons;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

public class SaveTo
implements SpellCheckerQuickFix,
LowPriorityAction {
    private static final SaveTo SAVE_TO_APP_FIX = new SaveTo(SpellCheckerManager.DictionaryLevel.APP);
    private static final SaveTo SAVE_TO_PROJECT_FIX = new SaveTo(SpellCheckerManager.DictionaryLevel.PROJECT);
    private static final String DICTIONARY = " dictionary";
    private static final String DOTS = "...";
    private SpellCheckerManager.DictionaryLevel myLevel = SpellCheckerManager.DictionaryLevel.NOT_SPECIFIED;
    private String myWord;

    private SaveTo(@NotNull SpellCheckerManager.DictionaryLevel level) {
        this.myLevel = level;
    }

    public SaveTo(String word) {
        this.myWord = word;
    }

    public SaveTo(String word, @NotNull SpellCheckerManager.DictionaryLevel level) {
        this.myWord = word;
        this.myLevel = level;
    }

    @NotNull
    public String getName() {
        return SpellCheckerBundle.message("save.0.to.1", this.myWord != null ? SpellCheckerBundle.message("0.in.qoutes", this.myWord) : "");
    }

    @NotNull
    public String getFamilyName() {
        String dictionary = this.myLevel != SpellCheckerManager.DictionaryLevel.NOT_SPECIFIED ? this.myLevel.getName() + DICTIONARY : DOTS;
        return SpellCheckerBundle.message("save.0.to.1", "", dictionary);
    }

    @Override
    @NotNull
    public Anchor getPopupActionAnchor() {
        return Anchor.LAST;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(context -> {
            SpellCheckerManager manager = SpellCheckerManager.getInstance(project);
            String wordToSave = this.myWord != null ? this.myWord : ProblemDescriptorUtil.extractHighlightedText((CommonProblemDescriptor)descriptor, (PsiElement)descriptor.getPsiElement());
            VirtualFile file = descriptor.getPsiElement().getContainingFile().getVirtualFile();
            if (this.myLevel == SpellCheckerManager.DictionaryLevel.NOT_SPECIFIED) {
                List<String> dictionaryList = Arrays.asList(SpellCheckerManager.DictionaryLevel.PROJECT.getName(), SpellCheckerManager.DictionaryLevel.APP.getName());
                JBList dictList = new JBList(dictionaryList);
                JBPopupFactory.getInstance().createListPopupBuilder((JList)dictList).setTitle(SpellCheckerBundle.message("select.dictionary.title", new Object[0])).setItemChoosenCallback(() -> CommandProcessor.getInstance().executeCommand(project, () -> manager.acceptWordAsCorrect(wordToSave, file, project, SpellCheckerManager.DictionaryLevel.getLevelByName((String)dictList.getSelectedValue())), this.getName(), null)).createPopup().showInBestPositionFor(context);
            } else {
                manager.acceptWordAsCorrect(wordToSave, file, project, this.myLevel);
            }
        });
    }

    public static SaveTo getSaveToLevelFix(SpellCheckerManager.DictionaryLevel level) {
        return SpellCheckerManager.DictionaryLevel.PROJECT == level ? SAVE_TO_PROJECT_FIX : SAVE_TO_APP_FIX;
    }

    public Icon getIcon(int flags) {
        return SpellcheckerIcons.Spellcheck;
    }

    public static String getFixName() {
        return SpellCheckerBundle.message("save.0.to.1", "", DOTS);
    }
}

