/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.inspections;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.spellchecker.SpellCheckerManager;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.quickfixes.SpellCheckerQuickFix;
import com.intellij.spellchecker.tokenizer.LanguageSpellchecking;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.SuppressibleSpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import com.intellij.util.Consumer;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpellCheckingInspection
extends LocalInspectionTool {
    public static final String SPELL_CHECKING_INSPECTION_TOOL_NAME = "SpellCheckingInspection";
    public boolean processCode = true;
    public boolean processLiterals = true;
    public boolean processComments = true;

    public SuppressQuickFix @NotNull [] getBatchSuppressActions(@Nullable PsiElement element) {
        Language language;
        SpellcheckingStrategy strategy;
        if (element != null && (strategy = SpellCheckingInspection.getSpellcheckingStrategy(element, language = element.getLanguage())) instanceof SuppressibleSpellcheckingStrategy) {
            return ((SuppressibleSpellcheckingStrategy)strategy).getSuppressActions(element, this.getShortName());
        }
        return super.getBatchSuppressActions(element);
    }

    private static SpellcheckingStrategy getSpellcheckingStrategy(@NotNull PsiElement element, @NotNull Language language) {
        for (SpellcheckingStrategy strategy : LanguageSpellchecking.INSTANCE.allForLanguage(language)) {
            if (!strategy.isMyContext(element)) continue;
            return strategy;
        }
        return null;
    }

    public boolean isSuppressedFor(@NotNull PsiElement element) {
        Language language = element.getLanguage();
        SpellcheckingStrategy strategy = SpellCheckingInspection.getSpellcheckingStrategy(element, language);
        if (strategy instanceof SuppressibleSpellcheckingStrategy) {
            return ((SuppressibleSpellcheckingStrategy)strategy).isSuppressedFor(element, this.getShortName());
        }
        return super.isSuppressedFor(element);
    }

    @NonNls
    @NotNull
    public String getShortName() {
        return SPELL_CHECKING_INSPECTION_TOOL_NAME;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        final SpellCheckerManager manager = SpellCheckerManager.getInstance(holder.getProject());
        return new PsiElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (holder.getResultCount() > 1000) {
                    return;
                }
                ASTNode node = element.getNode();
                if (node == null) {
                    return;
                }
                Language language = element.getLanguage();
                IElementType elementType = node.getElementType();
                ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
                if (parserDefinition != null && (parserDefinition.getStringLiteralElements().contains(elementType) ? !SpellCheckingInspection.this.processLiterals : (parserDefinition.getCommentTokens().contains(elementType) ? !SpellCheckingInspection.this.processComments : !SpellCheckingInspection.this.processCode))) {
                    return;
                }
                SpellCheckingInspection.tokenize(element, language, new MyTokenConsumer(manager, holder, LanguageNamesValidation.INSTANCE.forLanguage(language)));
            }
        };
    }

    public static void tokenize(@NotNull PsiElement element, @NotNull Language language, TokenConsumer consumer) {
        SpellcheckingStrategy factoryByLanguage = SpellCheckingInspection.getSpellcheckingStrategy(element, language);
        if (factoryByLanguage == null) {
            return;
        }
        Tokenizer tokenizer = factoryByLanguage.getTokenizer(element);
        tokenizer.tokenize(element, consumer);
    }

    private static void addBatchDescriptor(PsiElement element, int offset, @NotNull TextRange textRange, @NotNull ProblemsHolder holder) {
        SpellCheckerQuickFix[] fixes = SpellcheckingStrategy.getDefaultBatchFixes();
        ProblemDescriptor problemDescriptor = SpellCheckingInspection.createProblemDescriptor(element, offset, textRange, fixes, false);
        holder.registerProblem(problemDescriptor);
    }

    private static void addRegularDescriptor(PsiElement element, int offset, @NotNull TextRange textRange, @NotNull ProblemsHolder holder, boolean useRename, String wordWithTypo) {
        SpellcheckingStrategy strategy = SpellCheckingInspection.getSpellcheckingStrategy(element, element.getLanguage());
        SpellCheckerQuickFix[] fixes = strategy != null ? strategy.getRegularFixes(element, offset, textRange, useRename, wordWithTypo) : SpellcheckingStrategy.getDefaultRegularFixes(useRename, wordWithTypo, element);
        ProblemDescriptor problemDescriptor = SpellCheckingInspection.createProblemDescriptor(element, offset, textRange, fixes, true);
        holder.registerProblem(problemDescriptor);
    }

    private static ProblemDescriptor createProblemDescriptor(PsiElement element, int offset, TextRange textRange, SpellCheckerQuickFix[] fixes, boolean onTheFly) {
        Tokenizer tokenizer;
        SpellcheckingStrategy strategy = SpellCheckingInspection.getSpellcheckingStrategy(element, element.getLanguage());
        Tokenizer tokenizer2 = tokenizer = strategy != null ? strategy.getTokenizer(element) : null;
        if (tokenizer != null) {
            textRange = tokenizer.getHighlightingRange(element, offset, textRange);
        }
        assert (textRange.getStartOffset() >= 0);
        String description = SpellCheckerBundle.message("typo.in.word.ref", new Object[0]);
        return new ProblemDescriptorBase(element, element, description, (LocalQuickFix[])fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, textRange, onTheFly, onTheFly);
    }

    public JComponent createOptionsPanel() {
        Box verticalBox = Box.createVerticalBox();
        verticalBox.add((Component)new SingleCheckboxOptionsPanel(SpellCheckerBundle.message("process.code", new Object[0]), (InspectionProfileEntry)this, "processCode"));
        verticalBox.add((Component)new SingleCheckboxOptionsPanel(SpellCheckerBundle.message("process.literals", new Object[0]), (InspectionProfileEntry)this, "processLiterals"));
        verticalBox.add((Component)new SingleCheckboxOptionsPanel(SpellCheckerBundle.message("process.comments", new Object[0]), (InspectionProfileEntry)this, "processComments"));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)verticalBox, "North");
        return panel;
    }

    private static class MyTokenConsumer
    extends TokenConsumer
    implements Consumer<TextRange> {
        private final Set<String> myAlreadyChecked = new THashSet();
        private final SpellCheckerManager myManager;
        private final ProblemsHolder myHolder;
        private final NamesValidator myNamesValidator;
        private PsiElement myElement;
        private String myText;
        private boolean myUseRename;
        private int myOffset;

        MyTokenConsumer(SpellCheckerManager manager, ProblemsHolder holder, NamesValidator namesValidator) {
            this.myManager = manager;
            this.myHolder = holder;
            this.myNamesValidator = namesValidator;
        }

        @Override
        public void consumeToken(PsiElement element, String text, boolean useRename, int offset, TextRange rangeToCheck, Splitter splitter) {
            this.myElement = element;
            this.myText = text;
            this.myUseRename = useRename;
            this.myOffset = offset;
            splitter.split(text, rangeToCheck, this);
        }

        public void consume(TextRange textRange) {
            String word = textRange.substring(this.myText);
            if (!this.myHolder.isOnTheFly() && this.myAlreadyChecked.contains(word)) {
                return;
            }
            boolean keyword = this.myNamesValidator.isKeyword(word, this.myElement.getProject());
            if (keyword) {
                return;
            }
            if (this.myManager.hasProblem(word)) {
                if (this.myHolder.isOnTheFly()) {
                    SpellCheckingInspection.addRegularDescriptor(this.myElement, this.myOffset, textRange, this.myHolder, this.myUseRename, word);
                } else {
                    this.myAlreadyChecked.add(word);
                    SpellCheckingInspection.addBatchDescriptor(this.myElement, this.myOffset, textRange, this.myHolder);
                }
            }
        }
    }
}

