/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.spellchecker.dictionary.Loader;
import com.intellij.util.Consumer;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

public class StreamLoader
implements Loader {
    private final InputStream stream;
    private final String name;

    public StreamLoader(InputStream stream, String name) {
        this.stream = stream;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void load(@NotNull Consumer<String> consumer) {
        StreamLoader.doLoad(this.stream, consumer);
    }

    static void doLoad(@NotNull InputStream stream, @NotNull Consumer<? super String> consumer) {
        StreamLoader.doLoad(stream, consumer, StandardCharsets.UTF_8);
    }

    static void doLoad(@NotNull InputStream stream, @NotNull Consumer<? super String> consumer, Charset charset) {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(stream, charset));){
            br.lines().forEach(arg_0 -> consumer.consume(arg_0));
        }
        catch (Exception e) {
            Logger.getInstance(StreamLoader.class).error((Throwable)e);
        }
    }
}

