/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import com.intellij.util.lang.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class MemoryResource
extends Resource {
    private final URL myUrl;
    private final byte[] myContent;
    private final Map<Resource.Attribute, String> myAttributes;

    private MemoryResource(@NotNull URL url, @NotNull byte[] content, @Nullable Map<Resource.Attribute, String> attributes) {
        this.myUrl = url;
        this.myContent = content;
        this.myAttributes = attributes;
    }

    @Override
    @NotNull
    public URL getURL() {
        return this.myUrl;
    }

    @Override
    @NotNull
    public InputStream getInputStream() {
        return new UnsyncByteArrayInputStream(this.myContent);
    }

    @Override
    @NotNull
    public byte[] getBytes() {
        return this.myContent;
    }

    @Override
    public String getValue(@NotNull Resource.Attribute key) {
        return this.myAttributes != null ? this.myAttributes.get((Object)key) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    static MemoryResource load(@NotNull URL baseUrl, @NotNull ZipFile zipFile, @NotNull ZipEntry entry, @Nullable Map<Resource.Attribute, String> attributes) throws IOException {
        String name = entry.getName();
        URL url = new URL(baseUrl, name);
        byte[] content = ArrayUtilRt.EMPTY_BYTE_ARRAY;
        InputStream stream = zipFile.getInputStream(entry);
        if (stream != null) {
            try {
                content = FileUtilRt.loadBytes(stream, (int)entry.getSize());
            }
            finally {
                stream.close();
            }
        }
        return new MemoryResource(url, content, attributes);
    }
}

