/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.keyFMap;

import com.intellij.openapi.util.Key;
import com.intellij.util.ArrayUtil;
import com.intellij.util.keyFMap.KeyFMap;
import com.intellij.util.keyFMap.MapBackedFMap;
import com.intellij.util.keyFMap.OneElementFMap;
import com.intellij.util.keyFMap.PairElementsFMap;
import org.jetbrains.annotations.NotNull;

public class ArrayBackedFMap
implements KeyFMap {
    static final int ARRAY_THRESHOLD = 8;
    private final int[] keys;
    private final Object[] values;

    ArrayBackedFMap(int @NotNull [] keys, Object @NotNull [] values) {
        this.keys = keys;
        this.values = values;
    }

    @Override
    @NotNull
    public <V> KeyFMap plus(@NotNull Key<V> key, @NotNull V value) {
        int keyCode = key.hashCode();
        int keyPos = this.indexOf(keyCode);
        if (keyPos >= 0) {
            if (this.values[keyPos] == value) {
                return this;
            }
            Object[] newValues = (Object[])this.values.clone();
            newValues[keyPos] = value;
            return new ArrayBackedFMap(this.keys, newValues);
        }
        if (this.size() < 8) {
            int[] newKeys = ArrayUtil.insert(this.keys, -keyPos - 1, keyCode);
            Object[] newValues = ArrayUtil.insert(this.values, -keyPos - 1, value);
            return new ArrayBackedFMap(newKeys, newValues);
        }
        return new MapBackedFMap(this.keys, keyCode, this.values, value);
    }

    @Override
    public int size() {
        return this.keys.length;
    }

    private int indexOf(int keyCode) {
        for (int i = 0; i < this.keys.length; ++i) {
            int key = this.keys[i];
            if (key == keyCode) {
                return i;
            }
            if (key <= keyCode) continue;
            return -i - 1;
        }
        return -this.keys.length - 1;
    }

    @Override
    @NotNull
    public KeyFMap minus(@NotNull Key<?> key) {
        int i = this.indexOf(key.hashCode());
        if (i >= 0) {
            if (this.size() == 3) {
                int otherI1 = (2 - i) / 2;
                int otherI2 = 3 - (i + 2) / 2;
                Key key1 = Key.getKeyByIndex(this.keys[otherI1]);
                Key key2 = Key.getKeyByIndex(this.keys[otherI2]);
                if (key1 == null && key2 == null) {
                    return EMPTY_MAP;
                }
                if (key1 == null) {
                    return new OneElementFMap<Object>(key2, this.values[otherI2]);
                }
                if (key2 == null) {
                    return new OneElementFMap<Object>(key1, this.values[otherI1]);
                }
                return new PairElementsFMap<Object, Object>(key1, this.values[otherI1], key2, this.values[otherI2]);
            }
            int[] newKeys = ArrayUtil.remove(this.keys, i);
            Object[] newValues = ArrayUtil.remove(this.values, i, ArrayUtil.OBJECT_ARRAY_FACTORY);
            return new ArrayBackedFMap(newKeys, newValues);
        }
        return this;
    }

    @Override
    public <V> V get(@NotNull Key<V> key) {
        int i = this.indexOf(key.hashCode());
        return (V)(i < 0 ? null : this.values[i]);
    }

    public String toString() {
        StringBuilder s = new StringBuilder("{");
        for (int i = 0; i < this.keys.length; ++i) {
            int key = this.keys[i];
            Object value = this.values[i];
            s.append(s.length() == 1 ? "" : ", ").append(Key.getKeyByIndex(key)).append("=").append(value);
        }
        return s.append("}").toString();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int getValueIdentityHashCode() {
        int hash = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            hash = hash * 31 + this.keys[i];
            hash = hash * 31 + System.identityHashCode(this.values[i]);
        }
        return hash;
    }

    @Override
    public Key @NotNull [] getKeys() {
        return ArrayBackedFMap.getKeysByIndices(this.keys);
    }

    static Key @NotNull [] getKeysByIndices(int[] indexes) {
        Key[] result = new Key[indexes.length];
        for (int i = 0; i < indexes.length; ++i) {
            result[i] = Key.getKeyByIndex(indexes[i]);
        }
        return result;
    }

    public int hashCode() {
        int hash = 0;
        int length = this.keys.length;
        for (int i = 0; i < length; ++i) {
            hash += this.keys[i] ^ this.values[i].hashCode();
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArrayBackedFMap)) {
            return false;
        }
        ArrayBackedFMap map = (ArrayBackedFMap)o;
        if (map.size() != this.size()) {
            return false;
        }
        int length = this.keys.length;
        for (int i = 0; i < length; ++i) {
            if (this.keys[i] == map.keys[i] && this.values[i].equals(map.values[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equalsByReference(KeyFMap o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArrayBackedFMap)) {
            return false;
        }
        ArrayBackedFMap map = (ArrayBackedFMap)o;
        if (map.size() != this.size()) {
            return false;
        }
        int length = this.keys.length;
        for (int i = 0; i < length; ++i) {
            if (this.keys[i] == map.keys[i] && this.values[i] == map.values[i]) continue;
            return false;
        }
        return true;
    }
}

