/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.storage;

import com.intellij.UtilBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.EventDispatcher;
import java.util.Deque;
import java.util.EventListener;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HeavyProcessLatch {
    private static final Logger LOG = Logger.getInstance(HeavyProcessLatch.class);
    public static final HeavyProcessLatch INSTANCE = new HeavyProcessLatch();
    private final Map<String, Type> myHeavyProcesses = new ConcurrentHashMap<String, Type>();
    private final EventDispatcher<HeavyProcessListener> myEventDispatcher = EventDispatcher.create(HeavyProcessListener.class);
    private final Deque<Runnable> toExecuteOutOfHeavyActivity = new ConcurrentLinkedDeque<Runnable>();

    private HeavyProcessLatch() {
    }

    @NotNull
    public AccessToken processStarted(@NotNull String operationName) {
        return this.processStarted(operationName, Type.Processing);
    }

    public AccessToken processStarted(final @NotNull String operationName, @NotNull Type type) {
        this.myHeavyProcesses.put(operationName, type);
        this.myEventDispatcher.getMulticaster().processStarted();
        return new AccessToken(){

            @Override
            public void finish() {
                HeavyProcessLatch.this.processFinished(operationName);
            }
        };
    }

    private void processFinished(@NotNull String operationName) {
        Runnable runnable;
        this.myHeavyProcesses.remove(operationName);
        this.myEventDispatcher.getMulticaster().processFinished();
        if (this.isRunning()) {
            return;
        }
        while ((runnable = this.toExecuteOutOfHeavyActivity.pollFirst()) != null) {
            try {
                runnable.run();
            }
            catch (Exception e) {
                LOG.error(e);
            }
        }
    }

    public boolean isRunning() {
        return !this.myHeavyProcesses.isEmpty();
    }

    @Nullable
    public String getRunningOperationName() {
        Map.Entry<String, Type> runningOperation = this.getRunningOperation();
        return runningOperation != null ? runningOperation.getKey() : null;
    }

    @Nullable
    public Map.Entry<String, Type> getRunningOperation() {
        if (this.myHeavyProcesses.isEmpty()) {
            return null;
        }
        Iterator<Map.Entry<String, Type>> iterator = this.myHeavyProcesses.entrySet().iterator();
        return iterator.hasNext() ? iterator.next() : null;
    }

    public void addListener(@NotNull HeavyProcessListener listener, @NotNull Disposable parentDisposable) {
        this.myEventDispatcher.addListener(listener, parentDisposable);
    }

    public void executeOutOfHeavyProcess(@NotNull Runnable runnable) {
        if (this.isRunning()) {
            this.toExecuteOutOfHeavyActivity.add(runnable);
        } else {
            runnable.run();
        }
    }

    public static interface HeavyProcessListener
    extends EventListener {
        default public void processStarted() {
        }

        public void processFinished();
    }

    public static enum Type {
        Indexing("heavyProcess.type.indexing"),
        Syncing("heavyProcess.type.syncing"),
        Processing("heavyProcess.type.processing");

        private final String bundleKey;

        private Type(String bundleKey) {
            this.bundleKey = bundleKey;
        }

        public String toString() {
            return UtilBundle.message(this.bundleKey, new Object[0]);
        }
    }
}

