/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.keyStorage;

import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.util.Processor;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.LimitedInputStream;
import com.intellij.util.io.MappedFileInputStream;
import com.intellij.util.io.PagedFileStorage;
import com.intellij.util.io.ResizeableMappedFile;
import com.intellij.util.io.StorageLockContext;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import com.intellij.util.io.keyStorage.AppendableObjectStorage;
import com.intellij.util.io.keyStorage.NoDataException;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppendableStorageBackedByResizableMappedFile<Data>
extends ResizeableMappedFile
implements AppendableObjectStorage<Data> {
    private static final ThreadLocal<MyDataIS> ourReadStream = ThreadLocal.withInitial(() -> new MyDataIS());
    private volatile byte[] myAppendBuffer;
    private volatile int myFileLength;
    private volatile int myBufferPosition;
    private static final int ourAppendBufferLength = 4096;
    @NotNull
    private final KeyDescriptor<Data> myDataDescriptor;
    private static final InputStream TOMBSTONE = new InputStream(){

        @Override
        public int read() {
            throw new IllegalStateException("should not happen");
        }
    };

    public AppendableStorageBackedByResizableMappedFile(Path file, int initialSize, @Nullable StorageLockContext lockContext, int pageSize, boolean valuesAreBufferAligned, @NotNull KeyDescriptor<Data> dataDescriptor) {
        super(file, initialSize, lockContext, pageSize, valuesAreBufferAligned);
        this.myDataDescriptor = dataDescriptor;
        this.myFileLength = (int)this.length();
    }

    private void flushKeyStoreBuffer() {
        if (this.myBufferPosition > 0) {
            this.put(this.myFileLength, this.myAppendBuffer, 0, this.myBufferPosition);
            this.myFileLength += this.myBufferPosition;
            this.myBufferPosition = 0;
        }
    }

    @Override
    public void force() {
        this.flushKeyStoreBuffer();
        super.force();
    }

    @Override
    public void close() {
        this.flushKeyStoreBuffer();
        super.close();
        ourReadStream.remove();
    }

    @Override
    public Data read(int addr) throws IOException {
        if (this.myFileLength <= addr) {
            if (this.myAppendBuffer == null) {
                throw new NoDataException("requested address points to un-existed data");
            }
            int bufferOffset = addr - this.myFileLength;
            if (bufferOffset > this.myBufferPosition) {
                throw new NoDataException("requested address points to un-existed data");
            }
            return (Data)this.myDataDescriptor.read(new DataInputStream(new UnsyncByteArrayInputStream(this.myAppendBuffer, bufferOffset, this.myBufferPosition)));
        }
        MyDataIS rs = ourReadStream.get();
        rs.setup(this, addr, this.myFileLength);
        return (Data)this.myDataDescriptor.read(rs);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean processAll(@NotNull Processor<? super Data> processor) throws IOException {
        assert (!this.isDirty());
        if (this.myFileLength == 0) {
            return true;
        }
        Throwable throwable = null;
        try (DataInputStream keysStream = new DataInputStream(new BufferedInputStream(new LimitedInputStream(Files.newInputStream(this.getPagedFileStorage().getFile(), new OpenOption[0]), this.myFileLength){

            @Override
            public int available() {
                return this.remainingLimit();
            }
        }, 32768));){
            while (true) {
                Object key;
                if (!processor.process(key = this.myDataDescriptor.read(keysStream))) {
                    boolean bl = false;
                    return bl;
                }
                continue;
                break;
            }
        }
        catch (EOFException eOFException) {
            boolean bl = true;
            return bl;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    @Override
    public int getCurrentLength() {
        return this.myBufferPosition + this.myFileLength;
    }

    @Override
    public int append(Data value) throws IOException {
        BufferExposingByteArrayOutputStream bos = new BufferExposingByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bos);
        this.myDataDescriptor.save(out, value);
        int size = bos.size();
        byte[] buffer = bos.getInternalBuffer();
        int currentLength = this.getCurrentLength();
        if (size > 4096) {
            this.flushKeyStoreBuffer();
            this.put(currentLength, buffer, 0, size);
            this.myFileLength += size;
        } else {
            if (size > 4096 - this.myBufferPosition) {
                this.flushKeyStoreBuffer();
            }
            if (this.myAppendBuffer == null) {
                this.myAppendBuffer = new byte[4096];
            }
            System.arraycopy(buffer, 0, this.myAppendBuffer, this.myBufferPosition, size);
            this.myBufferPosition += size;
        }
        return currentLength;
    }

    @Override
    public boolean checkBytesAreTheSame(int addr, Data value) throws IOException {
        boolean[] sameValue = new boolean[1];
        OutputStream comparer = this.buildOldComparerStream(addr, sameValue);
        DataOutputStream out = new DataOutputStream(comparer);
        this.myDataDescriptor.save(out, value);
        comparer.close();
        return sameValue[0];
    }

    @Override
    public void lockRead() {
        this.getPagedFileStorage().lockRead();
    }

    @Override
    public void unlockRead() {
        this.getPagedFileStorage().unlockRead();
    }

    @Override
    public void lockWrite() {
        this.getPagedFileStorage().lockWrite();
    }

    @Override
    public void unlockWrite() {
        this.getPagedFileStorage().unlockWrite();
    }

    @NotNull
    private OutputStream buildOldComparerStream(final int addr, final boolean[] sameValue) {
        final PagedFileStorage storage = this.getPagedFileStorage();
        OutputStream comparer = this.myFileLength <= addr ? new OutputStream(){
            int address;
            boolean same;
            {
                this.address = addr - AppendableStorageBackedByResizableMappedFile.this.myFileLength;
                this.same = true;
            }

            @Override
            public void write(int b) {
                if (this.same) {
                    this.same = this.address < AppendableStorageBackedByResizableMappedFile.this.myBufferPosition && AppendableStorageBackedByResizableMappedFile.this.myAppendBuffer[this.address++] == (byte)b;
                }
            }

            @Override
            public void close() {
                sameValue[0] = this.same;
            }
        } : new OutputStream(){
            int base;
            int address;
            boolean same;
            ByteBuffer buffer;
            final int myPageSize;
            {
                this.base = addr;
                this.address = storage.getOffsetInPage(addr);
                this.same = true;
                this.buffer = storage.getByteBuffer(addr, false).getCachedBuffer();
                this.myPageSize = storage.getPageSize();
            }

            @Override
            public void write(int b) {
                if (this.same) {
                    if (this.myPageSize == this.address && this.address < AppendableStorageBackedByResizableMappedFile.this.myFileLength) {
                        this.base += this.address;
                        this.buffer = storage.getByteBuffer(this.base, false).getCachedBuffer();
                        this.address = 0;
                    }
                    this.same = this.address < AppendableStorageBackedByResizableMappedFile.this.myFileLength && this.buffer.get(this.address++) == (byte)b;
                }
            }

            @Override
            public void close() {
                sameValue[0] = this.same;
            }
        };
        return comparer;
    }

    private static class MyBufferedIS
    extends BufferedInputStream {
        MyBufferedIS() {
            super(TOMBSTONE, 512);
        }

        void setup(ResizeableMappedFile in, long pos, long limit) {
            this.pos = 0;
            this.count = 0;
            this.in = new MappedFileInputStream(in, pos, limit);
        }
    }

    private static class MyDataIS
    extends DataInputStream {
        private MyDataIS() {
            super(new MyBufferedIS());
        }

        void setup(ResizeableMappedFile is, long pos, long limit) {
            ((MyBufferedIS)this.in).setup(is, pos, limit);
        }
    }
}

