/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public final class SourceCodeCompressor {
    private static final VaultOutputStream OUTPUT;
    private static final byte[] PRESET_BUF;
    private static final Deflater DEFLATER;
    private static final Inflater INFLATER;
    private static final byte[] INFLATE_BUFFER;

    private SourceCodeCompressor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized byte[] compress(byte[] source, int off, int len) {
        try {
            DEFLATER.reset();
            DEFLATER.setDictionary(PRESET_BUF);
            try (DeflaterOutputStream output = new DeflaterOutputStream((OutputStream)OUTPUT, DEFLATER);){
                output.write(source, off, len);
            }
            catch (IOException e) {
                byte[] byArray = source;
                OUTPUT.reset();
                return byArray;
            }
            byte[] byArray = OUTPUT.toByteArray();
            return byArray;
        }
        finally {
            OUTPUT.reset();
        }
    }

    public static synchronized byte[] compress(byte[] source) {
        return SourceCodeCompressor.compress(source, 0, source.length);
    }

    public static synchronized byte[] decompress(byte[] compressed) throws IOException {
        int len = compressed.length;
        boolean off = false;
        return SourceCodeCompressor.decompress(compressed, len, 0);
    }

    /*
     * Loose catch block
     */
    public static byte[] decompress(byte[] compressed, int len, int off) throws IOException {
        INFLATER.reset();
        try {
            try (InflaterInputStream input = new InflaterInputStream(new ByteArrayInputStream(compressed, off, len), INFLATER);){
                int readBytes;
                int b = input.read();
                if (b == -1) {
                    INFLATER.setDictionary(PRESET_BUF);
                } else {
                    OUTPUT.write(b);
                }
                while ((readBytes = input.read(INFLATE_BUFFER)) > 0) {
                    OUTPUT.write(INFLATE_BUFFER, 0, readBytes);
                }
                byte[] byArray = OUTPUT.toByteArray();
                return byArray;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            OUTPUT.reset();
        }
    }

    static {
        String preset_buf_string = "                   ;\r\n\r\n\r\n\r\n\n\n\n { {\r\n }\r\n = == != < > >= <= ? : ++ += -- -= [] [i] () ()) ())) (); ()); ())); () {// /* /** */ * opyright (c)package com.import java.utilimport javax.swingimport java.awtimport com.intellijimport org.import gnu.*;new super(this(public interface extends implements public abstract class public class private final static final protected synchronized my our instanceof throws return return;if (else {for (while (do {break;continue;throw try {catch (finally {null;true;false;void byte short int long boolean float double Object String Class System.Exception ThrowablegetsetputcontainsrunashCodeequalslengthsizeremoveaddclearwritereadopenclosename=\"getNamerrayistollectionHashMapSetnpututputtreamhildrenarentrootitemctionefaultrojectomponentpplicationerializCreated by IntelliJ IDEA.@author Logger ettingsFontialog JPanel JLabel JCheckBox JComboBox JList JSpinner <html>/>\r\n<head</head><body bgcolor=</body>table<?xml version=\"<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTMLtitleframecaret<a href=\"http://</a><div </div><td </td><tr </tr><p </p><hscripttext/css<img src=<!--><link rel=width=height=align=span=centerrightleftstyle=celljsp:rootxmlns:avascript";
        PRESET_BUF = "                   ;\r\n\r\n\r\n\r\n\n\n\n { {\r\n }\r\n = == != < > >= <= ? : ++ += -- -= [] [i] () ()) ())) (); ()); ())); () {// /* /** */ * opyright (c)package com.import java.utilimport javax.swingimport java.awtimport com.intellijimport org.import gnu.*;new super(this(public interface extends implements public abstract class public class private final static final protected synchronized my our instanceof throws return return;if (else {for (while (do {break;continue;throw try {catch (finally {null;true;false;void byte short int long boolean float double Object String Class System.Exception ThrowablegetsetputcontainsrunashCodeequalslengthsizeremoveaddclearwritereadopenclosename=\"getNamerrayistollectionHashMapSetnpututputtreamhildrenarentrootitemctionefaultrojectomponentpplicationerializCreated by IntelliJ IDEA.@author Logger ettingsFontialog JPanel JLabel JCheckBox JComboBox JList JSpinner <html>/>\r\n<head</head><body bgcolor=</body>table<?xml version=\"<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTMLtitleframecaret<a href=\"http://</a><div </div><td </td><tr </tr><p </p><hscripttext/css<img src=<!--><link rel=width=height=align=span=centerrightleftstyle=celljsp:rootxmlns:avascript".getBytes(StandardCharsets.UTF_8);
        OUTPUT = new VaultOutputStream();
        DEFLATER = new Deflater(9);
        INFLATER = new Inflater();
        INFLATE_BUFFER = new byte[4096];
    }

    private static class VaultOutputStream
    extends ByteArrayOutputStream {
        private static final int MIN_BUF_SIZE = 65536;
        private final byte[] MIN_BUFFER;

        VaultOutputStream() {
            super(65536);
            this.MIN_BUFFER = this.buf;
        }

        @Override
        public void reset() {
            this.count = 0;
            this.buf = this.MIN_BUFFER;
        }
    }
}

