/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.AbstractStringEnumerator;
import com.intellij.util.io.CachingEnumerator;
import com.intellij.util.io.DataEnumerator;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.PersistentEnumeratorDelegate;
import com.intellij.util.io.StorageLockContext;
import java.io.IOException;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentStringEnumerator
extends PersistentEnumeratorDelegate<String>
implements AbstractStringEnumerator {
    @Nullable
    private final CachingEnumerator<String> myCache;

    public PersistentStringEnumerator(@NotNull Path file) throws IOException {
        this(file, null);
    }

    public PersistentStringEnumerator(@NotNull Path file, @Nullable StorageLockContext storageLockContext) throws IOException {
        this(file, 4096, storageLockContext);
    }

    public PersistentStringEnumerator(@NotNull Path file, boolean cacheLastMappings) throws IOException {
        this(file, 4096, cacheLastMappings, null);
    }

    public PersistentStringEnumerator(@NotNull Path file, int initialSize) throws IOException {
        this(file, initialSize, null);
    }

    public PersistentStringEnumerator(@NotNull Path file, int initialSize, @Nullable StorageLockContext lockContext) throws IOException {
        this(file, initialSize, false, lockContext);
    }

    public PersistentStringEnumerator(@NotNull Path file, int initialSize, boolean cacheLastMappings, @Nullable StorageLockContext lockContext) throws IOException {
        super(file, EnumeratorStringDescriptor.INSTANCE, initialSize, lockContext);
        this.myCache = cacheLastMappings ? new CachingEnumerator<String>(new DataEnumerator<String>(){

            @Override
            public int enumerate(@Nullable String value) throws IOException {
                return PersistentStringEnumerator.super.enumerate(value);
            }

            @Override
            @Nullable
            public String valueOf(int idx) throws IOException {
                return (String)PersistentStringEnumerator.super.valueOf(idx);
            }
        }, EnumeratorStringDescriptor.INSTANCE) : null;
    }

    @Override
    public int enumerate(@Nullable String value) throws IOException {
        return this.myCache != null ? this.myCache.enumerate(value) : super.enumerate(value);
    }

    @Override
    @Nullable
    public String valueOf(int idx) throws IOException {
        return this.myCache != null ? this.myCache.valueOf(idx) : (String)super.valueOf(idx);
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.myCache != null) {
            this.myCache.close();
        }
    }
}

