/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.SystemProperties;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.io.FinalizationRequest;
import com.intellij.util.io.Page;
import com.intellij.util.io.PoolPageKey;
import com.intellij.util.io.RandomAccessDataFile;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PagePool {
    private final Map<PoolPageKey, Page> myProtectedQueue;
    private final Map<PoolPageKey, Page> myProbationalQueue;
    private int finalizationId = 0;
    private final TreeMap<PoolPageKey, FinalizationRequest> myFinalizationQueue = new TreeMap();
    private final Object lock = new Object();
    private final Object finalizationMonitor = new Object();
    private final PoolPageKey keyInstance = new PoolPageKey(null, -1L);
    private PoolPageKey lastFinalizedKey = null;
    private static int hits = 0;
    private static int cache_misses = 0;
    private static int same_page_hits = 0;
    private static int protected_queue_hits = 0;
    private static int probational_queue_hits = 0;
    private static int finalization_queue_hits = 0;
    public static final PagePool SHARED = new PagePool(SystemProperties.getIntProperty("idea.io.protected.pool.size", 256), SystemProperties.getIntProperty("idea.io.probatonal.pool.size", 256));
    private RandomAccessDataFile lastOwner = null;
    private long lastOffset = 0L;
    private Page lastHit = null;

    public PagePool(final int protectedPagesLimit, final int probationalPagesLimit) {
        this.myProbationalQueue = new LinkedHashMap<PoolPageKey, Page>(probationalPagesLimit * 2, 1.0f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<PoolPageKey, Page> eldest) {
                if (this.size() > probationalPagesLimit) {
                    PagePool.this.scheduleFinalization(eldest.getValue());
                    return true;
                }
                return false;
            }
        };
        this.myProtectedQueue = new LinkedHashMap<PoolPageKey, Page>(protectedPagesLimit, 1.0f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<PoolPageKey, Page> eldest) {
                if (this.size() > protectedPagesLimit) {
                    PagePool.this.myProbationalQueue.put(eldest.getKey(), eldest.getValue());
                    return true;
                }
                return false;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Page alloc(RandomAccessDataFile owner, long offset) {
        Object object = this.lock;
        synchronized (object) {
            offset -= offset % (long)Page.PAGE_SIZE;
            ++hits;
            if (owner == this.lastOwner && offset == this.lastOffset) {
                ++same_page_hits;
                return this.lastHit;
            }
            this.lastOffset = offset;
            this.lastOwner = owner;
            this.lastHit = this.hitQueues(owner, offset);
            this.flushFinalizationQueue(Integer.MAX_VALUE);
            return this.lastHit;
        }
    }

    private Page hitQueues(RandomAccessDataFile owner, long offset) {
        PoolPageKey key = this.setupKey(owner, offset);
        Page page = this.myProtectedQueue.get(key);
        if (page != null) {
            ++protected_queue_hits;
            return page;
        }
        page = this.myProbationalQueue.remove(key);
        if (page != null) {
            ++probational_queue_hits;
            this.toProtectedQueue(page);
            return page;
        }
        FinalizationRequest request = this.myFinalizationQueue.remove(key);
        if (request != null) {
            page = request.page;
            ++finalization_queue_hits;
            this.toProtectedQueue(page);
            return page;
        }
        ++cache_misses;
        page = new Page(owner, offset);
        this.myProbationalQueue.put(PagePool.keyForPage(page), page);
        return page;
    }

    private static double percent(int part, int whole) {
        return (double)part * 1000.0 / (double)whole / 10.0;
    }

    public static void printStatistics() {
        System.out.println("Total requests: " + hits);
        System.out.println("Same page hits: " + same_page_hits + " (" + PagePool.percent(same_page_hits, hits) + "%)");
        System.out.println("Protected queue hits: " + protected_queue_hits + " (" + PagePool.percent(protected_queue_hits, hits) + "%)");
        System.out.println("Probatinonal queue hits: " + probational_queue_hits + " (" + PagePool.percent(probational_queue_hits, hits) + "%)");
        System.out.println("Finalization queue hits: " + finalization_queue_hits + " (" + PagePool.percent(finalization_queue_hits, hits) + "%)");
        System.out.println("Cache misses: " + cache_misses + " (" + PagePool.percent(cache_misses, hits) + "%)");
        System.out.println("Total reads: " + RandomAccessDataFile.totalReads + ". Bytes read: " + RandomAccessDataFile.totalReadBytes);
        System.out.println("Total writes: " + RandomAccessDataFile.totalWrites + ". Bytes written: " + RandomAccessDataFile.totalWriteBytes);
    }

    private static PoolPageKey keyForPage(Page page) {
        return page.getKey();
    }

    private void toProtectedQueue(Page page) {
        this.myProtectedQueue.put(PagePool.keyForPage(page), page);
    }

    private PoolPageKey setupKey(RandomAccessDataFile owner, long offset) {
        this.keyInstance.setup(owner, offset);
        return this.keyInstance;
    }

    public void flushPages(RandomAccessDataFile owner) {
        this.flushPages(owner, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flushPages(RandomAccessDataFile owner, int maxPagesToFlush) {
        Object object = this.lock;
        synchronized (object) {
            if (this.lastOwner == owner) {
                this.scheduleFinalization(this.lastHit);
                this.lastHit = null;
                this.lastOwner = null;
            }
            boolean hasFlushes = this.scanQueue(owner, this.myProtectedQueue);
        }
        return !(hasFlushes |= this.scanQueue(owner, this.myProbationalQueue)) || this.flushFinalizationQueue(maxPagesToFlush);
    }

    private boolean flushFinalizationQueue(int maxPagesToFlush) {
        for (int count = 0; count < maxPagesToFlush; ++count) {
            FinalizationRequest request = this.retrieveFinalizationRequest();
            if (request == null) {
                return true;
            }
            this.processFinalizationRequest(request);
        }
        return false;
    }

    private boolean scanQueue(RandomAccessDataFile owner, Map<?, Page> queue) {
        Iterator<Page> iterator = queue.values().iterator();
        boolean hasFlushes = false;
        while (iterator.hasNext()) {
            Page page = iterator.next();
            if (page.getOwner() != owner) continue;
            this.scheduleFinalization(page);
            iterator.remove();
            hasFlushes = true;
        }
        return hasFlushes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean scheduleFinalization(Page page) {
        int curFinalizationId;
        Object object = this.lock;
        synchronized (object) {
            curFinalizationId = ++this.finalizationId;
        }
        FinalizationRequest request = page.prepareForFinalization(curFinalizationId);
        if (request == null) {
            return false;
        }
        Object object2 = this.lock;
        synchronized (object2) {
            this.myFinalizationQueue.put(PagePool.keyForPage(page), request);
            if (this.myFinalizationQueue.size() > 5000) {
                return true;
            }
        }
        object2 = this.finalizationMonitor;
        synchronized (object2) {
            this.finalizationMonitor.notifyAll();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFinalizationRequest(FinalizationRequest request) {
        Page page = request.page;
        try {
            page.flushIfFinalizationIdIsEqualTo(request.finalizationId);
        }
        finally {
            Object object = this.lock;
            synchronized (object) {
                this.myFinalizationQueue.remove(page.getKey());
            }
            page.recycleIfFinalizationIdIsEqualTo(request.finalizationId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private FinalizationRequest retrieveFinalizationRequest() {
        FinalizationRequest request = null;
        Object object = this.lock;
        synchronized (object) {
            if (!this.myFinalizationQueue.isEmpty()) {
                PoolPageKey key;
                if (this.lastFinalizedKey == null) {
                    key = this.myFinalizationQueue.firstKey();
                } else {
                    PoolPageKey k = this.lastFinalizedKey;
                    PoolPageKey kk = new PoolPageKey((RandomAccessDataFile)k.getOwner(), ((RandomAccessDataFile)k.getOwner()).physicalLength());
                    SortedMap<PoolPageKey, FinalizationRequest> tail = this.myFinalizationQueue.tailMap(kk);
                    if (tail == null || tail.isEmpty()) {
                        tail = this.myFinalizationQueue.tailMap(k);
                    }
                    key = tail.isEmpty() ? this.myFinalizationQueue.firstKey() : tail.firstKey();
                }
                this.lastFinalizedKey = key;
                request = this.myFinalizationQueue.get(key);
            } else {
                this.lastFinalizedKey = null;
            }
        }
        return request;
    }
}

