/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.ResizeableMappedFile;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;

public class MappedFileInputStream
extends InputStream {
    private final ResizeableMappedFile raf;
    private final long limit;
    private int cur;

    public MappedFileInputStream(@NotNull ResizeableMappedFile raf, long pos, long limit) {
        this.raf = raf;
        this.cur = (int)pos;
        this.limit = limit;
    }

    @Override
    public int available() {
        return (int)(this.limit - (long)this.cur);
    }

    @Override
    public void close() {
    }

    @Override
    public int read() throws IOException {
        int retval = -1;
        if ((long)this.cur < this.limit) {
            retval = this.raf.get(this.cur++);
        }
        return retval;
    }

    @Override
    public int read(byte @NotNull [] b, int offset, int length) throws IOException {
        if (length > this.available()) {
            length = this.available();
        }
        if (this.available() > 0) {
            this.raf.get(this.cur, b, offset, length);
            this.cur += length;
        }
        return length;
    }

    @Override
    public long skip(long amountToSkip) {
        long amountSkipped = Math.min(amountToSkip, (long)this.available());
        this.cur = (int)((long)this.cur + amountSkipped);
        return amountSkipped;
    }
}

