/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.impl.DirectInputDataDiffBuilder;
import com.intellij.util.indexing.impl.EmptyInputDataDiffBuilder;
import com.intellij.util.indexing.impl.IndexDebugProperties;
import com.intellij.util.indexing.impl.KeyValueUpdateProcessor;
import com.intellij.util.indexing.impl.RemovedKeyProcessor;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MapInputDataDiffBuilder<Key, Value>
extends DirectInputDataDiffBuilder<Key, Value> {
    @NotNull
    private final Map<Key, Value> myMap;
    private static final AtomicInteger totalRequests = new AtomicInteger();
    private static final AtomicInteger totalRemovals = new AtomicInteger();
    private static final AtomicInteger totalAdditions = new AtomicInteger();
    private static final AtomicInteger incrementalRemovals = new AtomicInteger();
    private static final AtomicInteger incrementalAdditions = new AtomicInteger();
    private static final AtomicInteger noopModifications = new AtomicInteger();

    public MapInputDataDiffBuilder(int inputId, @Nullable Map<Key, Value> map) {
        super(inputId);
        this.myMap = map == null ? Collections.emptyMap() : map;
    }

    @Override
    public boolean differentiate(@NotNull Map<Key, Value> newData, @NotNull KeyValueUpdateProcessor<? super Key, ? super Value> addProcessor, @NotNull KeyValueUpdateProcessor<? super Key, ? super Value> updateProcessor, @NotNull RemovedKeyProcessor<? super Key> removeProcessor) throws StorageException {
        if (this.myMap.isEmpty()) {
            return EmptyInputDataDiffBuilder.processAllKeyValuesAsAdded(this.myInputId, newData, addProcessor);
        }
        if (newData.isEmpty()) {
            return EmptyInputDataDiffBuilder.processAllKeyValuesAsRemoved(this.myInputId, this.myMap, removeProcessor);
        }
        int added = 0;
        int removed = 0;
        int updated = 0;
        for (Map.Entry<Key, Value> e : this.myMap.entrySet()) {
            Value newValue;
            Key key = e.getKey();
            Value oldValue = e.getValue();
            if (Comparing.equal(oldValue, newValue = newData.get(key)) && (newValue != null || newData.containsKey(key))) continue;
            if (newData.containsKey(key)) {
                updateProcessor.process(key, newValue, this.myInputId);
                ++updated;
                continue;
            }
            removeProcessor.process(key, this.myInputId);
            ++removed;
        }
        for (Map.Entry<Key, Value> e : newData.entrySet()) {
            Key newKey = e.getKey();
            if (this.myMap.containsKey(newKey)) continue;
            addProcessor.process(newKey, e.getValue(), this.myInputId);
            ++added;
        }
        if (IndexDebugProperties.DEBUG) {
            MapInputDataDiffBuilder.updateStatistics(added, removed, updated, this.myMap, newData);
        }
        return added != 0 || removed != 0 || updated != 0;
    }

    @Override
    @NotNull
    public Collection<Key> getKeys() {
        return this.myMap.keySet();
    }

    private static <Key, Value> void updateStatistics(int added, int removed, int updated, @NotNull Map<Key, Value> oldData, @NotNull Map<Key, Value> newData) {
        int requests;
        incrementalAdditions.addAndGet(added);
        incrementalRemovals.addAndGet(removed);
        totalRemovals.addAndGet(oldData.size());
        totalAdditions.addAndGet(newData.size());
        if (added == 0 && removed == 0 && updated == 0) {
            noopModifications.incrementAndGet();
        }
        if (((requests = totalRequests.incrementAndGet()) & 0xFFFF) == 0) {
            Logger.getInstance(MapInputDataDiffBuilder.class).info("Incremental index diff update: " + requests + ", removals: " + totalRemovals + "->" + incrementalRemovals + ", additions: " + totalAdditions + "->" + incrementalAdditions + ", no op changes: " + noopModifications);
        }
    }
}

