/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.graph;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.InboundSemiGraph;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class CachingSemiGraph<Node>
implements InboundSemiGraph<Node> {
    private final Set<Node> myNodes;
    private final Map<Node, List<Node>> myIn;

    @NotNull
    public static <T> InboundSemiGraph<T> cache(@NotNull InboundSemiGraph<T> original) {
        return new CachingSemiGraph<T>(original);
    }

    private CachingSemiGraph(@NotNull InboundSemiGraph<Node> original) {
        this.myNodes = new LinkedHashSet<Node>(original.getNodes());
        this.myIn = new THashMap();
        for (Node node : this.myNodes) {
            Iterator<Node> inIterator = original.getIn(node);
            if (!inIterator.hasNext()) continue;
            ArrayList value = new ArrayList();
            ContainerUtil.addAll(value, inIterator);
            this.myIn.put(node, value);
        }
    }

    @Override
    @NotNull
    public Collection<Node> getNodes() {
        return this.myNodes;
    }

    @Override
    @NotNull
    public Iterator<Node> getIn(Node n) {
        List<Node> inNodes = this.myIn.get(n);
        return inNodes != null ? inNodes.iterator() : Collections.emptyIterator();
    }
}

